/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.spigotmc.SpigotWorldConfig;

public class ChunkProviderFlat
extends ChunkGenerator {
    public static final MapCodec<ChunkProviderFlat> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GeneratorSettingsFlat.a.fieldOf("settings").forGetter(ChunkProviderFlat::h)).apply((Applicative)instance, instance.stable(ChunkProviderFlat::new)));
    private final GeneratorSettingsFlat d;

    public ChunkProviderFlat(GeneratorSettingsFlat generatorsettingsflat) {
        this(generatorsettingsflat, new WorldChunkManagerHell(generatorsettingsflat.d()));
    }

    public ChunkProviderFlat(GeneratorSettingsFlat generatorsettingsflat, WorldChunkManager worldchunkmanager) {
        super(worldchunkmanager, SystemUtils.b(generatorsettingsflat::a));
        this.d = generatorsettingsflat;
    }

    @Override
    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> holderlookup, RandomState randomstate, long i2, SpigotWorldConfig conf) {
        Stream stream = this.d.c().map(HolderSet::a).orElseGet(() -> holderlookup.c().map(holder_c -> holder_c));
        return ChunkGeneratorStructureState.createForFlat(randomstate, i2, this.b, stream, conf);
    }

    @Override
    protected MapCodec<? extends ChunkGenerator> b() {
        return c;
    }

    public GeneratorSettingsFlat h() {
        return this.d;
    }

    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, StructureManager structuremanager, RandomState randomstate, IChunkAccess ichunkaccess) {
    }

    @Override
    public int a(LevelHeightAccessor levelheightaccessor) {
        return levelheightaccessor.L_() + Math.min(levelheightaccessor.M_(), this.d.f().size());
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Blender blender, RandomState randomstate, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        List<IBlockData> list = this.d.f();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        HeightMap heightmap = ichunkaccess.a(HeightMap.Type.c);
        HeightMap heightmap1 = ichunkaccess.a(HeightMap.Type.a);
        for (int i2 = 0; i2 < Math.min(ichunkaccess.M_(), list.size()); ++i2) {
            IBlockData iblockdata = list.get(i2);
            if (iblockdata == null) continue;
            int j2 = ichunkaccess.L_() + i2;
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int l2 = 0; l2 < 16; ++l2) {
                    ichunkaccess.a((BlockPosition)blockposition_mutableblockposition.d(k2, j2, l2), iblockdata);
                    heightmap.a(k2, j2, l2, iblockdata);
                    heightmap1.a(k2, j2, l2, iblockdata);
                }
            }
        }
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    @Override
    public int a(int i2, int j2, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        List<IBlockData> list = this.d.f();
        for (int k2 = Math.min(list.size() - 1, levelheightaccessor.ao()); k2 >= 0; --k2) {
            IBlockData iblockdata = list.get(k2);
            if (iblockdata == null || !heightmap_type.e().test(iblockdata)) continue;
            return levelheightaccessor.L_() + k2 + 1;
        }
        return levelheightaccessor.L_();
    }

    @Override
    public BlockColumn a(int i2, int j2, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return new BlockColumn(levelheightaccessor.L_(), (IBlockData[])this.d.f().stream().limit(levelheightaccessor.M_()).map(iblockdata -> iblockdata == null ? Blocks.a.m() : iblockdata).toArray(IBlockData[]::new));
    }

    @Override
    public void a(List<String> list, RandomState randomstate, BlockPosition blockposition) {
    }

    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, long i2, RandomState randomstate, BiomeManager biomemanager, StructureManager structuremanager, IChunkAccess ichunkaccess) {
    }

    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess) {
    }

    @Override
    public int g() {
        return 0;
    }

    @Override
    public int e() {
        return 384;
    }

    @Override
    public int f() {
        return -63;
    }
}

