/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import java.util.stream.Collectors;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftVehicle;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;

public abstract class CraftBoat
extends CraftVehicle
implements Boat {
    public CraftBoat(CraftServer server, AbstractBoat entity) {
        super(server, entity);
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().ap());
    }

    public void setWoodType(TreeSpecies species) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().ap());
    }

    public void setBoatType(Boat.Type type) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Boat.Status getStatus() {
        return CraftBoat.boatStatusFromNms(this.getHandle().aX);
    }

    @Override
    public AbstractBoat getHandle() {
        return (AbstractBoat)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat{boatType=" + String.valueOf(this.getBoatType()) + ",status=" + String.valueOf(this.getStatus()) + ",passengers=" + this.getPassengers().stream().map(Entity::toString).collect(Collectors.joining("-", "{", "}")) + "}";
    }

    public static Boat.Type boatTypeFromNms(EntityTypes<?> boatType) {
        if (boatType == EntityTypes.aI || boatType == EntityTypes.aJ) {
            return Boat.Type.OAK;
        }
        if (boatType == EntityTypes.n || boatType == EntityTypes.o) {
            return Boat.Type.BIRCH;
        }
        if (boatType == EntityTypes.b || boatType == EntityTypes.c) {
            return Boat.Type.ACACIA;
        }
        if (boatType == EntityTypes.x || boatType == EntityTypes.y) {
            return Boat.Type.CHERRY;
        }
        if (boatType == EntityTypes.av || boatType == EntityTypes.aw) {
            return Boat.Type.JUNGLE;
        }
        if (boatType == EntityTypes.br || boatType == EntityTypes.bs) {
            return Boat.Type.SPRUCE;
        }
        if (boatType == EntityTypes.G || boatType == EntityTypes.H) {
            return Boat.Type.DARK_OAK;
        }
        if (boatType == EntityTypes.aC || boatType == EntityTypes.aD) {
            return Boat.Type.MANGROVE;
        }
        if (boatType == EntityTypes.k || boatType == EntityTypes.j) {
            return Boat.Type.BAMBOO;
        }
        throw new EnumConstantNotPresentException(Boat.Type.class, boatType.toString());
    }

    public static Boat.Status boatStatusFromNms(AbstractBoat.EnumStatus enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case AbstractBoat.EnumStatus.e -> Boat.Status.IN_AIR;
            case AbstractBoat.EnumStatus.d -> Boat.Status.ON_LAND;
            case AbstractBoat.EnumStatus.b -> Boat.Status.UNDER_WATER;
            case AbstractBoat.EnumStatus.c -> Boat.Status.UNDER_FLOWING_WATER;
            case AbstractBoat.EnumStatus.a -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(EntityTypes<?> boatType) {
        if (boatType == EntityTypes.br || boatType == EntityTypes.bs) {
            return TreeSpecies.REDWOOD;
        }
        if (boatType == EntityTypes.n || boatType == EntityTypes.o) {
            return TreeSpecies.BIRCH;
        }
        if (boatType == EntityTypes.av || boatType == EntityTypes.aw) {
            return TreeSpecies.JUNGLE;
        }
        if (boatType == EntityTypes.b || boatType == EntityTypes.c) {
            return TreeSpecies.ACACIA;
        }
        if (boatType == EntityTypes.G || boatType == EntityTypes.H) {
            return TreeSpecies.DARK_OAK;
        }
        return TreeSpecies.GENERIC;
    }
}

