/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.item.component.CustomData;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R5.inventory.SerializableMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaEntityTag
extends CraftMetaItem {
    private static final Set<Material> ENTITY_TAGGABLE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.COD_BUCKET, Material.PUFFERFISH_BUCKET, Material.SALMON_BUCKET, Material.ITEM_FRAME, Material.GLOW_ITEM_FRAME, Material.PAINTING});
    static final CraftMetaItem.ItemMetaKeyType<CustomData> ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType<CustomData>(DataComponents.Y, "EntityTag", "entity-tag");
    NBTTagCompound entityTag;

    CraftMetaEntityTag(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaEntityTag)) {
            return;
        }
        CraftMetaEntityTag entity = (CraftMetaEntityTag)meta;
        this.entityTag = entity.entityTag;
    }

    CraftMetaEntityTag(DataComponentPatch tag) {
        super(tag);
        CraftMetaEntityTag.getOrEmpty(tag, ENTITY_TAG).ifPresent(nbt -> {
            this.entityTag = nbt.d();
        });
    }

    CraftMetaEntityTag(Map<String, Object> map) {
        super(map);
    }

    @Override
    void deserializeInternal(NBTTagCompound tag, Object context) {
        super.deserializeInternal(tag, context);
        tag.m(CraftMetaEntityTag.ENTITY_TAG.NBT).ifPresent(entityTag -> {
            this.entityTag = entityTag;
        });
    }

    @Override
    void serializeInternal(Map<String, NBTBase> internalTags) {
        if (this.entityTag != null && !this.entityTag.j()) {
            internalTags.put(CraftMetaEntityTag.ENTITY_TAG.NBT, this.entityTag);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.entityTag != null) {
            tag.put(ENTITY_TAG, CustomData.a(this.entityTag));
        }
    }

    @Override
    boolean applicableTo(Material type) {
        return ENTITY_TAGGABLE_MATERIALS.contains(type);
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isEntityTagEmpty();
    }

    boolean isEntityTagEmpty() {
        return this.entityTag == null;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaEntityTag) {
            CraftMetaEntityTag that = (CraftMetaEntityTag)meta;
            return this.entityTag != null ? that.entityTag != null && this.entityTag.equals(that.entityTag) : this.entityTag == null;
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaEntityTag || this.isEntityTagEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.entityTag != null) {
            hash = 73 * hash + this.entityTag.hashCode();
        }
        return original != hash ? CraftMetaEntityTag.class.hashCode() ^ hash : hash;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        return builder;
    }

    @Override
    public CraftMetaEntityTag clone() {
        CraftMetaEntityTag clone = (CraftMetaEntityTag)super.clone();
        if (this.entityTag != null) {
            clone.entityTag = this.entityTag.l();
        }
        return clone;
    }
}

