/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory.components;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.component.BlocksAttacks;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.CraftSound;
import org.bukkit.craftbukkit.v1_21_R5.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R5.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R5.inventory.components.CraftHolderUtil;
import org.bukkit.craftbukkit.v1_21_R5.tag.CraftDamageTag;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.damage.DamageType;
import org.bukkit.inventory.meta.components.BlocksAttacksComponent;

@SerializableAs(value="BlocksAttacks")
public final class CraftBlocksAttacksComponent
implements BlocksAttacksComponent {
    private BlocksAttacks handle;

    public CraftBlocksAttacksComponent(BlocksAttacks blocksAttacks) {
        this.handle = blocksAttacks;
    }

    public CraftBlocksAttacksComponent(CraftBlocksAttacksComponent blocksAttacks) {
        this.handle = blocksAttacks.handle;
    }

    public CraftBlocksAttacksComponent(Map<String, Object> map) {
        Float blockDelaySeconds = SerializableMeta.getObject(Float.class, map, "default-mining-speed", false);
        Float disableCooldownScale = SerializableMeta.getObject(Float.class, map, "disable-cooldown-scale", false);
        ImmutableList.Builder reduction = ImmutableList.builder();
        Iterable rawReductionList = SerializableMeta.getObject(Iterable.class, map, "damage-reductions", true);
        if (rawReductionList != null) {
            for (Object obj : rawReductionList) {
                Preconditions.checkArgument((boolean)(obj instanceof BlocksAttacksComponent.DamageReduction), (String)"Object (%s) in reduction list is not valid", obj.getClass());
                CraftDamageReduction rule = new CraftDamageReduction((BlocksAttacksComponent.DamageReduction)obj);
                reduction.add((Object)rule);
            }
        }
        Float itemDamageThreshold = SerializableMeta.getObject(Float.class, map, "item-damage-threshold", false);
        Float itemDamageBase = SerializableMeta.getObject(Float.class, map, "item-damage-base", false);
        Float itemDamageFactor = SerializableMeta.getObject(Float.class, map, "item-damage-factor", false);
        String bypassedBy = SerializableMeta.getString(map, "bypassed-by", true);
        TagKey<net.minecraft.world.damagesource.DamageType> tag = null;
        if (bypassedBy != null) {
            tag = TagKey.a(Registries.aR, MinecraftKey.a(bypassedBy));
        }
        Holder blockSound = null;
        String blockSnd = SerializableMeta.getString(map, "block-sound", true);
        if (blockSnd != null) {
            blockSound = BuiltInRegistries.b.c(MinecraftKey.a(blockSnd)).orElse(null);
        }
        Holder disableSound = null;
        String disableSnd = SerializableMeta.getString(map, "disable-sound", true);
        if (disableSnd != null) {
            disableSound = BuiltInRegistries.b.c(MinecraftKey.a(disableSnd)).orElse(null);
        }
        this.handle = new BlocksAttacks(blockDelaySeconds.floatValue(), disableCooldownScale.floatValue(), reduction.build().stream().map(CraftDamageReduction::new).map(CraftDamageReduction::getHandle).toList(), new BlocksAttacks.b(itemDamageThreshold.floatValue(), itemDamageBase.floatValue(), itemDamageFactor.floatValue()), Optional.ofNullable(tag), Optional.ofNullable(blockSound), Optional.ofNullable(disableSound));
    }

    public Map<String, Object> serialize() {
        Sound disableSound;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("block-delay-seconds", Float.valueOf(this.getBlockDelaySeconds()));
        result.put("disable-cooldown-scale", Float.valueOf(this.getDisableCooldownScale()));
        result.put("damage-reductions", this.getDamageReductions());
        result.put("item-damage-threshold", Float.valueOf(this.getItemDamageThreshold()));
        result.put("item-damage-base", Float.valueOf(this.getItemDamageBase()));
        result.put("item-damage-factor", Float.valueOf(this.getItemDamageFactor()));
        this.handle.f().ifPresent(bypassedBy -> result.put("bypassed-by", bypassedBy.b().toString()));
        Sound blockSound = this.getBlockSound();
        if (blockSound != null) {
            result.put("block-sound", blockSound);
        }
        if ((disableSound = this.getDisableSound()) != null) {
            result.put("disable-sound", disableSound);
        }
        return result;
    }

    public BlocksAttacks getHandle() {
        return this.handle;
    }

    public float getBlockDelaySeconds() {
        return this.handle.b();
    }

    public void setBlockDelaySeconds(float seconds) {
        Preconditions.checkArgument((seconds >= 0.0f ? 1 : 0) != 0, (Object)"seconds cannot be negative");
        this.handle = new BlocksAttacks(seconds, this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public float getDisableCooldownScale() {
        return this.handle.c();
    }

    public void setDisableCooldownScale(float scale) {
        Preconditions.checkArgument((scale >= 0.0f ? 1 : 0) != 0, (Object)"scale cannot be negative");
        this.handle = new BlocksAttacks(this.handle.b(), scale, this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public List<BlocksAttacksComponent.DamageReduction> getDamageReductions() {
        return this.handle.d().stream().map(CraftDamageReduction::new).collect(Collectors.toList());
    }

    public void setDamageReductions(List<BlocksAttacksComponent.DamageReduction> reductions) {
        Preconditions.checkArgument((reductions != null ? 1 : 0) != 0, (Object)"reductions must not be null");
        this.handle = new BlocksAttacks(this.handle.b(), this.handle.c(), reductions.stream().map(CraftDamageReduction::new).map(CraftDamageReduction::getHandle).toList(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public BlocksAttacksComponent.DamageReduction addDamageReduction(DamageType type, float base, float factor, float horizontalBlockingAngle) {
        return this.addRule(type != null ? HolderSet.a(CraftDamageType.bukkitToMinecraftHolder(type)) : null, base, factor, horizontalBlockingAngle);
    }

    public BlocksAttacksComponent.DamageReduction addDamageReduction(Collection<DamageType> types, float base, float factor, float horizontalBlockingAngle) {
        return this.addRule(types != null ? HolderSet.a(types.stream().map(CraftDamageType::bukkitToMinecraftHolder).toList()) : null, base, factor, horizontalBlockingAngle);
    }

    public BlocksAttacksComponent.DamageReduction addDamageReduction(Tag<DamageType> tag, float base, float factor, float horizontalBlockingAngle) {
        Preconditions.checkArgument((tag == null || tag instanceof CraftDamageTag ? 1 : 0) != 0, (Object)"tag must be a damage tag");
        return this.addRule(tag != null ? ((CraftDamageTag)tag).getHandle() : null, base, factor, horizontalBlockingAngle);
    }

    private BlocksAttacksComponent.DamageReduction addRule(HolderSet<net.minecraft.world.damagesource.DamageType> types, float base, float factor, float horizontalBlockingAngle) {
        BlocksAttacks.a reduction = new BlocksAttacks.a(horizontalBlockingAngle, Optional.ofNullable(types), base, factor);
        ArrayList<BlocksAttacks.a> reductions = new ArrayList<BlocksAttacks.a>(this.handle.d().size() + 1);
        reductions.addAll(this.handle.d());
        reductions.add(reduction);
        this.handle = new BlocksAttacks(this.handle.b(), this.handle.c(), reductions, this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h());
        return new CraftDamageReduction(reduction);
    }

    public boolean removeDamageReduction(BlocksAttacksComponent.DamageReduction reduction) {
        Preconditions.checkArgument((reduction != null ? 1 : 0) != 0, (Object)"reduction must not be null");
        ArrayList<BlocksAttacks.a> reductions = new ArrayList<BlocksAttacks.a>(this.handle.d());
        boolean removed = reductions.remove(((CraftDamageReduction)reduction).handle);
        this.handle = new BlocksAttacks(this.handle.b(), this.handle.c(), reductions, this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h());
        return removed;
    }

    public float getItemDamageThreshold() {
        return this.handle.e().a();
    }

    public void setItemDamageThreshold(float threshold) {
        BlocksAttacks.b itemDamage = this.handle.e();
        this.handle = new BlocksAttacks(this.handle.b(), this.handle.c(), this.handle.d(), new BlocksAttacks.b(threshold, itemDamage.b(), itemDamage.c()), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public float getItemDamageBase() {
        return this.handle.e().b();
    }

    public void setItemDamageBase(float base) {
        BlocksAttacks.b itemDamage = this.handle.e();
        this.handle = new BlocksAttacks(this.handle.b(), this.handle.c(), this.handle.d(), new BlocksAttacks.b(itemDamage.a(), base, itemDamage.c()), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public float getItemDamageFactor() {
        return this.handle.e().c();
    }

    public void setItemDamageFactor(float factor) {
        BlocksAttacks.b itemDamage = this.handle.e();
        this.handle = new BlocksAttacks(this.handle.b(), this.handle.c(), this.handle.d(), new BlocksAttacks.b(itemDamage.a(), itemDamage.b(), factor), this.handle.f(), this.handle.g(), this.handle.h());
    }

    public Sound getBlockSound() {
        return this.handle.g().map(CraftSound::minecraftHolderToBukkit).orElse(null);
    }

    public void setBlockSound(Sound sound) {
        this.handle = new BlocksAttacks(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), Optional.ofNullable(sound).map(CraftSound::bukkitToMinecraftHolder), this.handle.h());
    }

    public Sound getDisableSound() {
        return this.handle.h().map(CraftSound::minecraftHolderToBukkit).orElse(null);
    }

    public void setDisableSound(Sound sound) {
        this.handle = new BlocksAttacks(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), Optional.ofNullable(sound).map(CraftSound::bukkitToMinecraftHolder));
    }

    public Tag<DamageType> getBypassedBy() {
        return this.handle.f().map(bypassedBy -> Bukkit.getTag((String)"damage_types", (NamespacedKey)CraftNamespacedKey.fromMinecraft(bypassedBy.b()), DamageType.class)).orElse(null);
    }

    public void setBypassedBy(Tag<DamageType> tag) {
        this.handle = new BlocksAttacks(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), Optional.ofNullable(tag).map(t2 -> ((CraftDamageTag)t2).getHandle().h()), this.handle.g(), this.handle.h());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftBlocksAttacksComponent other = (CraftBlocksAttacksComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftBlocksAttacksComponent{handle=" + String.valueOf(this.handle) + "}";
    }

    @SerializableAs(value="DamageReduction")
    public static class CraftDamageReduction
    implements BlocksAttacksComponent.DamageReduction {
        private BlocksAttacks.a handle;

        public CraftDamageReduction(BlocksAttacks.a handle) {
            this.handle = handle;
        }

        public CraftDamageReduction(BlocksAttacksComponent.DamageReduction bukkit) {
            BlocksAttacks.a toCopy = ((CraftDamageReduction)bukkit).handle;
            this.handle = new BlocksAttacks.a(toCopy.a(), toCopy.b(), toCopy.c(), toCopy.d());
        }

        public CraftDamageReduction(Map<String, Object> map) {
            Float base = SerializableMeta.getObject(Float.class, map, "base", false);
            Float factor = SerializableMeta.getObject(Float.class, map, "factor", false);
            Float horizontalBlockingAngle = SerializableMeta.getObject(Float.class, map, "horizontal-blocking-angle", false);
            HolderSet typesSet = null;
            Object types = SerializableMeta.getObject(Object.class, map, "types", true);
            if (types != null) {
                typesSet = CraftHolderUtil.parse(types, Registries.aR, CraftRegistry.getMinecraftRegistry(Registries.aR));
            }
            this.handle = new BlocksAttacks.a(horizontalBlockingAngle.floatValue(), Optional.ofNullable(typesSet), base.floatValue(), factor.floatValue());
        }

        public Map<String, Object> serialize() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("base", Float.valueOf(this.getBase()));
            result.put("factor", Float.valueOf(this.getFactor()));
            result.put("horizontal-blocking-angle", Float.valueOf(this.getHorizontalBlockingAngle()));
            this.handle.b().ifPresent(type -> CraftHolderUtil.serialize(result, "types", type));
            return result;
        }

        public BlocksAttacks.a getHandle() {
            return this.handle;
        }

        public Collection<DamageType> getTypes() {
            return this.handle.b().map(type -> type.a().map(CraftDamageType::minecraftHolderToBukkit).toList()).orElse(null);
        }

        public void setTypes(DamageType type) {
            this.handle = new BlocksAttacks.a(this.handle.a(), Optional.ofNullable(type).map(t2 -> HolderSet.a(CraftDamageType.bukkitToMinecraftHolder(t2))), this.handle.c(), this.handle.d());
        }

        public void setTypes(Collection<DamageType> types) {
            this.handle = new BlocksAttacks.a(this.handle.a(), Optional.ofNullable(types).map(t2 -> HolderSet.a(t2.stream().map(CraftDamageType::bukkitToMinecraftHolder).toList())), this.handle.c(), this.handle.d());
        }

        public void setTypes(Tag<DamageType> tag) {
            Preconditions.checkArgument((tag == null || tag instanceof CraftDamageTag ? 1 : 0) != 0, (Object)"tag must be a damage tag");
            this.handle = new BlocksAttacks.a(this.handle.a(), Optional.ofNullable(tag).map(t2 -> ((CraftDamageTag)t2).getHandle()), this.handle.c(), this.handle.d());
        }

        public float getBase() {
            return this.handle.c();
        }

        public void setBase(float base) {
            this.handle = new BlocksAttacks.a(this.handle.a(), this.handle.b(), base, this.handle.d());
        }

        public float getFactor() {
            return this.handle.d();
        }

        public void setFactor(float factor) {
            this.handle = new BlocksAttacks.a(this.handle.a(), this.handle.b(), this.handle.c(), factor);
        }

        public float getHorizontalBlockingAngle() {
            return this.handle.a();
        }

        public void setHorizontalBlockingAngle(float horizontalBlockingAngle) {
            this.handle = new BlocksAttacks.a(horizontalBlockingAngle, this.handle.b(), this.handle.c(), this.handle.d());
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.handle);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CraftDamageReduction other = (CraftDamageReduction)obj;
            return Objects.equals(this.handle, other.handle);
        }

        public String toString() {
            return "CraftDamageReduction{handle=" + String.valueOf(this.handle) + "}";
        }
    }
}

