/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.potion;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionEffectType;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftPotionUtil {
    private static final BiMap<PotionType, PotionType> upgradeable = ImmutableBiMap.builder().put((Object)PotionType.LEAPING, (Object)PotionType.STRONG_LEAPING).put((Object)PotionType.SWIFTNESS, (Object)PotionType.STRONG_SWIFTNESS).put((Object)PotionType.HEALING, (Object)PotionType.STRONG_HEALING).put((Object)PotionType.HARMING, (Object)PotionType.STRONG_HARMING).put((Object)PotionType.POISON, (Object)PotionType.STRONG_POISON).put((Object)PotionType.REGENERATION, (Object)PotionType.STRONG_REGENERATION).put((Object)PotionType.STRENGTH, (Object)PotionType.STRONG_STRENGTH).put((Object)PotionType.SLOWNESS, (Object)PotionType.STRONG_SLOWNESS).put((Object)PotionType.TURTLE_MASTER, (Object)PotionType.STRONG_TURTLE_MASTER).build();
    private static final BiMap<PotionType, PotionType> extendable = ImmutableBiMap.builder().put((Object)PotionType.NIGHT_VISION, (Object)PotionType.LONG_NIGHT_VISION).put((Object)PotionType.INVISIBILITY, (Object)PotionType.LONG_INVISIBILITY).put((Object)PotionType.LEAPING, (Object)PotionType.LONG_LEAPING).put((Object)PotionType.FIRE_RESISTANCE, (Object)PotionType.LONG_FIRE_RESISTANCE).put((Object)PotionType.SWIFTNESS, (Object)PotionType.LONG_SWIFTNESS).put((Object)PotionType.SLOWNESS, (Object)PotionType.LONG_SLOWNESS).put((Object)PotionType.WATER_BREATHING, (Object)PotionType.LONG_WATER_BREATHING).put((Object)PotionType.POISON, (Object)PotionType.LONG_POISON).put((Object)PotionType.REGENERATION, (Object)PotionType.LONG_REGENERATION).put((Object)PotionType.STRENGTH, (Object)PotionType.LONG_STRENGTH).put((Object)PotionType.WEAKNESS, (Object)PotionType.LONG_WEAKNESS).put((Object)PotionType.TURTLE_MASTER, (Object)PotionType.LONG_TURTLE_MASTER).put((Object)PotionType.SLOW_FALLING, (Object)PotionType.LONG_SLOW_FALLING).build();

    public static PotionType fromBukkit(PotionData data) {
        if (data == null) {
            return null;
        }
        PotionType type = data.isUpgraded() ? (PotionType)upgradeable.get((Object)data.getType()) : (data.isExtended() ? (PotionType)extendable.get((Object)data.getType()) : data.getType());
        Preconditions.checkNotNull((Object)type, (Object)("Unknown potion type from data " + String.valueOf(data)));
        return type;
    }

    public static PotionData toBukkit(PotionType type) {
        if (type == null) {
            return null;
        }
        PotionType potionType = (PotionType)extendable.inverse().get((Object)type);
        if (potionType != null) {
            return new PotionData(potionType, true, false);
        }
        potionType = (PotionType)upgradeable.inverse().get((Object)type);
        if (potionType != null) {
            return new PotionData(potionType, false, true);
        }
        return new PotionData(type, false, false);
    }

    public static MobEffect fromBukkit(PotionEffect effect) {
        Holder<MobEffectList> type = CraftPotionEffectType.bukkitToMinecraftHolder(effect.getType());
        return new MobEffect(type, effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public static PotionEffect toBukkit(MobEffect effect) {
        PotionEffectType type = CraftPotionEffectType.minecraftHolderToBukkit(effect.c());
        int amp = effect.e();
        int duration = effect.d();
        boolean ambient = effect.f();
        boolean particles = effect.g();
        return new PotionEffect(type, duration, amp, ambient, particles);
    }

    public static boolean equals(Holder<MobEffectList> mobEffect, PotionEffectType type) {
        PotionEffectType typeV = CraftPotionEffectType.minecraftHolderToBukkit(mobEffect);
        return typeV.equals(type);
    }
}

