/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.WorldData;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R5.util.DummyGeneratorAccess;

public class BlockStateListPopulator
extends DummyGeneratorAccess {
    private final GeneratorAccess world;
    private final Map<BlockPosition, IBlockData> dataMap = new HashMap<BlockPosition, IBlockData>();
    private final Map<BlockPosition, TileEntity> entityMap = new HashMap<BlockPosition, TileEntity>();
    private final LinkedHashMap<BlockPosition, CraftBlockState> list;

    public BlockStateListPopulator(GeneratorAccess world) {
        this(world, new LinkedHashMap<BlockPosition, CraftBlockState>());
    }

    private BlockStateListPopulator(GeneratorAccess world, LinkedHashMap<BlockPosition, CraftBlockState> list) {
        this.world = world;
        this.list = list;
    }

    @Override
    public IBlockData a_(BlockPosition bp) {
        IBlockData blockData = this.dataMap.get(bp);
        return blockData != null ? blockData : this.world.a_(bp);
    }

    @Override
    public Fluid b_(BlockPosition bp) {
        IBlockData blockData = this.dataMap.get(bp);
        return blockData != null ? blockData.y() : this.world.b_(bp);
    }

    @Override
    public TileEntity c_(BlockPosition blockposition) {
        if (this.entityMap.containsKey(blockposition)) {
            return this.entityMap.get(blockposition);
        }
        return this.world.c_(blockposition);
    }

    @Override
    public boolean a(BlockPosition position, IBlockData data, int flag) {
        position = position.j();
        this.list.remove(position);
        this.dataMap.put(position, data);
        if (data.x()) {
            this.entityMap.put(position, ((ITileEntity)((Object)data.b())).a(position, data));
        } else {
            this.entityMap.put(position, null);
        }
        CraftBlockState state = (CraftBlockState)CraftBlock.at(this, position).getState();
        state.setFlag(flag);
        state.setWorldHandle(this.world);
        this.list.put(position, state);
        return true;
    }

    @Override
    public WorldServer getMinecraftWorld() {
        return this.world.getMinecraftWorld();
    }

    public void refreshTiles() {
        for (CraftBlockState state : this.list.values()) {
            if (!(state instanceof CraftBlockEntityState)) continue;
            ((CraftBlockEntityState)state).refreshSnapshot();
        }
    }

    public void updateList() {
        for (BlockState blockState : this.list.values()) {
            blockState.update(true);
        }
    }

    public Set<BlockPosition> getBlocks() {
        return this.list.keySet();
    }

    public List<CraftBlockState> getList() {
        return new ArrayList<CraftBlockState>(this.list.values());
    }

    public GeneratorAccess getWorld() {
        return this.world;
    }

    @Override
    public int L_() {
        return this.getWorld().L_();
    }

    @Override
    public int M_() {
        return this.getWorld().M_();
    }

    @Override
    public boolean a(BlockPosition blockposition, Predicate<IBlockData> predicate) {
        return predicate.test(this.a_(blockposition));
    }

    @Override
    public boolean b(BlockPosition bp, Predicate<Fluid> prdct) {
        return this.world.b(bp, prdct);
    }

    @Override
    public DimensionManager G_() {
        return this.world.G_();
    }

    @Override
    public IRegistryCustom K_() {
        return this.world.K_();
    }

    @Override
    public WorldData D_() {
        return this.world.D_();
    }

    @Override
    public long J_() {
        return this.world.J_();
    }

    @Override
    public RandomSource H_() {
        return this.world.H_();
    }

    @Override
    public IChunkProvider T() {
        return this.world.T();
    }
}

