/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.HolderGetter;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record Advancement(Optional<ResourceLocation> parent, Optional<DisplayInfo> display, AdvancementRewards rewards, Map<String, Criterion<?>> criteria, AdvancementRequirements requirements, boolean sendsTelemetryEvent, Optional<Component> name) {
    private static final Codec<Map<String, Criterion<?>>> CRITERIA_CODEC = Codec.unboundedMap((Codec)Codec.STRING, Criterion.CODEC).validate((T var0) -> var0.isEmpty() ? DataResult.error(() -> "Advancement criteria cannot be empty") : DataResult.success((Object)var0));
    public static final Codec<Advancement> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ResourceLocation.CODEC.optionalFieldOf("parent").forGetter(Advancement::parent), (App)DisplayInfo.CODEC.optionalFieldOf("display").forGetter(Advancement::display), (App)AdvancementRewards.CODEC.optionalFieldOf("rewards", (Object)AdvancementRewards.EMPTY).forGetter(Advancement::rewards), (App)CRITERIA_CODEC.fieldOf("criteria").forGetter(Advancement::criteria), (App)AdvancementRequirements.CODEC.optionalFieldOf("requirements").forGetter(var0 -> Optional.of(var0.requirements())), (App)Codec.BOOL.optionalFieldOf("sends_telemetry_event", (Object)false).forGetter(Advancement::sendsTelemetryEvent)).apply((Applicative)var02, (var0, var1, var2, var3, var4, var5) -> {
        AdvancementRequirements var6 = var4.orElseGet(() -> AdvancementRequirements.allOf(var3.keySet()));
        return new Advancement((Optional<ResourceLocation>)var0, (Optional<DisplayInfo>)var1, (AdvancementRewards)var2, (Map<String, Criterion<?>>)var3, var6, (boolean)var5);
    })).validate(Advancement::validate);
    public static final StreamCodec<RegistryFriendlyByteBuf, Advancement> STREAM_CODEC = StreamCodec.ofMember(Advancement::write, Advancement::read);

    public Advancement(Optional<ResourceLocation> var0, Optional<DisplayInfo> var1, AdvancementRewards var2, Map<String, Criterion<?>> var3, AdvancementRequirements var4, boolean var5) {
        this(var0, var1, var2, Map.copyOf(var3), var4, var5, var1.map(Advancement::decorateName));
    }

    private static DataResult<Advancement> validate(Advancement var0) {
        return var0.requirements().validate(var0.criteria().keySet()).map(var1 -> var0);
    }

    private static Component decorateName(DisplayInfo var0) {
        Component var12 = var0.getTitle();
        ChatFormatting var2 = var0.getType().getChatColor();
        MutableComponent var3 = ComponentUtils.mergeStyles(var12.copy(), Style.EMPTY.withColor(var2)).append("\n").append(var0.getDescription());
        MutableComponent var4 = var12.copy().withStyle(var1 -> var1.withHoverEvent(new HoverEvent.ShowText(var3)));
        return ComponentUtils.wrapInSquareBrackets(var4).withStyle(var2);
    }

    public static Component name(AdvancementHolder var0) {
        return var0.value().name().orElseGet(() -> Component.literal(var0.id().toString()));
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeOptional(this.parent, FriendlyByteBuf::writeResourceLocation);
        DisplayInfo.STREAM_CODEC.apply(ByteBufCodecs::optional).encode(var0, this.display);
        this.requirements.write(var0);
        var0.writeBoolean(this.sendsTelemetryEvent);
    }

    private static Advancement read(RegistryFriendlyByteBuf var0) {
        return new Advancement(var0.readOptional(FriendlyByteBuf::readResourceLocation), (Optional)DisplayInfo.STREAM_CODEC.apply(ByteBufCodecs::optional).decode(var0), AdvancementRewards.EMPTY, Map.of(), new AdvancementRequirements(var0), var0.readBoolean());
    }

    public boolean isRoot() {
        return this.parent.isEmpty();
    }

    public void validate(ProblemReporter var0, HolderGetter.Provider var1) {
        this.criteria.forEach((var2, var3) -> {
            CriterionValidator var4 = new CriterionValidator(var0.forChild(new ProblemReporter.RootFieldPathElement((String)var2)), var1);
            var3.triggerInstance().validate(var4);
        });
    }

    public static class Builder {
        private Optional<ResourceLocation> parent = Optional.empty();
        private Optional<DisplayInfo> display = Optional.empty();
        private AdvancementRewards rewards = AdvancementRewards.EMPTY;
        private final ImmutableMap.Builder<String, Criterion<?>> criteria = ImmutableMap.builder();
        private Optional<AdvancementRequirements> requirements = Optional.empty();
        private AdvancementRequirements.Strategy requirementsStrategy = AdvancementRequirements.Strategy.AND;
        private boolean sendsTelemetryEvent;

        public static Builder advancement() {
            return new Builder().sendsTelemetryEvent();
        }

        public static Builder recipeAdvancement() {
            return new Builder();
        }

        public Builder parent(AdvancementHolder var0) {
            this.parent = Optional.of(var0.id());
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder parent(ResourceLocation var0) {
            this.parent = Optional.of(var0);
            return this;
        }

        public Builder display(ItemStack var0, Component var1, Component var2, @Nullable ResourceLocation var3, AdvancementType var4, boolean var5, boolean var6, boolean var7) {
            return this.display(new DisplayInfo(var0, var1, var2, Optional.ofNullable(var3).map(ClientAsset.ResourceTexture::new), var4, var5, var6, var7));
        }

        public Builder display(ItemLike var0, Component var1, Component var2, @Nullable ResourceLocation var3, AdvancementType var4, boolean var5, boolean var6, boolean var7) {
            return this.display(new DisplayInfo(new ItemStack(var0.asItem()), var1, var2, Optional.ofNullable(var3).map(ClientAsset.ResourceTexture::new), var4, var5, var6, var7));
        }

        public Builder display(DisplayInfo var0) {
            this.display = Optional.of(var0);
            return this;
        }

        public Builder rewards(AdvancementRewards.Builder var0) {
            return this.rewards(var0.build());
        }

        public Builder rewards(AdvancementRewards var0) {
            this.rewards = var0;
            return this;
        }

        public Builder addCriterion(String var0, Criterion<?> var1) {
            this.criteria.put((Object)var0, var1);
            return this;
        }

        public Builder requirements(AdvancementRequirements.Strategy var0) {
            this.requirementsStrategy = var0;
            return this;
        }

        public Builder requirements(AdvancementRequirements var0) {
            this.requirements = Optional.of(var0);
            return this;
        }

        public Builder sendsTelemetryEvent() {
            this.sendsTelemetryEvent = true;
            return this;
        }

        public AdvancementHolder build(ResourceLocation var0) {
            ImmutableMap var1 = this.criteria.buildOrThrow();
            AdvancementRequirements var2 = this.requirements.orElseGet(() -> this.lambda$build$0((Map)var1));
            return new AdvancementHolder(var0, new Advancement(this.parent, this.display, this.rewards, (Map<String, Criterion<?>>)var1, var2, this.sendsTelemetryEvent));
        }

        public AdvancementHolder save(Consumer<AdvancementHolder> var0, String var1) {
            AdvancementHolder var2 = this.build(ResourceLocation.parse(var1));
            var0.accept(var2);
            return var2;
        }

        private /* synthetic */ AdvancementRequirements lambda$build$0(Map var0) {
            return this.requirementsStrategy.create(var0.keySet());
        }
    }
}

