/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class FunctionArgument
implements ArgumentType<Result> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "#foo");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("arguments.function.tag.unknown", var0));
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_FUNCTION = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("arguments.function.unknown", var0));

    public static FunctionArgument functions() {
        return new FunctionArgument();
    }

    public Result parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '#') {
            var0.skip();
            final ResourceLocation var1 = ResourceLocation.read(var0);
            return new Result(this){

                @Override
                public Collection<CommandFunction<CommandSourceStack>> create(CommandContext<CommandSourceStack> var0) throws CommandSyntaxException {
                    return FunctionArgument.getFunctionTag(var0, var1);
                }

                @Override
                public Pair<ResourceLocation, Either<CommandFunction<CommandSourceStack>, Collection<CommandFunction<CommandSourceStack>>>> unwrap(CommandContext<CommandSourceStack> var0) throws CommandSyntaxException {
                    return Pair.of((Object)var1, (Object)Either.right(FunctionArgument.getFunctionTag(var0, var1)));
                }

                @Override
                public Pair<ResourceLocation, Collection<CommandFunction<CommandSourceStack>>> unwrapToCollection(CommandContext<CommandSourceStack> var0) throws CommandSyntaxException {
                    return Pair.of((Object)var1, FunctionArgument.getFunctionTag(var0, var1));
                }
            };
        }
        final ResourceLocation var1 = ResourceLocation.read(var0);
        return new Result(this){

            @Override
            public Collection<CommandFunction<CommandSourceStack>> create(CommandContext<CommandSourceStack> var0) throws CommandSyntaxException {
                return Collections.singleton(FunctionArgument.getFunction(var0, var1));
            }

            @Override
            public Pair<ResourceLocation, Either<CommandFunction<CommandSourceStack>, Collection<CommandFunction<CommandSourceStack>>>> unwrap(CommandContext<CommandSourceStack> var0) throws CommandSyntaxException {
                return Pair.of((Object)var1, (Object)Either.left(FunctionArgument.getFunction(var0, var1)));
            }

            @Override
            public Pair<ResourceLocation, Collection<CommandFunction<CommandSourceStack>>> unwrapToCollection(CommandContext<CommandSourceStack> var0) throws CommandSyntaxException {
                return Pair.of((Object)var1, Collections.singleton(FunctionArgument.getFunction(var0, var1)));
            }
        };
    }

    static CommandFunction<CommandSourceStack> getFunction(CommandContext<CommandSourceStack> var0, ResourceLocation var1) throws CommandSyntaxException {
        return ((CommandSourceStack)var0.getSource()).getServer().getFunctions().get(var1).orElseThrow(() -> ERROR_UNKNOWN_FUNCTION.create((Object)var1.toString()));
    }

    static Collection<CommandFunction<CommandSourceStack>> getFunctionTag(CommandContext<CommandSourceStack> var0, ResourceLocation var1) throws CommandSyntaxException {
        List<CommandFunction<CommandSourceStack>> var2 = ((CommandSourceStack)var0.getSource()).getServer().getFunctions().getTag(var1);
        if (var2 == null) {
            throw ERROR_UNKNOWN_TAG.create((Object)var1.toString());
        }
        return var2;
    }

    public static Collection<CommandFunction<CommandSourceStack>> getFunctions(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ((Result)var0.getArgument(var1, Result.class)).create(var0);
    }

    public static Pair<ResourceLocation, Either<CommandFunction<CommandSourceStack>, Collection<CommandFunction<CommandSourceStack>>>> getFunctionOrTag(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ((Result)var0.getArgument(var1, Result.class)).unwrap(var0);
    }

    public static Pair<ResourceLocation, Collection<CommandFunction<CommandSourceStack>>> getFunctionCollection(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ((Result)var0.getArgument(var1, Result.class)).unwrapToCollection(var0);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static interface Result {
        public Collection<CommandFunction<CommandSourceStack>> create(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        public Pair<ResourceLocation, Either<CommandFunction<CommandSourceStack>, Collection<CommandFunction<CommandSourceStack>>>> unwrap(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        public Pair<ResourceLocation, Collection<CommandFunction<CommandSourceStack>>> unwrapToCollection(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }
}

