/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;

public interface HolderLookup<T>
extends HolderGetter<T> {
    public Stream<Holder.Reference<T>> listElements();

    default public Stream<ResourceKey<T>> listElementIds() {
        return this.listElements().map(Holder.Reference::key);
    }

    public Stream<HolderSet.Named<T>> listTags();

    default public Stream<TagKey<T>> listTagIds() {
        return this.listTags().map(HolderSet.Named::key);
    }

    public static interface Provider
    extends HolderGetter.Provider {
        public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys();

        default public Stream<RegistryLookup<?>> listRegistries() {
            return this.listRegistryKeys().map(resourceKey -> this.lookupOrThrow((ResourceKey)resourceKey));
        }

        public <T> Optional<? extends RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> var1);

        default public <T> RegistryLookup<T> lookupOrThrow(ResourceKey<? extends Registry<? extends T>> var0) {
            return this.lookup(var0).orElseThrow(() -> new IllegalStateException("Registry " + String.valueOf(var0.location()) + " not found"));
        }

        default public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> var0) {
            return RegistryOps.create(var0, this);
        }

        public static Provider create(Stream<RegistryLookup<?>> var02) {
            final Map<ResourceKey, RegistryLookup> var1 = var02.collect(Collectors.toUnmodifiableMap(RegistryLookup::key, var0 -> var0));
            return new Provider(){

                @Override
                public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                    return var1.keySet().stream();
                }

                public <T> Optional<RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> var0) {
                    return Optional.ofNullable((RegistryLookup)var1.get(var0));
                }
            };
        }

        default public Lifecycle allRegistriesLifecycle() {
            return this.listRegistries().map(RegistryLookup::registryLifecycle).reduce(Lifecycle.stable(), Lifecycle::add);
        }
    }

    public static interface RegistryLookup<T>
    extends HolderLookup<T>,
    HolderOwner<T> {
        public ResourceKey<? extends Registry<? extends T>> key();

        public Lifecycle registryLifecycle();

        default public RegistryLookup<T> filterFeatures(FeatureFlagSet var0) {
            if (FeatureElement.FILTERED_REGISTRIES.contains(this.key())) {
                return this.filterElements(var1 -> ((FeatureElement)var1).isEnabled(var0));
            }
            return this;
        }

        default public RegistryLookup<T> filterElements(final Predicate<T> var0) {
            return new Delegate<T>(){

                @Override
                public RegistryLookup<T> parent() {
                    return this;
                }

                @Override
                public Optional<Holder.Reference<T>> get(ResourceKey<T> var02) {
                    return this.parent().get(var02).filter(var1 -> var0.test(var1.value()));
                }

                @Override
                public Stream<Holder.Reference<T>> listElements() {
                    return this.parent().listElements().filter(var1 -> var0.test(var1.value()));
                }
            };
        }

        public static interface Delegate<T>
        extends RegistryLookup<T> {
            public RegistryLookup<T> parent();

            @Override
            default public ResourceKey<? extends Registry<? extends T>> key() {
                return this.parent().key();
            }

            @Override
            default public Lifecycle registryLifecycle() {
                return this.parent().registryLifecycle();
            }

            @Override
            default public Optional<Holder.Reference<T>> get(ResourceKey<T> var0) {
                return this.parent().get(var0);
            }

            @Override
            default public Stream<Holder.Reference<T>> listElements() {
                return this.parent().listElements();
            }

            @Override
            default public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
                return this.parent().get(var0);
            }

            @Override
            default public Stream<HolderSet.Named<T>> listTags() {
                return this.parent().listTags();
            }
        }
    }
}

