/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongConsumer;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.entity.EntityAccess;

public class SectionPos
extends Vec3i {
    public static final int SECTION_BITS = 4;
    public static final int SECTION_SIZE = 16;
    public static final int SECTION_MASK = 15;
    public static final int SECTION_HALF_SIZE = 8;
    public static final int SECTION_MAX_INDEX = 15;
    private static final int PACKED_X_LENGTH = 22;
    private static final int PACKED_Y_LENGTH = 20;
    private static final int PACKED_Z_LENGTH = 22;
    private static final long PACKED_X_MASK = 0x3FFFFFL;
    private static final long PACKED_Y_MASK = 1048575L;
    private static final long PACKED_Z_MASK = 0x3FFFFFL;
    private static final int Y_OFFSET = 0;
    private static final int Z_OFFSET = 20;
    private static final int X_OFFSET = 42;
    private static final int RELATIVE_X_SHIFT = 8;
    private static final int RELATIVE_Y_SHIFT = 0;
    private static final int RELATIVE_Z_SHIFT = 4;
    public static final StreamCodec<ByteBuf, SectionPos> STREAM_CODEC = ByteBufCodecs.LONG.map(SectionPos::of, SectionPos::asLong);

    SectionPos(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    public static SectionPos of(int var0, int var1, int var2) {
        return new SectionPos(var0, var1, var2);
    }

    public static SectionPos of(BlockPos var0) {
        return new SectionPos(SectionPos.blockToSectionCoord(var0.getX()), SectionPos.blockToSectionCoord(var0.getY()), SectionPos.blockToSectionCoord(var0.getZ()));
    }

    public static SectionPos of(ChunkPos var0, int var1) {
        return new SectionPos(var0.x, var1, var0.z);
    }

    public static SectionPos of(EntityAccess var0) {
        return SectionPos.of(var0.blockPosition());
    }

    public static SectionPos of(Position var0) {
        return new SectionPos(SectionPos.blockToSectionCoord(var0.x()), SectionPos.blockToSectionCoord(var0.y()), SectionPos.blockToSectionCoord(var0.z()));
    }

    public static SectionPos of(long var0) {
        return new SectionPos(SectionPos.x(var0), SectionPos.y(var0), SectionPos.z(var0));
    }

    public static SectionPos bottomOf(ChunkAccess var0) {
        return SectionPos.of(var0.getPos(), var0.getMinSectionY());
    }

    public static long offset(long var0, Direction var2) {
        return SectionPos.offset(var0, var2.getStepX(), var2.getStepY(), var2.getStepZ());
    }

    public static long offset(long var0, int var2, int var3, int var4) {
        return SectionPos.asLong(SectionPos.x(var0) + var2, SectionPos.y(var0) + var3, SectionPos.z(var0) + var4);
    }

    public static int posToSectionCoord(double var0) {
        return SectionPos.blockToSectionCoord(Mth.floor(var0));
    }

    public static int blockToSectionCoord(int var0) {
        return var0 >> 4;
    }

    public static int blockToSectionCoord(double var0) {
        return Mth.floor(var0) >> 4;
    }

    public static int sectionRelative(int var0) {
        return var0 & 0xF;
    }

    public static short sectionRelativePos(BlockPos var0) {
        int var1 = SectionPos.sectionRelative(var0.getX());
        int var2 = SectionPos.sectionRelative(var0.getY());
        int var3 = SectionPos.sectionRelative(var0.getZ());
        return (short)(var1 << 8 | var3 << 4 | var2 << 0);
    }

    public static int sectionRelativeX(short var0) {
        return var0 >>> 8 & 0xF;
    }

    public static int sectionRelativeY(short var0) {
        return var0 >>> 0 & 0xF;
    }

    public static int sectionRelativeZ(short var0) {
        return var0 >>> 4 & 0xF;
    }

    public int relativeToBlockX(short var0) {
        return this.minBlockX() + SectionPos.sectionRelativeX(var0);
    }

    public int relativeToBlockY(short var0) {
        return this.minBlockY() + SectionPos.sectionRelativeY(var0);
    }

    public int relativeToBlockZ(short var0) {
        return this.minBlockZ() + SectionPos.sectionRelativeZ(var0);
    }

    public BlockPos relativeToBlockPos(short var0) {
        return new BlockPos(this.relativeToBlockX(var0), this.relativeToBlockY(var0), this.relativeToBlockZ(var0));
    }

    public static int sectionToBlockCoord(int var0) {
        return var0 << 4;
    }

    public static int sectionToBlockCoord(int var0, int var1) {
        return SectionPos.sectionToBlockCoord(var0) + var1;
    }

    public static int x(long var0) {
        return (int)(var0 << 0 >> 42);
    }

    public static int y(long var0) {
        return (int)(var0 << 44 >> 44);
    }

    public static int z(long var0) {
        return (int)(var0 << 22 >> 42);
    }

    public int x() {
        return this.getX();
    }

    public int y() {
        return this.getY();
    }

    public int z() {
        return this.getZ();
    }

    public int minBlockX() {
        return SectionPos.sectionToBlockCoord(this.x());
    }

    public int minBlockY() {
        return SectionPos.sectionToBlockCoord(this.y());
    }

    public int minBlockZ() {
        return SectionPos.sectionToBlockCoord(this.z());
    }

    public int maxBlockX() {
        return SectionPos.sectionToBlockCoord(this.x(), 15);
    }

    public int maxBlockY() {
        return SectionPos.sectionToBlockCoord(this.y(), 15);
    }

    public int maxBlockZ() {
        return SectionPos.sectionToBlockCoord(this.z(), 15);
    }

    public static long blockToSection(long var0) {
        return SectionPos.asLong(SectionPos.blockToSectionCoord(BlockPos.getX(var0)), SectionPos.blockToSectionCoord(BlockPos.getY(var0)), SectionPos.blockToSectionCoord(BlockPos.getZ(var0)));
    }

    public static long getZeroNode(int var0, int var1) {
        return SectionPos.getZeroNode(SectionPos.asLong(var0, 0, var1));
    }

    public static long getZeroNode(long var0) {
        return var0 & 0xFFFFFFFFFFF00000L;
    }

    public static long sectionToChunk(long var0) {
        return ChunkPos.asLong(SectionPos.x(var0), SectionPos.z(var0));
    }

    public BlockPos origin() {
        return new BlockPos(SectionPos.sectionToBlockCoord(this.x()), SectionPos.sectionToBlockCoord(this.y()), SectionPos.sectionToBlockCoord(this.z()));
    }

    public BlockPos center() {
        int var0 = 8;
        return this.origin().offset(8, 8, 8);
    }

    public ChunkPos chunk() {
        return new ChunkPos(this.x(), this.z());
    }

    public static long asLong(BlockPos var0) {
        return SectionPos.asLong(SectionPos.blockToSectionCoord(var0.getX()), SectionPos.blockToSectionCoord(var0.getY()), SectionPos.blockToSectionCoord(var0.getZ()));
    }

    public static long asLong(int var0, int var1, int var2) {
        long var3 = 0L;
        var3 |= ((long)var0 & 0x3FFFFFL) << 42;
        var3 |= ((long)var1 & 0xFFFFFL) << 0;
        return var3 |= ((long)var2 & 0x3FFFFFL) << 20;
    }

    public long asLong() {
        return SectionPos.asLong(this.x(), this.y(), this.z());
    }

    @Override
    public SectionPos offset(int var0, int var1, int var2) {
        if (var0 == 0 && var1 == 0 && var2 == 0) {
            return this;
        }
        return new SectionPos(this.x() + var0, this.y() + var1, this.z() + var2);
    }

    public Stream<BlockPos> blocksInside() {
        return BlockPos.betweenClosedStream(this.minBlockX(), this.minBlockY(), this.minBlockZ(), this.maxBlockX(), this.maxBlockY(), this.maxBlockZ());
    }

    public static Stream<SectionPos> cube(SectionPos var0, int var1) {
        int var2 = var0.x();
        int var3 = var0.y();
        int var4 = var0.z();
        return SectionPos.betweenClosedStream(var2 - var1, var3 - var1, var4 - var1, var2 + var1, var3 + var1, var4 + var1);
    }

    public static Stream<SectionPos> aroundChunk(ChunkPos var0, int var1, int var2, int var3) {
        int var4 = var0.x;
        int var5 = var0.z;
        return SectionPos.betweenClosedStream(var4 - var1, var2, var5 - var1, var4 + var1, var3, var5 + var1);
    }

    public static Stream<SectionPos> betweenClosedStream(final int var0, final int var1, final int var2, final int var3, final int var4, final int var5) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<SectionPos>((long)((var3 - var0 + 1) * (var4 - var1 + 1) * (var5 - var2 + 1)), 64){
            final Cursor3D cursor;
            {
                super(var02, var22);
                this.cursor = new Cursor3D(var0, var1, var2, var3, var4, var5);
            }

            @Override
            public boolean tryAdvance(Consumer<? super SectionPos> var02) {
                if (this.cursor.advance()) {
                    var02.accept(new SectionPos(this.cursor.nextX(), this.cursor.nextY(), this.cursor.nextZ()));
                    return true;
                }
                return false;
            }
        }, false);
    }

    public static void aroundAndAtBlockPos(BlockPos var0, LongConsumer var1) {
        SectionPos.aroundAndAtBlockPos(var0.getX(), var0.getY(), var0.getZ(), var1);
    }

    public static void aroundAndAtBlockPos(long var0, LongConsumer var2) {
        SectionPos.aroundAndAtBlockPos(BlockPos.getX(var0), BlockPos.getY(var0), BlockPos.getZ(var0), var2);
    }

    public static void aroundAndAtBlockPos(int var0, int var1, int var2, LongConsumer var3) {
        int var4 = SectionPos.blockToSectionCoord(var0 - 1);
        int var5 = SectionPos.blockToSectionCoord(var0 + 1);
        int var6 = SectionPos.blockToSectionCoord(var1 - 1);
        int var7 = SectionPos.blockToSectionCoord(var1 + 1);
        int var8 = SectionPos.blockToSectionCoord(var2 - 1);
        int var9 = SectionPos.blockToSectionCoord(var2 + 1);
        if (var4 == var5 && var6 == var7 && var8 == var9) {
            var3.accept(SectionPos.asLong(var4, var6, var8));
        } else {
            for (int var10 = var4; var10 <= var5; ++var10) {
                for (int var11 = var6; var11 <= var7; ++var11) {
                    for (int var12 = var8; var12 <= var9; ++var12) {
                        var3.accept(SectionPos.asLong(var10, var11, var12));
                    }
                }
            }
        }
    }

    @Override
    public /* synthetic */ Vec3i offset(int n, int n2, int n3) {
        return this.offset(n, n2, n3);
    }
}

