/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class BoatDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
    private final EntityType<? extends AbstractBoat> type;

    public BoatDispenseItemBehavior(EntityType<? extends AbstractBoat> entitytypes) {
        this.type = entitytypes;
    }

    @Override
    public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        AbstractBoat abstractboat;
        double d4;
        Direction enumdirection = sourceblock.state().getValue(DispenserBlock.FACING);
        ServerLevel worldserver = sourceblock.level();
        Vec3 vec3d = sourceblock.center();
        double d0 = 0.5625 + (double)this.type.getWidth() / 2.0;
        double d1 = vec3d.x() + (double)enumdirection.getStepX() * d0;
        double d2 = vec3d.y() + (double)((float)enumdirection.getStepY() * 1.125f);
        double d3 = vec3d.z() + (double)enumdirection.getStepZ() * d0;
        BlockPos blockposition = sourceblock.pos().relative(enumdirection);
        if (worldserver.getFluidState(blockposition).is(FluidTags.WATER)) {
            d4 = 1.0;
        } else {
            if (!worldserver.getBlockState(blockposition).isAir() || !worldserver.getFluidState(blockposition.below()).is(FluidTags.WATER)) {
                return this.defaultDispenseItemBehavior.dispense(sourceblock, itemstack);
            }
            d4 = 0.0;
        }
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
        CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)block, (ItemStack)craftItem.clone(), new Vector(d1, d2 + d4, d3));
        if (!DispenserBlock.eventFired) {
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            itemstack.grow(1);
            return itemstack;
        }
        if (!event.getItem().equals((Object)craftItem)) {
            itemstack.grow(1);
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
            if (idispensebehavior != DispenseItemBehavior.NOOP && idispensebehavior != this) {
                idispensebehavior.dispense(sourceblock, eventStack);
                return itemstack;
            }
        }
        if ((abstractboat = this.type.create(worldserver, EntitySpawnReason.DISPENSER)) != null) {
            abstractboat.setInitialPos(event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ());
            EntityType.createDefaultStackConfig(worldserver, itemstack, null).accept(abstractboat);
            abstractboat.setYRot(enumdirection.toYRot());
            if (!worldserver.addFreshEntity(abstractboat)) {
                itemstack.grow(1);
            }
        }
        return itemstack;
    }

    @Override
    protected void playSound(BlockSource sourceblock) {
        sourceblock.level().levelEvent(1000, sourceblock.pos(), 0);
    }
}

