/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.BoatDispenseItemBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.EquipmentDispenseItemBehavior;
import net.minecraft.core.dispenser.MinecartDispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.DummyGeneratorAccess;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public interface DispenseItemBehavior {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DispenseItemBehavior NOOP = (sourceblock, itemstack) -> itemstack;

    public net.minecraft.world.item.ItemStack dispense(BlockSource var1, net.minecraft.world.item.ItemStack var2);

    public static void bootStrap() {
        DispenserBlock.registerProjectileBehavior(Items.ARROW);
        DispenserBlock.registerProjectileBehavior(Items.TIPPED_ARROW);
        DispenserBlock.registerProjectileBehavior(Items.SPECTRAL_ARROW);
        DispenserBlock.registerProjectileBehavior(Items.EGG);
        DispenserBlock.registerProjectileBehavior(Items.BLUE_EGG);
        DispenserBlock.registerProjectileBehavior(Items.BROWN_EGG);
        DispenserBlock.registerProjectileBehavior(Items.SNOWBALL);
        DispenserBlock.registerProjectileBehavior(Items.EXPERIENCE_BOTTLE);
        DispenserBlock.registerProjectileBehavior(Items.SPLASH_POTION);
        DispenserBlock.registerProjectileBehavior(Items.LINGERING_POTION);
        DispenserBlock.registerProjectileBehavior(Items.FIREWORK_ROCKET);
        DispenserBlock.registerProjectileBehavior(Items.FIRE_CHARGE);
        DispenserBlock.registerProjectileBehavior(Items.WIND_CHARGE);
        DefaultDispenseItemBehavior dispensebehavioritem = new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                Direction enumdirection = sourceblock.state().getValue(DispenserBlock.FACING);
                EntityType<?> entitytypes = ((SpawnEggItem)itemstack.getItem()).getType(itemstack);
                if (entitytypes == null) {
                    return itemstack;
                }
                ServerLevel worldserver = sourceblock.level();
                net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
                CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    itemstack.grow(1);
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    itemstack.grow(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                }
                try {
                    entitytypes.spawn(sourceblock.level(), itemstack, (net.minecraft.world.entity.LivingEntity)null, sourceblock.pos().relative(enumdirection), EntitySpawnReason.DISPENSER, enumdirection != Direction.UP, false);
                }
                catch (Exception exception) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)sourceblock.pos(), (Object)exception);
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
                sourceblock.level().gameEvent((Entity)null, GameEvent.ENTITY_PLACE, sourceblock.pos());
                return itemstack;
            }
        };
        for (SpawnEggItem itemmonsteregg : SpawnEggItem.eggs()) {
            DispenserBlock.registerBehavior(itemmonsteregg, dispensebehavioritem);
        }
        DispenserBlock.registerBehavior(Items.ARMOR_STAND, new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                Consumer<ArmorStand> consumer;
                ArmorStand entityarmorstand2;
                Direction enumdirection = sourceblock.state().getValue(DispenserBlock.FACING);
                BlockPos blockposition = sourceblock.pos().relative(enumdirection);
                ServerLevel worldserver = sourceblock.level();
                net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
                CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    itemstack.grow(1);
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    itemstack.grow(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                }
                if ((entityarmorstand2 = EntityType.ARMOR_STAND.spawn(worldserver, consumer = EntityType.appendDefaultStackConfig(entityarmorstand -> entityarmorstand.setYRot(enumdirection.toYRot()), worldserver, itemstack, null), blockposition, EntitySpawnReason.DISPENSER, false, false)) != null) {
                    // empty if block
                }
                return itemstack;
            }
        });
        DispenserBlock.registerBehavior(Items.CHEST, new OptionalDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                BlockPos blockposition = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING));
                Iterator<AbstractChestedHorse> iterator = sourceblock.level().getEntitiesOfClass(AbstractChestedHorse.class, new AABB(blockposition), entityhorsechestedabstract1 -> entityhorsechestedabstract1.isAlive() && !entityhorsechestedabstract1.hasChest()).iterator();
                if (iterator.hasNext()) {
                    net.minecraft.world.item.ItemStack eventStack;
                    DispenseItemBehavior idispensebehavior;
                    AbstractChestedHorse entityhorsechestedabstract = iterator.next();
                    net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
                    ServerLevel world = sourceblock.level();
                    CraftBlock block = CraftBlock.at(world, sourceblock.pos());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                    BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityhorsechestedabstract.getBukkitEntity()));
                    if (!DispenserBlock.eventFired) {
                        world.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return itemstack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != EquipmentDispenseItemBehavior.INSTANCE) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                    entityhorsechestedabstract.getSlot(499).set(CraftItemStack.asNMSCopy(event.getItem()));
                    this.setSuccess(true);
                    return itemstack;
                }
                return super.execute(sourceblock, itemstack);
            }
        });
        DispenserBlock.registerBehavior(Items.OAK_BOAT, new BoatDispenseItemBehavior(EntityType.OAK_BOAT));
        DispenserBlock.registerBehavior(Items.SPRUCE_BOAT, new BoatDispenseItemBehavior(EntityType.SPRUCE_BOAT));
        DispenserBlock.registerBehavior(Items.BIRCH_BOAT, new BoatDispenseItemBehavior(EntityType.BIRCH_BOAT));
        DispenserBlock.registerBehavior(Items.JUNGLE_BOAT, new BoatDispenseItemBehavior(EntityType.JUNGLE_BOAT));
        DispenserBlock.registerBehavior(Items.DARK_OAK_BOAT, new BoatDispenseItemBehavior(EntityType.DARK_OAK_BOAT));
        DispenserBlock.registerBehavior(Items.ACACIA_BOAT, new BoatDispenseItemBehavior(EntityType.ACACIA_BOAT));
        DispenserBlock.registerBehavior(Items.CHERRY_BOAT, new BoatDispenseItemBehavior(EntityType.CHERRY_BOAT));
        DispenserBlock.registerBehavior(Items.MANGROVE_BOAT, new BoatDispenseItemBehavior(EntityType.MANGROVE_BOAT));
        DispenserBlock.registerBehavior(Items.PALE_OAK_BOAT, new BoatDispenseItemBehavior(EntityType.PALE_OAK_BOAT));
        DispenserBlock.registerBehavior(Items.BAMBOO_RAFT, new BoatDispenseItemBehavior(EntityType.BAMBOO_RAFT));
        DispenserBlock.registerBehavior(Items.OAK_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.OAK_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.SPRUCE_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.SPRUCE_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.BIRCH_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.BIRCH_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.JUNGLE_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.JUNGLE_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.DARK_OAK_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.DARK_OAK_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.ACACIA_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.ACACIA_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.CHERRY_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.CHERRY_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.MANGROVE_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.MANGROVE_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.PALE_OAK_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.PALE_OAK_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.BAMBOO_CHEST_RAFT, new BoatDispenseItemBehavior(EntityType.BAMBOO_CHEST_RAFT));
        DefaultDispenseItemBehavior idispensebehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                DispensibleContainerItem dispensiblecontaineritem = (DispensibleContainerItem)((Object)itemstack.getItem());
                BlockPos blockposition = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING));
                ServerLevel world = sourceblock.level();
                ServerLevel worldserver = sourceblock.level();
                int x = blockposition.getX();
                int y = blockposition.getY();
                int z = blockposition.getZ();
                net.minecraft.world.level.block.state.BlockState iblockdata = worldserver.getBlockState(blockposition);
                if (iblockdata.isAir() || iblockdata.canBeReplaced() || dispensiblecontaineritem instanceof BucketItem && iblockdata.getBlock() instanceof LiquidBlockContainer && ((LiquidBlockContainer)((Object)iblockdata.getBlock())).canPlaceLiquid(null, worldserver, blockposition, iblockdata, ((BucketItem)dispensiblecontaineritem).content)) {
                    net.minecraft.world.item.ItemStack eventStack;
                    DispenseItemBehavior idispensebehavior;
                    CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                    BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(x, y, z));
                    if (!DispenserBlock.eventFired) {
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return itemstack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                    dispensiblecontaineritem = (DispensibleContainerItem)((Object)CraftItemStack.asNMSCopy(event.getItem()).getItem());
                }
                if (dispensiblecontaineritem.emptyContents(null, world, blockposition, null)) {
                    dispensiblecontaineritem.checkExtraContent(null, world, itemstack, blockposition);
                    return this.consumeWithRemainder(sourceblock, itemstack, new net.minecraft.world.item.ItemStack(Items.BUCKET));
                }
                return this.defaultDispenseItemBehavior.dispense(sourceblock, itemstack);
            }
        };
        DispenserBlock.registerBehavior(Items.LAVA_BUCKET, idispensebehavior);
        DispenserBlock.registerBehavior(Items.WATER_BUCKET, idispensebehavior);
        DispenserBlock.registerBehavior(Items.POWDER_SNOW_BUCKET, idispensebehavior);
        DispenserBlock.registerBehavior(Items.SALMON_BUCKET, idispensebehavior);
        DispenserBlock.registerBehavior(Items.COD_BUCKET, idispensebehavior);
        DispenserBlock.registerBehavior(Items.PUFFERFISH_BUCKET, idispensebehavior);
        DispenserBlock.registerBehavior(Items.TROPICAL_FISH_BUCKET, idispensebehavior);
        DispenserBlock.registerBehavior(Items.AXOLOTL_BUCKET, idispensebehavior);
        DispenserBlock.registerBehavior(Items.TADPOLE_BUCKET, idispensebehavior);
        DispenserBlock.registerBehavior(Items.BUCKET, new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                BlockPos blockposition;
                ServerLevel generatoraccess = sourceblock.level();
                net.minecraft.world.level.block.state.BlockState iblockdata = generatoraccess.getBlockState(blockposition = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING)));
                Block block = iblockdata.getBlock();
                if (block instanceof BucketPickup) {
                    net.minecraft.world.item.ItemStack eventStack;
                    DispenseItemBehavior idispensebehavior;
                    BucketPickup ifluidsource = (BucketPickup)((Object)block);
                    net.minecraft.world.item.ItemStack itemstack1 = ifluidsource.pickupBlock(null, DummyGeneratorAccess.INSTANCE, blockposition, iblockdata);
                    if (itemstack1.isEmpty()) {
                        return super.execute(sourceblock, itemstack);
                    }
                    generatoraccess.gameEvent((Entity)null, GameEvent.FLUID_PICKUP, blockposition);
                    Item item = itemstack1.getItem();
                    CraftBlock bukkitBlock = CraftBlock.at(generatoraccess, sourceblock.pos());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                    BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                    if (!DispenserBlock.eventFired) {
                        sourceblock.level().getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return itemstack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                    itemstack1 = ifluidsource.pickupBlock(null, generatoraccess, blockposition, iblockdata);
                    return this.consumeWithRemainder(sourceblock, itemstack, new net.minecraft.world.item.ItemStack(item));
                }
                return super.execute(sourceblock, itemstack);
            }
        });
        DispenserBlock.registerBehavior(Items.FLINT_AND_STEEL, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                ServerLevel worldserver = sourceblock.level();
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                this.setSuccess(true);
                Direction enumdirection = sourceblock.state().getValue(DispenserBlock.FACING);
                BlockPos blockposition = sourceblock.pos().relative(enumdirection);
                net.minecraft.world.level.block.state.BlockState iblockdata = worldserver.getBlockState(blockposition);
                if (BaseFireBlock.canBePlacedAt(worldserver, blockposition, enumdirection)) {
                    if (!CraftEventFactory.callBlockIgniteEvent((Level)worldserver, blockposition, sourceblock.pos()).isCancelled()) {
                        worldserver.setBlockAndUpdate(blockposition, BaseFireBlock.getState(worldserver, blockposition));
                        worldserver.gameEvent((Entity)null, GameEvent.BLOCK_PLACE, blockposition);
                    }
                } else if (!(CampfireBlock.canLight(iblockdata) || CandleBlock.canLight(iblockdata) || CandleCakeBlock.canLight(iblockdata))) {
                    if (iblockdata.getBlock() instanceof TntBlock && CraftEventFactory.callTNTPrimeEvent(worldserver, blockposition, TNTPrimeEvent.PrimeCause.DISPENSER, null, sourceblock.pos())) {
                        if (TntBlock.prime(worldserver, blockposition)) {
                            worldserver.removeBlock(blockposition, false);
                        } else {
                            this.setSuccess(false);
                        }
                    } else {
                        this.setSuccess(false);
                    }
                } else {
                    worldserver.setBlockAndUpdate(blockposition, (net.minecraft.world.level.block.state.BlockState)iblockdata.setValue(BlockStateProperties.LIT, true));
                    worldserver.gameEvent((Entity)null, GameEvent.BLOCK_CHANGE, blockposition);
                }
                if (this.isSuccess()) {
                    itemstack.hurtAndBreak(1, worldserver, null, item -> {});
                }
                return itemstack;
            }
        });
        DispenserBlock.registerBehavior(Items.BONE_MEAL, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                this.setSuccess(true);
                ServerLevel world = sourceblock.level();
                BlockPos blockposition = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING));
                CraftBlock block = CraftBlock.at(world, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                world.captureTreeGeneration = true;
                if (!BoneMealItem.growCrop(itemstack, world, blockposition) && !BoneMealItem.growWaterPlant(itemstack, world, blockposition, null)) {
                    this.setSuccess(false);
                } else if (!world.isClientSide()) {
                    world.levelEvent(1505, blockposition, 15);
                }
                world.captureTreeGeneration = false;
                if (world.capturedBlockStates.size() > 0) {
                    TreeType treeType = SaplingBlock.treeType;
                    SaplingBlock.treeType = null;
                    Location location = CraftLocation.toBukkit(blockposition, (World)world.getWorld());
                    ArrayList<CapturedBlockState> blocks = new ArrayList<CapturedBlockState>(world.capturedBlockStates.values());
                    world.capturedBlockStates.clear();
                    StructureGrowEvent structureEvent = null;
                    if (treeType != null) {
                        structureEvent = new StructureGrowEvent(location, treeType, false, null, blocks);
                        Bukkit.getPluginManager().callEvent((Event)structureEvent);
                    }
                    BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent(location.getBlock(), null, blocks);
                    fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
                    Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
                    if (!fertilizeEvent.isCancelled()) {
                        for (BlockState blockState : blocks) {
                            blockState.update(true);
                        }
                    }
                }
                return itemstack;
            }
        });
        DispenserBlock.registerBehavior(Blocks.TNT, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                ServerLevel worldserver = sourceblock.level();
                if (!worldserver.getGameRules().getBoolean(GameRules.RULE_TNT_EXPLODES)) {
                    this.setSuccess(false);
                    return itemstack;
                }
                BlockPos blockposition = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING));
                net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
                CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector((double)blockposition.getX() + 0.5, (double)blockposition.getY(), (double)blockposition.getZ() + 0.5));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    itemstack.grow(1);
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    itemstack.grow(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                }
                PrimedTnt entitytntprimed = new PrimedTnt(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), null);
                worldserver.addFreshEntity(entitytntprimed);
                worldserver.playSound((Entity)null, entitytntprimed.getX(), entitytntprimed.getY(), entitytntprimed.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldserver.gameEvent((Entity)null, GameEvent.ENTITY_PLACE, blockposition);
                this.setSuccess(true);
                return itemstack;
            }
        });
        DispenserBlock.registerBehavior(Items.WITHER_SKELETON_SKULL, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                ServerLevel world = sourceblock.level();
                Direction enumdirection = sourceblock.state().getValue(DispenserBlock.FACING);
                BlockPos blockposition = sourceblock.pos().relative(enumdirection);
                CraftBlock bukkitBlock = CraftBlock.at(world, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                if (!DispenserBlock.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                if (world.isEmptyBlock(blockposition) && WitherSkullBlock.canSpawnMob(world, blockposition, itemstack)) {
                    world.setBlock(blockposition, (net.minecraft.world.level.block.state.BlockState)Blocks.WITHER_SKELETON_SKULL.defaultBlockState().setValue(SkullBlock.ROTATION, RotationSegment.convertToSegment(enumdirection)), 3);
                    world.gameEvent((Entity)null, GameEvent.BLOCK_PLACE, blockposition);
                    BlockEntity tileentity = world.getBlockEntity(blockposition);
                    if (tileentity instanceof SkullBlockEntity) {
                        WitherSkullBlock.checkSpawn(world, blockposition, (SkullBlockEntity)tileentity);
                    }
                    itemstack.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(EquipmentDispenseItemBehavior.dispenseEquipment(sourceblock, itemstack));
                }
                return itemstack;
            }
        });
        DispenserBlock.registerBehavior(Blocks.CARVED_PUMPKIN, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                ServerLevel world = sourceblock.level();
                BlockPos blockposition = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING));
                CarvedPumpkinBlock blockpumpkincarved = (CarvedPumpkinBlock)Blocks.CARVED_PUMPKIN;
                CraftBlock bukkitBlock = CraftBlock.at(world, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                if (!DispenserBlock.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                if (world.isEmptyBlock(blockposition) && blockpumpkincarved.canSpawnGolem(world, blockposition)) {
                    if (!world.isClientSide()) {
                        world.setBlock(blockposition, blockpumpkincarved.defaultBlockState(), 3);
                        world.gameEvent((Entity)null, GameEvent.BLOCK_PLACE, blockposition);
                    }
                    itemstack.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(EquipmentDispenseItemBehavior.dispenseEquipment(sourceblock, itemstack));
                }
                return itemstack;
            }
        });
        DispenserBlock.registerBehavior(Blocks.SHULKER_BOX.asItem(), new ShulkerBoxDispenseBehavior());
        for (DyeColor enumcolor : DyeColor.values()) {
            DispenserBlock.registerBehavior(ShulkerBoxBlock.getBlockByColor(enumcolor).asItem(), new ShulkerBoxDispenseBehavior());
        }
        DispenserBlock.registerBehavior(Items.GLASS_BOTTLE.asItem(), new OptionalDispenseItemBehavior(){

            private net.minecraft.world.item.ItemStack takeLiquid(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
                sourceblock.level().gameEvent((Entity)null, GameEvent.FLUID_PICKUP, sourceblock.pos());
                return this.consumeWithRemainder(sourceblock, itemstack, itemstack1);
            }

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                this.setSuccess(false);
                ServerLevel worldserver = sourceblock.level();
                BlockPos blockposition = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING));
                net.minecraft.world.level.block.state.BlockState iblockdata = worldserver.getBlockState(blockposition);
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                if (iblockdata.is(BlockTags.BEEHIVES, blockbase_blockdata -> blockbase_blockdata.hasProperty(BeehiveBlock.HONEY_LEVEL) && blockbase_blockdata.getBlock() instanceof BeehiveBlock) && iblockdata.getValue(BeehiveBlock.HONEY_LEVEL) >= 5) {
                    ((BeehiveBlock)iblockdata.getBlock()).releaseBeesAndResetHoneyLevel(worldserver, iblockdata, blockposition, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                    this.setSuccess(true);
                    return this.takeLiquid(sourceblock, itemstack, new net.minecraft.world.item.ItemStack(Items.HONEY_BOTTLE));
                }
                if (worldserver.getFluidState(blockposition).is(FluidTags.WATER)) {
                    this.setSuccess(true);
                    return this.takeLiquid(sourceblock, itemstack, PotionContents.createItemStack(Items.POTION, Potions.WATER));
                }
                return super.execute(sourceblock, itemstack);
            }
        });
        DispenserBlock.registerBehavior(Items.GLOWSTONE, new OptionalDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                Direction enumdirection = sourceblock.state().getValue(DispenserBlock.FACING);
                BlockPos blockposition = sourceblock.pos().relative(enumdirection);
                ServerLevel world = sourceblock.level();
                net.minecraft.world.level.block.state.BlockState iblockdata = world.getBlockState(blockposition);
                this.setSuccess(true);
                if (iblockdata.is(Blocks.RESPAWN_ANCHOR)) {
                    if (iblockdata.getValue(RespawnAnchorBlock.CHARGE) != 4) {
                        RespawnAnchorBlock.charge(null, world, blockposition, iblockdata);
                        itemstack.shrink(1);
                    } else {
                        this.setSuccess(false);
                    }
                    return itemstack;
                }
                return super.execute(sourceblock, itemstack);
            }
        });
        DispenserBlock.registerBehavior(Items.SHEARS.asItem(), new ShearsDispenseItemBehavior());
        DispenserBlock.registerBehavior(Items.BRUSH.asItem(), new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior dispenseItemBehavior;
                BlockPos blockposition;
                ServerLevel worldserver = sourceblock.level();
                List<Entity> list = worldserver.getEntitiesOfClass(Armadillo.class, new AABB(blockposition = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING))), EntitySelector.NO_SPECTATORS);
                if (list.isEmpty()) {
                    this.setSuccess(false);
                    return itemstack;
                }
                net.minecraft.world.item.ItemStack itemstack1 = itemstack;
                ServerLevel world = sourceblock.level();
                CraftBlock block = CraftBlock.at(world, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)((Armadillo)list.get(0)).getBukkitEntity()));
                if (!DispenserBlock.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (dispenseItemBehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && dispenseItemBehavior != EquipmentDispenseItemBehavior.INSTANCE) {
                    dispenseItemBehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                for (Armadillo armadillo : list) {
                    if (!armadillo.brushOffScute(null, itemstack)) continue;
                    itemstack.hurtAndBreak(16, worldserver, null, item -> {});
                    return itemstack;
                }
                this.setSuccess(false);
                return itemstack;
            }
        });
        DispenserBlock.registerBehavior(Items.HONEYCOMB, new OptionalDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                BlockPos blockposition = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING));
                ServerLevel world = sourceblock.level();
                net.minecraft.world.level.block.state.BlockState iblockdata = world.getBlockState(blockposition);
                Optional<net.minecraft.world.level.block.state.BlockState> optional = HoneycombItem.getWaxed(iblockdata);
                if (optional.isPresent()) {
                    world.setBlockAndUpdate(blockposition, optional.get());
                    world.levelEvent(3003, blockposition, 0);
                    itemstack.shrink(1);
                    this.setSuccess(true);
                    return itemstack;
                }
                return super.execute(sourceblock, itemstack);
            }
        });
        DispenserBlock.registerBehavior(Items.POTION, new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                PotionContents potioncontents = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
                if (!potioncontents.is(Potions.WATER)) {
                    return this.defaultDispenseItemBehavior.dispense(sourceblock, itemstack);
                }
                ServerLevel worldserver = sourceblock.level();
                BlockPos blockposition = sourceblock.pos();
                BlockPos blockposition1 = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING));
                if (!worldserver.getBlockState(blockposition1).is(BlockTags.CONVERTABLE_TO_MUD)) {
                    return this.defaultDispenseItemBehavior.dispense(sourceblock, itemstack);
                }
                if (!worldserver.isClientSide()) {
                    for (int i = 0; i < 5; ++i) {
                        worldserver.sendParticles(ParticleTypes.SPLASH, (double)blockposition.getX() + worldserver.random.nextDouble(), blockposition.getY() + 1, (double)blockposition.getZ() + worldserver.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    }
                }
                worldserver.playSound((Entity)null, blockposition, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldserver.gameEvent((Entity)null, GameEvent.FLUID_PLACE, blockposition);
                worldserver.setBlockAndUpdate(blockposition1, Blocks.MUD.defaultBlockState());
                return this.consumeWithRemainder(sourceblock, itemstack, new net.minecraft.world.item.ItemStack(Items.GLASS_BOTTLE));
            }
        });
        DispenserBlock.registerBehavior(Items.MINECART, new MinecartDispenseItemBehavior(EntityType.MINECART));
        DispenserBlock.registerBehavior(Items.CHEST_MINECART, new MinecartDispenseItemBehavior(EntityType.CHEST_MINECART));
        DispenserBlock.registerBehavior(Items.FURNACE_MINECART, new MinecartDispenseItemBehavior(EntityType.FURNACE_MINECART));
        DispenserBlock.registerBehavior(Items.TNT_MINECART, new MinecartDispenseItemBehavior(EntityType.TNT_MINECART));
        DispenserBlock.registerBehavior(Items.HOPPER_MINECART, new MinecartDispenseItemBehavior(EntityType.HOPPER_MINECART));
        DispenserBlock.registerBehavior(Items.COMMAND_BLOCK_MINECART, new MinecartDispenseItemBehavior(EntityType.COMMAND_BLOCK_MINECART));
    }
}

