/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.biome;

import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class OverworldBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;
    private static final int DARK_DRY_FOLIAGE_COLOR = 8082228;
    @Nullable
    private static final Music NORMAL_MUSIC = null;
    public static final int SWAMP_SKELETON_WEIGHT = 70;

    protected static int calculateSkyColor(float var0) {
        float var1 = var0;
        var1 /= 3.0f;
        var1 = Mth.clamp(var1, -1.0f, 1.0f);
        return Mth.hsvToRgb(0.62222224f - var1 * 0.05f, 0.5f + var1 * 0.1f, 1.0f);
    }

    private static Biome biome(boolean var0, float var1, float var2, MobSpawnSettings.Builder var3, BiomeGenerationSettings.Builder var4, @Nullable Music var5) {
        return OverworldBiomes.biome(var0, var1, var2, 4159204, 329011, null, null, null, var3, var4, var5);
    }

    private static Biome biome(boolean var0, float var1, float var2, int var3, int var4, @Nullable Integer var5, @Nullable Integer var6, @Nullable Integer var7, MobSpawnSettings.Builder var8, BiomeGenerationSettings.Builder var9, @Nullable Music var10) {
        BiomeSpecialEffects.Builder var11 = new BiomeSpecialEffects.Builder().waterColor(var3).waterFogColor(var4).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(var1)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(var10);
        if (var5 != null) {
            var11.grassColorOverride(var5);
        }
        if (var6 != null) {
            var11.foliageColorOverride(var6);
        }
        if (var7 != null) {
            var11.dryFoliageColorOverride(var7);
        }
        return new Biome.BiomeBuilder().hasPrecipitation(var0).temperature(var1).downfall(var2).specialEffects(var11.build()).mobSpawnSettings(var8.build()).generationSettings(var9.build()).build();
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder var0) {
        BiomeDefaultFeatures.addDefaultCarversAndLakes(var0);
        BiomeDefaultFeatures.addDefaultCrystalFormations(var0);
        BiomeDefaultFeatures.addDefaultMonsterRoom(var0);
        BiomeDefaultFeatures.addDefaultUndergroundVariety(var0);
        BiomeDefaultFeatures.addDefaultSprings(var0);
        BiomeDefaultFeatures.addSurfaceFreezing(var0);
    }

    public static Biome oldGrowthTaiga(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2) {
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals(var3);
        var3.addSpawn(MobCategory.CREATURE, 8, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 4, 4));
        var3.addSpawn(MobCategory.CREATURE, 4, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 2, 3));
        var3.addSpawn(MobCategory.CREATURE, 8, new MobSpawnSettings.SpawnerData(EntityType.FOX, 2, 4));
        if (var2) {
            BiomeDefaultFeatures.commonSpawns(var3);
        } else {
            BiomeDefaultFeatures.caveSpawns(var3);
            BiomeDefaultFeatures.monsters(var3, 100, 25, 100, false);
        }
        BiomeGenerationSettings.Builder var4 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeDefaultFeatures.addMossyStoneBlock(var4);
        BiomeDefaultFeatures.addFerns(var4);
        BiomeDefaultFeatures.addDefaultOres(var4);
        BiomeDefaultFeatures.addDefaultSoftDisks(var4);
        var4.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, var2 ? VegetationPlacements.TREES_OLD_GROWTH_SPRUCE_TAIGA : VegetationPlacements.TREES_OLD_GROWTH_PINE_TAIGA);
        BiomeDefaultFeatures.addDefaultFlowers(var4);
        BiomeDefaultFeatures.addGiantTaigaVegetation(var4);
        BiomeDefaultFeatures.addDefaultMushrooms(var4);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var4, true);
        BiomeDefaultFeatures.addCommonBerryBushes(var4);
        Music var5 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_OLD_GROWTH_TAIGA);
        return OverworldBiomes.biome(true, var2 ? 0.25f : 0.3f, 0.8f, var3, var4, var5);
    }

    public static Biome sparseJungle(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        MobSpawnSettings.Builder var2 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.baseJungleSpawns(var2);
        var2.addSpawn(MobCategory.CREATURE, 8, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 2, 4));
        return OverworldBiomes.baseJungle(var0, var1, 0.8f, false, true, false, var2, Musics.createGameMusic(SoundEvents.MUSIC_BIOME_SPARSE_JUNGLE));
    }

    public static Biome jungle(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        MobSpawnSettings.Builder var2 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.baseJungleSpawns(var2);
        var2.addSpawn(MobCategory.CREATURE, 40, new MobSpawnSettings.SpawnerData(EntityType.PARROT, 1, 2)).addSpawn(MobCategory.MONSTER, 2, new MobSpawnSettings.SpawnerData(EntityType.OCELOT, 1, 3)).addSpawn(MobCategory.CREATURE, 1, new MobSpawnSettings.SpawnerData(EntityType.PANDA, 1, 2));
        return OverworldBiomes.baseJungle(var0, var1, 0.9f, false, false, true, var2, Musics.createGameMusic(SoundEvents.MUSIC_BIOME_JUNGLE));
    }

    public static Biome bambooJungle(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        MobSpawnSettings.Builder var2 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.baseJungleSpawns(var2);
        var2.addSpawn(MobCategory.CREATURE, 40, new MobSpawnSettings.SpawnerData(EntityType.PARROT, 1, 2)).addSpawn(MobCategory.CREATURE, 80, new MobSpawnSettings.SpawnerData(EntityType.PANDA, 1, 2)).addSpawn(MobCategory.MONSTER, 2, new MobSpawnSettings.SpawnerData(EntityType.OCELOT, 1, 1));
        return OverworldBiomes.baseJungle(var0, var1, 0.9f, true, false, true, var2, Musics.createGameMusic(SoundEvents.MUSIC_BIOME_BAMBOO_JUNGLE));
    }

    private static Biome baseJungle(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, float var2, boolean var3, boolean var4, boolean var5, MobSpawnSettings.Builder var6, Music var7) {
        BiomeGenerationSettings.Builder var8 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var8);
        BiomeDefaultFeatures.addDefaultOres(var8);
        BiomeDefaultFeatures.addDefaultSoftDisks(var8);
        if (var3) {
            BiomeDefaultFeatures.addBambooVegetation(var8);
        } else {
            if (var5) {
                BiomeDefaultFeatures.addLightBambooVegetation(var8);
            }
            if (var4) {
                BiomeDefaultFeatures.addSparseJungleTrees(var8);
            } else {
                BiomeDefaultFeatures.addJungleTrees(var8);
            }
        }
        BiomeDefaultFeatures.addWarmFlowers(var8);
        BiomeDefaultFeatures.addJungleGrass(var8);
        BiomeDefaultFeatures.addDefaultMushrooms(var8);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var8, true);
        BiomeDefaultFeatures.addJungleVines(var8);
        if (var4) {
            BiomeDefaultFeatures.addSparseJungleMelons(var8);
        } else {
            BiomeDefaultFeatures.addJungleMelons(var8);
        }
        return OverworldBiomes.biome(true, 0.95f, var2, var6, var8, var7);
    }

    public static Biome windsweptHills(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2) {
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals(var3);
        var3.addSpawn(MobCategory.CREATURE, 5, new MobSpawnSettings.SpawnerData(EntityType.LLAMA, 4, 6));
        BiomeDefaultFeatures.commonSpawns(var3);
        BiomeGenerationSettings.Builder var4 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeDefaultFeatures.addDefaultOres(var4);
        BiomeDefaultFeatures.addDefaultSoftDisks(var4);
        if (var2) {
            BiomeDefaultFeatures.addMountainForestTrees(var4);
        } else {
            BiomeDefaultFeatures.addMountainTrees(var4);
        }
        BiomeDefaultFeatures.addBushes(var4);
        BiomeDefaultFeatures.addDefaultFlowers(var4);
        BiomeDefaultFeatures.addDefaultGrass(var4);
        BiomeDefaultFeatures.addDefaultMushrooms(var4);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var4, true);
        BiomeDefaultFeatures.addExtraEmeralds(var4);
        BiomeDefaultFeatures.addInfestedStone(var4);
        return OverworldBiomes.biome(true, 0.2f, 0.3f, var3, var4, NORMAL_MUSIC);
    }

    public static Biome desert(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        MobSpawnSettings.Builder var2 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.desertSpawns(var2);
        BiomeGenerationSettings.Builder var3 = new BiomeGenerationSettings.Builder(var0, var1);
        BiomeDefaultFeatures.addFossilDecoration(var3);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeDefaultFeatures.addDefaultOres(var3);
        BiomeDefaultFeatures.addDefaultSoftDisks(var3);
        BiomeDefaultFeatures.addDefaultFlowers(var3);
        BiomeDefaultFeatures.addDefaultGrass(var3);
        BiomeDefaultFeatures.addDesertVegetation(var3);
        BiomeDefaultFeatures.addDefaultMushrooms(var3);
        BiomeDefaultFeatures.addDesertExtraVegetation(var3);
        BiomeDefaultFeatures.addDesertExtraDecoration(var3);
        return OverworldBiomes.biome(false, 2.0f, 0.0f, var2, var3, Musics.createGameMusic(SoundEvents.MUSIC_BIOME_DESERT));
    }

    public static Biome plains(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2, boolean var3, boolean var4) {
        MobSpawnSettings.Builder var5 = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder var6 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var6);
        if (var3) {
            var5.creatureGenerationProbability(0.07f);
            BiomeDefaultFeatures.snowySpawns(var5);
            if (var4) {
                var6.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.ICE_SPIKE);
                var6.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.ICE_PATCH);
            }
        } else {
            BiomeDefaultFeatures.plainsSpawns(var5);
            BiomeDefaultFeatures.addPlainGrass(var6);
            if (var2) {
                var6.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PATCH_SUNFLOWER);
            } else {
                BiomeDefaultFeatures.addBushes(var6);
            }
        }
        BiomeDefaultFeatures.addDefaultOres(var6);
        BiomeDefaultFeatures.addDefaultSoftDisks(var6);
        if (var3) {
            BiomeDefaultFeatures.addSnowyTrees(var6);
            BiomeDefaultFeatures.addDefaultFlowers(var6);
            BiomeDefaultFeatures.addDefaultGrass(var6);
        } else {
            BiomeDefaultFeatures.addPlainVegetation(var6);
        }
        BiomeDefaultFeatures.addDefaultMushrooms(var6);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var6, true);
        float var7 = var3 ? 0.0f : 0.8f;
        return OverworldBiomes.biome(true, var7, var3 ? 0.5f : 0.4f, var5, var6, NORMAL_MUSIC);
    }

    public static Biome mushroomFields(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        MobSpawnSettings.Builder var2 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.mooshroomSpawns(var2);
        BiomeGenerationSettings.Builder var3 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeDefaultFeatures.addDefaultOres(var3);
        BiomeDefaultFeatures.addDefaultSoftDisks(var3);
        BiomeDefaultFeatures.addMushroomFieldVegetation(var3);
        BiomeDefaultFeatures.addNearWaterVegetation(var3);
        return OverworldBiomes.biome(true, 0.9f, 1.0f, var2, var3, NORMAL_MUSIC);
    }

    public static Biome savanna(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2, boolean var3) {
        BiomeGenerationSettings.Builder var4 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        if (!var2) {
            BiomeDefaultFeatures.addSavannaGrass(var4);
        }
        BiomeDefaultFeatures.addDefaultOres(var4);
        BiomeDefaultFeatures.addDefaultSoftDisks(var4);
        if (var2) {
            BiomeDefaultFeatures.addShatteredSavannaTrees(var4);
            BiomeDefaultFeatures.addDefaultFlowers(var4);
            BiomeDefaultFeatures.addShatteredSavannaGrass(var4);
        } else {
            BiomeDefaultFeatures.addSavannaTrees(var4);
            BiomeDefaultFeatures.addWarmFlowers(var4);
            BiomeDefaultFeatures.addSavannaExtraGrass(var4);
        }
        BiomeDefaultFeatures.addDefaultMushrooms(var4);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var4, true);
        MobSpawnSettings.Builder var5 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals(var5);
        var5.addSpawn(MobCategory.CREATURE, 1, new MobSpawnSettings.SpawnerData(EntityType.HORSE, 2, 6)).addSpawn(MobCategory.CREATURE, 1, new MobSpawnSettings.SpawnerData(EntityType.DONKEY, 1, 1)).addSpawn(MobCategory.CREATURE, 10, new MobSpawnSettings.SpawnerData(EntityType.ARMADILLO, 2, 3));
        BiomeDefaultFeatures.commonSpawns(var5);
        if (var3) {
            var5.addSpawn(MobCategory.CREATURE, 8, new MobSpawnSettings.SpawnerData(EntityType.LLAMA, 4, 4));
            var5.addSpawn(MobCategory.CREATURE, 8, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 4, 8));
        }
        return OverworldBiomes.biome(false, 2.0f, 0.0f, var5, var4, NORMAL_MUSIC);
    }

    public static Biome badlands(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2) {
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals(var3);
        BiomeDefaultFeatures.commonSpawns(var3);
        var3.addSpawn(MobCategory.CREATURE, 6, new MobSpawnSettings.SpawnerData(EntityType.ARMADILLO, 1, 2));
        var3.creatureGenerationProbability(0.03f);
        if (var2) {
            var3.addSpawn(MobCategory.CREATURE, 2, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 4, 8));
            var3.creatureGenerationProbability(0.04f);
        }
        BiomeGenerationSettings.Builder var4 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeDefaultFeatures.addDefaultOres(var4);
        BiomeDefaultFeatures.addExtraGold(var4);
        BiomeDefaultFeatures.addDefaultSoftDisks(var4);
        if (var2) {
            BiomeDefaultFeatures.addBadlandsTrees(var4);
        }
        BiomeDefaultFeatures.addBadlandGrass(var4);
        BiomeDefaultFeatures.addDefaultMushrooms(var4);
        BiomeDefaultFeatures.addBadlandExtraVegetation(var4);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(2.0f)).foliageColorOverride(10387789).grassColorOverride(9470285).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic(SoundEvents.MUSIC_BIOME_BADLANDS)).build()).mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    private static Biome baseOcean(MobSpawnSettings.Builder var0, int var1, int var2, BiomeGenerationSettings.Builder var3) {
        return OverworldBiomes.biome(true, 0.5f, 0.5f, var1, var2, null, null, null, var0, var3, NORMAL_MUSIC);
    }

    private static BiomeGenerationSettings.Builder baseOceanGeneration(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        BiomeGenerationSettings.Builder var2 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeDefaultFeatures.addDefaultOres(var2);
        BiomeDefaultFeatures.addDefaultSoftDisks(var2);
        BiomeDefaultFeatures.addWaterTrees(var2);
        BiomeDefaultFeatures.addDefaultFlowers(var2);
        BiomeDefaultFeatures.addDefaultGrass(var2);
        BiomeDefaultFeatures.addDefaultMushrooms(var2);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var2, true);
        return var2;
    }

    public static Biome coldOcean(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2) {
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.oceanSpawns(var3, 3, 4, 15);
        var3.addSpawn(MobCategory.WATER_AMBIENT, 15, new MobSpawnSettings.SpawnerData(EntityType.SALMON, 1, 5));
        BiomeGenerationSettings.Builder var4 = OverworldBiomes.baseOceanGeneration(var0, var1);
        var4.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, var2 ? AquaticPlacements.SEAGRASS_DEEP_COLD : AquaticPlacements.SEAGRASS_COLD);
        BiomeDefaultFeatures.addColdOceanExtraVegetation(var4);
        return OverworldBiomes.baseOcean(var3, 4020182, 329011, var4);
    }

    public static Biome ocean(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2) {
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.oceanSpawns(var3, 1, 4, 10);
        var3.addSpawn(MobCategory.WATER_CREATURE, 1, new MobSpawnSettings.SpawnerData(EntityType.DOLPHIN, 1, 2));
        BiomeGenerationSettings.Builder var4 = OverworldBiomes.baseOceanGeneration(var0, var1);
        var4.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, var2 ? AquaticPlacements.SEAGRASS_DEEP : AquaticPlacements.SEAGRASS_NORMAL);
        BiomeDefaultFeatures.addColdOceanExtraVegetation(var4);
        return OverworldBiomes.baseOcean(var3, 4159204, 329011, var4);
    }

    public static Biome lukeWarmOcean(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2) {
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        if (var2) {
            BiomeDefaultFeatures.oceanSpawns(var3, 8, 4, 8);
        } else {
            BiomeDefaultFeatures.oceanSpawns(var3, 10, 2, 15);
        }
        var3.addSpawn(MobCategory.WATER_AMBIENT, 5, new MobSpawnSettings.SpawnerData(EntityType.PUFFERFISH, 1, 3)).addSpawn(MobCategory.WATER_AMBIENT, 25, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 8, 8)).addSpawn(MobCategory.WATER_CREATURE, 2, new MobSpawnSettings.SpawnerData(EntityType.DOLPHIN, 1, 2));
        BiomeGenerationSettings.Builder var4 = OverworldBiomes.baseOceanGeneration(var0, var1);
        var4.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, var2 ? AquaticPlacements.SEAGRASS_DEEP_WARM : AquaticPlacements.SEAGRASS_WARM);
        BiomeDefaultFeatures.addLukeWarmKelp(var4);
        return OverworldBiomes.baseOcean(var3, 4566514, 267827, var4);
    }

    public static Biome warmOcean(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        MobSpawnSettings.Builder var2 = new MobSpawnSettings.Builder().addSpawn(MobCategory.WATER_AMBIENT, 15, new MobSpawnSettings.SpawnerData(EntityType.PUFFERFISH, 1, 3));
        BiomeDefaultFeatures.warmOceanSpawns(var2, 10, 4);
        BiomeGenerationSettings.Builder var3 = OverworldBiomes.baseOceanGeneration(var0, var1).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.WARM_OCEAN_VEGETATION).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_WARM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEA_PICKLE);
        return OverworldBiomes.baseOcean(var2, 4445678, 270131, var3);
    }

    public static Biome frozenOcean(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2) {
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder().addSpawn(MobCategory.WATER_CREATURE, 1, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 1, 4)).addSpawn(MobCategory.WATER_AMBIENT, 15, new MobSpawnSettings.SpawnerData(EntityType.SALMON, 1, 5)).addSpawn(MobCategory.CREATURE, 1, new MobSpawnSettings.SpawnerData(EntityType.POLAR_BEAR, 1, 2));
        BiomeDefaultFeatures.commonSpawns(var3);
        var3.addSpawn(MobCategory.MONSTER, 5, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 1, 1));
        float var4 = var2 ? 0.5f : 0.0f;
        BiomeGenerationSettings.Builder var5 = new BiomeGenerationSettings.Builder(var0, var1);
        BiomeDefaultFeatures.addIcebergs(var5);
        OverworldBiomes.globalOverworldGeneration(var5);
        BiomeDefaultFeatures.addBlueIce(var5);
        BiomeDefaultFeatures.addDefaultOres(var5);
        BiomeDefaultFeatures.addDefaultSoftDisks(var5);
        BiomeDefaultFeatures.addWaterTrees(var5);
        BiomeDefaultFeatures.addDefaultFlowers(var5);
        BiomeDefaultFeatures.addDefaultGrass(var5);
        BiomeDefaultFeatures.addDefaultMushrooms(var5);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var5, true);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(var4).temperatureAdjustment(Biome.TemperatureModifier.FROZEN).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(3750089).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(var4)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).build()).mobSpawnSettings(var3.build()).generationSettings(var5.build()).build();
    }

    public static Biome forest(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2, boolean var3, boolean var4) {
        Music var6;
        BiomeGenerationSettings.Builder var5 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var5);
        if (var4) {
            var6 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_FLOWER_FOREST);
            var5.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FOREST_FLOWERS);
        } else {
            var6 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_FOREST);
            BiomeDefaultFeatures.addForestFlowers(var5);
        }
        BiomeDefaultFeatures.addDefaultOres(var5);
        BiomeDefaultFeatures.addDefaultSoftDisks(var5);
        if (var4) {
            var5.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.TREES_FLOWER_FOREST);
            var5.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_FLOWER_FOREST);
            BiomeDefaultFeatures.addDefaultGrass(var5);
        } else {
            if (var2) {
                BiomeDefaultFeatures.addBirchForestFlowers(var5);
                if (var3) {
                    BiomeDefaultFeatures.addTallBirchTrees(var5);
                } else {
                    BiomeDefaultFeatures.addBirchTrees(var5);
                }
            } else {
                BiomeDefaultFeatures.addOtherBirchTrees(var5);
            }
            BiomeDefaultFeatures.addBushes(var5);
            BiomeDefaultFeatures.addDefaultFlowers(var5);
            BiomeDefaultFeatures.addForestGrass(var5);
        }
        BiomeDefaultFeatures.addDefaultMushrooms(var5);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var5, true);
        MobSpawnSettings.Builder var7 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals(var7);
        BiomeDefaultFeatures.commonSpawns(var7);
        if (var4) {
            var7.addSpawn(MobCategory.CREATURE, 4, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 2, 3));
        } else if (!var2) {
            var7.addSpawn(MobCategory.CREATURE, 5, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 4, 4));
        }
        float var8 = var2 ? 0.6f : 0.7f;
        return OverworldBiomes.biome(true, var8, var2 ? 0.6f : 0.8f, var7, var5, var6);
    }

    public static Biome taiga(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2) {
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals(var3);
        var3.addSpawn(MobCategory.CREATURE, 8, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 4, 4)).addSpawn(MobCategory.CREATURE, 4, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 2, 3)).addSpawn(MobCategory.CREATURE, 8, new MobSpawnSettings.SpawnerData(EntityType.FOX, 2, 4));
        BiomeDefaultFeatures.commonSpawns(var3);
        float var4 = var2 ? -0.5f : 0.25f;
        BiomeGenerationSettings.Builder var5 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var5);
        BiomeDefaultFeatures.addFerns(var5);
        BiomeDefaultFeatures.addDefaultOres(var5);
        BiomeDefaultFeatures.addDefaultSoftDisks(var5);
        BiomeDefaultFeatures.addTaigaTrees(var5);
        BiomeDefaultFeatures.addDefaultFlowers(var5);
        BiomeDefaultFeatures.addTaigaGrass(var5);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var5, true);
        if (var2) {
            BiomeDefaultFeatures.addRareBerryBushes(var5);
        } else {
            BiomeDefaultFeatures.addCommonBerryBushes(var5);
        }
        return OverworldBiomes.biome(true, var4, var2 ? 0.4f : 0.8f, var2 ? 4020182 : 4159204, 329011, null, null, null, var3, var5, NORMAL_MUSIC);
    }

    public static Biome darkForest(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2) {
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        if (!var2) {
            BiomeDefaultFeatures.farmAnimals(var3);
        }
        BiomeDefaultFeatures.commonSpawns(var3);
        BiomeGenerationSettings.Builder var4 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        var4.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, var2 ? VegetationPlacements.PALE_GARDEN_VEGETATION : VegetationPlacements.DARK_FOREST_VEGETATION);
        if (!var2) {
            BiomeDefaultFeatures.addForestFlowers(var4);
        } else {
            var4.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PALE_MOSS_PATCH);
            var4.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.PALE_GARDEN_FLOWERS);
        }
        BiomeDefaultFeatures.addDefaultOres(var4);
        BiomeDefaultFeatures.addDefaultSoftDisks(var4);
        if (!var2) {
            BiomeDefaultFeatures.addDefaultFlowers(var4);
        } else {
            var4.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.FLOWER_PALE_GARDEN);
        }
        BiomeDefaultFeatures.addForestGrass(var4);
        if (!var2) {
            BiomeDefaultFeatures.addDefaultMushrooms(var4);
            BiomeDefaultFeatures.addLeafLitterPatch(var4);
        }
        BiomeDefaultFeatures.addDefaultExtraVegetation(var4, true);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.7f).downfall(0.8f).specialEffects(var2 ? new BiomeSpecialEffects.Builder().waterColor(7768221).waterFogColor(5597568).fogColor(8484720).skyColor(0xB9B9B9).grassColorOverride(0x778272).foliageColorOverride(8883574).dryFoliageColorOverride(10528412).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).silenceAllBackgroundMusic().build() : new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(0.7f)).dryFoliageColorOverride(8082228).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.DARK_FOREST).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(Musics.createGameMusic(SoundEvents.MUSIC_BIOME_FOREST)).build()).mobSpawnSettings(var3.build()).generationSettings(var4.build()).build();
    }

    public static Biome swamp(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        MobSpawnSettings.Builder var2 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.farmAnimals(var2);
        BiomeDefaultFeatures.commonSpawns(var2, 70);
        var2.addSpawn(MobCategory.MONSTER, 1, new MobSpawnSettings.SpawnerData(EntityType.SLIME, 1, 1));
        var2.addSpawn(MobCategory.MONSTER, 30, new MobSpawnSettings.SpawnerData(EntityType.BOGGED, 4, 4));
        var2.addSpawn(MobCategory.CREATURE, 10, new MobSpawnSettings.SpawnerData(EntityType.FROG, 2, 5));
        BiomeGenerationSettings.Builder var3 = new BiomeGenerationSettings.Builder(var0, var1);
        BiomeDefaultFeatures.addFossilDecoration(var3);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeDefaultFeatures.addDefaultOres(var3);
        BiomeDefaultFeatures.addSwampClayDisk(var3);
        BiomeDefaultFeatures.addSwampVegetation(var3);
        BiomeDefaultFeatures.addDefaultMushrooms(var3);
        BiomeDefaultFeatures.addSwampExtraVegetation(var3);
        var3.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_SWAMP);
        Music var4 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_SWAMP);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.8f).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(6388580).waterFogColor(2302743).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(0.8f)).foliageColorOverride(6975545).dryFoliageColorOverride(8082228).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.SWAMP).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(var4).build()).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static Biome mangroveSwamp(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        MobSpawnSettings.Builder var2 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns(var2, 70);
        var2.addSpawn(MobCategory.MONSTER, 1, new MobSpawnSettings.SpawnerData(EntityType.SLIME, 1, 1));
        var2.addSpawn(MobCategory.MONSTER, 30, new MobSpawnSettings.SpawnerData(EntityType.BOGGED, 4, 4));
        var2.addSpawn(MobCategory.CREATURE, 10, new MobSpawnSettings.SpawnerData(EntityType.FROG, 2, 5));
        var2.addSpawn(MobCategory.WATER_AMBIENT, 25, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 8, 8));
        BiomeGenerationSettings.Builder var3 = new BiomeGenerationSettings.Builder(var0, var1);
        BiomeDefaultFeatures.addFossilDecoration(var3);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeDefaultFeatures.addDefaultOres(var3);
        BiomeDefaultFeatures.addMangroveSwampDisks(var3);
        BiomeDefaultFeatures.addMangroveSwampVegetation(var3);
        BiomeDefaultFeatures.addMangroveSwampExtraVegetation(var3);
        Music var4 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_SWAMP);
        return new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.8f).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(3832426).waterFogColor(5077600).fogColor(12638463).skyColor(OverworldBiomes.calculateSkyColor(0.8f)).foliageColorOverride(9285927).dryFoliageColorOverride(8082228).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.SWAMP).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(var4).build()).mobSpawnSettings(var2.build()).generationSettings(var3.build()).build();
    }

    public static Biome river(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2) {
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder().addSpawn(MobCategory.WATER_CREATURE, 2, new MobSpawnSettings.SpawnerData(EntityType.SQUID, 1, 4)).addSpawn(MobCategory.WATER_AMBIENT, 5, new MobSpawnSettings.SpawnerData(EntityType.SALMON, 1, 5));
        BiomeDefaultFeatures.commonSpawns(var3);
        var3.addSpawn(MobCategory.MONSTER, var2 ? 1 : 100, new MobSpawnSettings.SpawnerData(EntityType.DROWNED, 1, 1));
        BiomeGenerationSettings.Builder var4 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var4);
        BiomeDefaultFeatures.addDefaultOres(var4);
        BiomeDefaultFeatures.addDefaultSoftDisks(var4);
        BiomeDefaultFeatures.addWaterTrees(var4);
        BiomeDefaultFeatures.addBushes(var4);
        BiomeDefaultFeatures.addDefaultFlowers(var4);
        BiomeDefaultFeatures.addDefaultGrass(var4);
        BiomeDefaultFeatures.addDefaultMushrooms(var4);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var4, true);
        if (!var2) {
            var4.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.SEAGRASS_RIVER);
        }
        float var5 = var2 ? 0.0f : 0.5f;
        return OverworldBiomes.biome(true, var5, 0.5f, var2 ? 3750089 : 4159204, 329011, null, null, null, var3, var4, NORMAL_MUSIC);
    }

    public static Biome beach(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2, boolean var3) {
        boolean var5;
        MobSpawnSettings.Builder var4 = new MobSpawnSettings.Builder();
        boolean bl = var5 = !var3 && !var2;
        if (var5) {
            var4.addSpawn(MobCategory.CREATURE, 5, new MobSpawnSettings.SpawnerData(EntityType.TURTLE, 2, 5));
        }
        BiomeDefaultFeatures.commonSpawns(var4);
        BiomeGenerationSettings.Builder var6 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var6);
        BiomeDefaultFeatures.addDefaultOres(var6);
        BiomeDefaultFeatures.addDefaultSoftDisks(var6);
        BiomeDefaultFeatures.addDefaultFlowers(var6);
        BiomeDefaultFeatures.addDefaultGrass(var6);
        BiomeDefaultFeatures.addDefaultMushrooms(var6);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var6, true);
        float var7 = var2 ? 0.05f : (var3 ? 0.2f : 0.8f);
        return OverworldBiomes.biome(true, var7, var5 ? 0.4f : 0.3f, var2 ? 4020182 : 4159204, 329011, null, null, null, var4, var6, NORMAL_MUSIC);
    }

    public static Biome theVoid(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        BiomeGenerationSettings.Builder var2 = new BiomeGenerationSettings.Builder(var0, var1);
        var2.addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, MiscOverworldPlacements.VOID_START_PLATFORM);
        return OverworldBiomes.biome(false, 0.5f, 0.5f, new MobSpawnSettings.Builder(), var2, NORMAL_MUSIC);
    }

    public static Biome meadowOrCherryGrove(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1, boolean var2) {
        BiomeGenerationSettings.Builder var3 = new BiomeGenerationSettings.Builder(var0, var1);
        MobSpawnSettings.Builder var4 = new MobSpawnSettings.Builder();
        var4.addSpawn(MobCategory.CREATURE, 1, new MobSpawnSettings.SpawnerData(var2 ? EntityType.PIG : EntityType.DONKEY, 1, 2)).addSpawn(MobCategory.CREATURE, 2, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 2, 6)).addSpawn(MobCategory.CREATURE, 2, new MobSpawnSettings.SpawnerData(EntityType.SHEEP, 2, 4));
        BiomeDefaultFeatures.commonSpawns(var4);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeDefaultFeatures.addPlainGrass(var3);
        BiomeDefaultFeatures.addDefaultOres(var3);
        BiomeDefaultFeatures.addDefaultSoftDisks(var3);
        if (var2) {
            BiomeDefaultFeatures.addCherryGroveVegetation(var3);
        } else {
            BiomeDefaultFeatures.addMeadowVegetation(var3);
        }
        BiomeDefaultFeatures.addExtraEmeralds(var3);
        BiomeDefaultFeatures.addInfestedStone(var3);
        Music var5 = Musics.createGameMusic(var2 ? SoundEvents.MUSIC_BIOME_CHERRY_GROVE : SoundEvents.MUSIC_BIOME_MEADOW);
        if (var2) {
            return OverworldBiomes.biome(true, 0.5f, 0.8f, 6141935, 6141935, 11983713, 11983713, null, var4, var3, var5);
        }
        return OverworldBiomes.biome(true, 0.5f, 0.8f, 937679, 329011, null, null, null, var4, var3, var5);
    }

    public static Biome frozenPeaks(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        BiomeGenerationSettings.Builder var2 = new BiomeGenerationSettings.Builder(var0, var1);
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        var3.addSpawn(MobCategory.CREATURE, 5, new MobSpawnSettings.SpawnerData(EntityType.GOAT, 1, 3));
        BiomeDefaultFeatures.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeDefaultFeatures.addFrozenSprings(var2);
        BiomeDefaultFeatures.addDefaultOres(var2);
        BiomeDefaultFeatures.addDefaultSoftDisks(var2);
        BiomeDefaultFeatures.addExtraEmeralds(var2);
        BiomeDefaultFeatures.addInfestedStone(var2);
        Music var4 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_FROZEN_PEAKS);
        return OverworldBiomes.biome(true, -0.7f, 0.9f, var3, var2, var4);
    }

    public static Biome jaggedPeaks(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        BiomeGenerationSettings.Builder var2 = new BiomeGenerationSettings.Builder(var0, var1);
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        var3.addSpawn(MobCategory.CREATURE, 5, new MobSpawnSettings.SpawnerData(EntityType.GOAT, 1, 3));
        BiomeDefaultFeatures.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeDefaultFeatures.addFrozenSprings(var2);
        BiomeDefaultFeatures.addDefaultOres(var2);
        BiomeDefaultFeatures.addDefaultSoftDisks(var2);
        BiomeDefaultFeatures.addExtraEmeralds(var2);
        BiomeDefaultFeatures.addInfestedStone(var2);
        Music var4 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_JAGGED_PEAKS);
        return OverworldBiomes.biome(true, -0.7f, 0.9f, var3, var2, var4);
    }

    public static Biome stonyPeaks(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        BiomeGenerationSettings.Builder var2 = new BiomeGenerationSettings.Builder(var0, var1);
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeDefaultFeatures.addDefaultOres(var2);
        BiomeDefaultFeatures.addDefaultSoftDisks(var2);
        BiomeDefaultFeatures.addExtraEmeralds(var2);
        BiomeDefaultFeatures.addInfestedStone(var2);
        Music var4 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_STONY_PEAKS);
        return OverworldBiomes.biome(true, 1.0f, 0.3f, var3, var2, var4);
    }

    public static Biome snowySlopes(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        BiomeGenerationSettings.Builder var2 = new BiomeGenerationSettings.Builder(var0, var1);
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        var3.addSpawn(MobCategory.CREATURE, 4, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 2, 3)).addSpawn(MobCategory.CREATURE, 5, new MobSpawnSettings.SpawnerData(EntityType.GOAT, 1, 3));
        BiomeDefaultFeatures.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeDefaultFeatures.addFrozenSprings(var2);
        BiomeDefaultFeatures.addDefaultOres(var2);
        BiomeDefaultFeatures.addDefaultSoftDisks(var2);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var2, false);
        BiomeDefaultFeatures.addExtraEmeralds(var2);
        BiomeDefaultFeatures.addInfestedStone(var2);
        Music var4 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_SNOWY_SLOPES);
        return OverworldBiomes.biome(true, -0.3f, 0.9f, var3, var2, var4);
    }

    public static Biome grove(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        BiomeGenerationSettings.Builder var2 = new BiomeGenerationSettings.Builder(var0, var1);
        MobSpawnSettings.Builder var3 = new MobSpawnSettings.Builder();
        var3.addSpawn(MobCategory.CREATURE, 1, new MobSpawnSettings.SpawnerData(EntityType.WOLF, 1, 1)).addSpawn(MobCategory.CREATURE, 8, new MobSpawnSettings.SpawnerData(EntityType.RABBIT, 2, 3)).addSpawn(MobCategory.CREATURE, 4, new MobSpawnSettings.SpawnerData(EntityType.FOX, 2, 4));
        BiomeDefaultFeatures.commonSpawns(var3);
        OverworldBiomes.globalOverworldGeneration(var2);
        BiomeDefaultFeatures.addFrozenSprings(var2);
        BiomeDefaultFeatures.addDefaultOres(var2);
        BiomeDefaultFeatures.addDefaultSoftDisks(var2);
        BiomeDefaultFeatures.addGroveTrees(var2);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var2, false);
        BiomeDefaultFeatures.addExtraEmeralds(var2);
        BiomeDefaultFeatures.addInfestedStone(var2);
        Music var4 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_GROVE);
        return OverworldBiomes.biome(true, -0.2f, 0.8f, var3, var2, var4);
    }

    public static Biome lushCaves(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        MobSpawnSettings.Builder var2 = new MobSpawnSettings.Builder();
        var2.addSpawn(MobCategory.AXOLOTLS, 10, new MobSpawnSettings.SpawnerData(EntityType.AXOLOTL, 4, 6));
        var2.addSpawn(MobCategory.WATER_AMBIENT, 25, new MobSpawnSettings.SpawnerData(EntityType.TROPICAL_FISH, 8, 8));
        BiomeDefaultFeatures.commonSpawns(var2);
        BiomeGenerationSettings.Builder var3 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeDefaultFeatures.addPlainGrass(var3);
        BiomeDefaultFeatures.addDefaultOres(var3);
        BiomeDefaultFeatures.addLushCavesSpecialOres(var3);
        BiomeDefaultFeatures.addDefaultSoftDisks(var3);
        BiomeDefaultFeatures.addLushCavesVegetationFeatures(var3);
        Music var4 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_LUSH_CAVES);
        return OverworldBiomes.biome(true, 0.5f, 0.5f, var2, var3, var4);
    }

    public static Biome dripstoneCaves(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        MobSpawnSettings.Builder var2 = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.dripstoneCavesSpawns(var2);
        BiomeGenerationSettings.Builder var3 = new BiomeGenerationSettings.Builder(var0, var1);
        OverworldBiomes.globalOverworldGeneration(var3);
        BiomeDefaultFeatures.addPlainGrass(var3);
        BiomeDefaultFeatures.addDefaultOres(var3, true);
        BiomeDefaultFeatures.addDefaultSoftDisks(var3);
        BiomeDefaultFeatures.addPlainVegetation(var3);
        BiomeDefaultFeatures.addDefaultMushrooms(var3);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var3, false);
        BiomeDefaultFeatures.addDripstone(var3);
        Music var4 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_DRIPSTONE_CAVES);
        return OverworldBiomes.biome(true, 0.8f, 0.4f, var2, var3, var4);
    }

    public static Biome deepDark(HolderGetter<PlacedFeature> var0, HolderGetter<ConfiguredWorldCarver<?>> var1) {
        MobSpawnSettings.Builder var2 = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder var3 = new BiomeGenerationSettings.Builder(var0, var1);
        var3.addCarver(Carvers.CAVE);
        var3.addCarver(Carvers.CAVE_EXTRA_UNDERGROUND);
        var3.addCarver(Carvers.CANYON);
        BiomeDefaultFeatures.addDefaultCrystalFormations(var3);
        BiomeDefaultFeatures.addDefaultMonsterRoom(var3);
        BiomeDefaultFeatures.addDefaultUndergroundVariety(var3);
        BiomeDefaultFeatures.addSurfaceFreezing(var3);
        BiomeDefaultFeatures.addPlainGrass(var3);
        BiomeDefaultFeatures.addDefaultOres(var3);
        BiomeDefaultFeatures.addDefaultSoftDisks(var3);
        BiomeDefaultFeatures.addPlainVegetation(var3);
        BiomeDefaultFeatures.addDefaultMushrooms(var3);
        BiomeDefaultFeatures.addDefaultExtraVegetation(var3, false);
        BiomeDefaultFeatures.addSculk(var3);
        Music var4 = Musics.createGameMusic(SoundEvents.MUSIC_BIOME_DEEP_DARK);
        return OverworldBiomes.biome(true, 0.8f, 0.4f, var2, var3, var4);
    }
}

