/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;

public record ByteTag(byte value) implements NumericTag
{
    private static final int SELF_SIZE_IN_BYTES = 9;
    public static final TagType<ByteTag> TYPE = new TagType.StaticSize<ByteTag>(){

        @Override
        public ByteTag load(DataInput var0, NbtAccounter var1) throws IOException {
            return ByteTag.valueOf(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput var0, StreamTagVisitor var1, NbtAccounter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static byte readAccounted(DataInput var0, NbtAccounter var1) throws IOException {
            var1.accountBytes(9L);
            return var0.readByte();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public String getName() {
            return "BYTE";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Byte";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    public static final ByteTag ZERO = ByteTag.valueOf((byte)0);
    public static final ByteTag ONE = ByteTag.valueOf((byte)1);

    public static ByteTag valueOf(byte var0) {
        return Cache.cache[128 + var0];
    }

    public static ByteTag valueOf(boolean var0) {
        return var0 ? ONE : ZERO;
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeByte(this.value);
    }

    @Override
    public int sizeInBytes() {
        return 9;
    }

    @Override
    public byte getId() {
        return 1;
    }

    public TagType<ByteTag> getType() {
        return TYPE;
    }

    @Override
    public ByteTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitByte(this);
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public Number box() {
        return this.value;
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor var0) {
        return var0.visit(this.value);
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitByte(this);
        return var0.build();
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }

    static class Cache {
        static final ByteTag[] cache = new ByteTag[256];

        private Cache() {
        }

        static {
            for (int var0 = 0; var0 < cache.length; ++var0) {
                Cache.cache[var0] = new ByteTag((byte)(var0 - 128));
            }
        }
    }
}

