/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;

public class TranslatableContents
implements ComponentContents {
    public static final Object[] NO_ARGS = new Object[0];
    private static final Codec<Object> PRIMITIVE_ARG_CODEC = ExtraCodecs.JAVA.validate(TranslatableContents::filterAllowedArguments);
    private static final Codec<Object> ARG_CODEC = Codec.either(PRIMITIVE_ARG_CODEC, ComponentSerialization.CODEC).xmap(var02 -> var02.map(var0 -> var0, var0 -> Objects.requireNonNullElse(var0.tryCollapseToString(), var0)), var0 -> {
        Either either;
        if (var0 instanceof Component) {
            Component var1 = (Component)var0;
            either = Either.right((Object)var1);
        } else {
            either = Either.left((Object)var0);
        }
        return either;
    });
    public static final MapCodec<TranslatableContents> MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.STRING.fieldOf("translate").forGetter(var0 -> var0.key), (App)Codec.STRING.lenientOptionalFieldOf("fallback").forGetter(var0 -> Optional.ofNullable(var0.fallback)), (App)ARG_CODEC.listOf().optionalFieldOf("with").forGetter(var0 -> TranslatableContents.adjustArgs(var0.args))).apply((Applicative)var02, TranslatableContents::create));
    private static final FormattedText TEXT_PERCENT = FormattedText.of("%");
    private static final FormattedText TEXT_NULL = FormattedText.of("null");
    private final String key;
    @Nullable
    private final String fallback;
    private final Object[] args;
    @Nullable
    private Language decomposedWith;
    private List<FormattedText> decomposedParts = ImmutableList.of();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    private static DataResult<Object> filterAllowedArguments(@Nullable Object var0) {
        if (!TranslatableContents.isAllowedPrimitiveArgument(var0)) {
            return DataResult.error(() -> "This value needs to be parsed as component");
        }
        return DataResult.success((Object)var0);
    }

    public static boolean isAllowedPrimitiveArgument(@Nullable Object var0) {
        return var0 instanceof Number || var0 instanceof Boolean || var0 instanceof String;
    }

    private static Optional<List<Object>> adjustArgs(Object[] var0) {
        return var0.length == 0 ? Optional.empty() : Optional.of(Arrays.asList(var0));
    }

    private static Object[] adjustArgs(Optional<List<Object>> var02) {
        return var02.map(var0 -> var0.isEmpty() ? NO_ARGS : var0.toArray()).orElse(NO_ARGS);
    }

    private static TranslatableContents create(String var0, Optional<String> var1, Optional<List<Object>> var2) {
        return new TranslatableContents(var0, var1.orElse(null), TranslatableContents.adjustArgs(var2));
    }

    public TranslatableContents(String var0, @Nullable String var1, Object[] var2) {
        this.key = var0;
        this.fallback = var1;
        this.args = var2;
    }

    public MapCodec<TranslatableContents> codec() {
        return MAP_CODEC;
    }

    private void decompose() {
        Language var0 = Language.getInstance();
        if (var0 == this.decomposedWith) {
            return;
        }
        this.decomposedWith = var0;
        String var1 = this.fallback != null ? var0.getOrDefault(this.key, this.fallback) : var0.getOrDefault(this.key);
        try {
            ImmutableList.Builder var2 = ImmutableList.builder();
            this.decomposeTemplate(var1, arg_0 -> ((ImmutableList.Builder)var2).add(arg_0));
            this.decomposedParts = var2.build();
        }
        catch (TranslatableFormatException var2) {
            this.decomposedParts = ImmutableList.of((Object)FormattedText.of(var1));
        }
    }

    private void decomposeTemplate(String var0, Consumer<FormattedText> var1) {
        Matcher var2 = FORMAT_PATTERN.matcher(var0);
        try {
            int var3 = 0;
            int var4 = 0;
            while (var2.find(var4)) {
                String var7;
                int var5 = var2.start();
                int var6 = var2.end();
                if (var5 > var4) {
                    var7 = var0.substring(var4, var5);
                    if (var7.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    var1.accept(FormattedText.of(var7));
                }
                var7 = var2.group(2);
                String var8 = var0.substring(var5, var6);
                if ("%".equals(var7) && "%%".equals(var8)) {
                    var1.accept(TEXT_PERCENT);
                } else if ("s".equals(var7)) {
                    String var9 = var2.group(1);
                    int var10 = var9 != null ? Integer.parseInt(var9) - 1 : var3++;
                    var1.accept(this.getArgument(var10));
                } else {
                    throw new TranslatableFormatException(this, "Unsupported format: '" + var8 + "'");
                }
                var4 = var6;
            }
            if (var4 < var0.length()) {
                String var5 = var0.substring(var4);
                if (var5.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                var1.accept(FormattedText.of(var5));
            }
        }
        catch (IllegalArgumentException var3) {
            throw new TranslatableFormatException(this, (Throwable)var3);
        }
    }

    private FormattedText getArgument(int var0) {
        if (var0 < 0 || var0 >= this.args.length) {
            throw new TranslatableFormatException(this, var0);
        }
        Object var1 = this.args[var0];
        if (var1 instanceof Component) {
            Component var2 = (Component)var1;
            return var2;
        }
        return var1 == null ? TEXT_NULL : FormattedText.of(var1.toString());
    }

    @Override
    public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> var0, Style var1) {
        this.decompose();
        for (FormattedText var3 : this.decomposedParts) {
            Optional<T> var4 = var3.visit(var0, var1);
            if (!var4.isPresent()) continue;
            return var4;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> visit(FormattedText.ContentConsumer<T> var0) {
        this.decompose();
        for (FormattedText var2 : this.decomposedParts) {
            Optional<T> var3 = var2.visit(var0);
            if (!var3.isPresent()) continue;
            return var3;
        }
        return Optional.empty();
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack var0, @Nullable Entity var1, int var2) throws CommandSyntaxException {
        Object[] var3 = new Object[this.args.length];
        for (int var4 = 0; var4 < var3.length; ++var4) {
            Object var5 = this.args[var4];
            if (var5 instanceof Component) {
                Component var6 = (Component)var5;
                var3[var4] = ComponentUtils.updateForEntity(var0, var6, var1, var2);
                continue;
            }
            var3[var4] = var5;
        }
        return MutableComponent.create(new TranslatableContents(this.key, this.fallback, var3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof TranslatableContents)) return false;
        TranslatableContents var1 = (TranslatableContents)var0;
        if (!Objects.equals(this.key, var1.key)) return false;
        if (!Objects.equals(this.fallback, var1.fallback)) return false;
        if (!Arrays.equals(this.args, var1.args)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = Objects.hashCode(this.key);
        var0 = 31 * var0 + Objects.hashCode(this.fallback);
        var0 = 31 * var0 + Arrays.hashCode(this.args);
        return var0;
    }

    public String toString() {
        return "translation{key='" + this.key + "'" + (String)(this.fallback != null ? ", fallback='" + this.fallback + "'" : "") + ", args=" + Arrays.toString(this.args) + "}";
    }

    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getFallback() {
        return this.fallback;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

