/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.entity.player.Abilities;

public class ClientboundPlayerAbilitiesPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundPlayerAbilitiesPacket> STREAM_CODEC = Packet.codec(ClientboundPlayerAbilitiesPacket::write, ClientboundPlayerAbilitiesPacket::new);
    private static final int FLAG_INVULNERABLE = 1;
    private static final int FLAG_FLYING = 2;
    private static final int FLAG_CAN_FLY = 4;
    private static final int FLAG_INSTABUILD = 8;
    private final boolean invulnerable;
    private final boolean isFlying;
    private final boolean canFly;
    private final boolean instabuild;
    private final float flyingSpeed;
    private final float walkingSpeed;

    public ClientboundPlayerAbilitiesPacket(Abilities var0) {
        this.invulnerable = var0.invulnerable;
        this.isFlying = var0.flying;
        this.canFly = var0.mayfly;
        this.instabuild = var0.instabuild;
        this.flyingSpeed = var0.getFlyingSpeed();
        this.walkingSpeed = var0.getWalkingSpeed();
    }

    private ClientboundPlayerAbilitiesPacket(FriendlyByteBuf var0) {
        byte var1 = var0.readByte();
        this.invulnerable = (var1 & 1) != 0;
        this.isFlying = (var1 & 2) != 0;
        this.canFly = (var1 & 4) != 0;
        this.instabuild = (var1 & 8) != 0;
        this.flyingSpeed = var0.readFloat();
        this.walkingSpeed = var0.readFloat();
    }

    private void write(FriendlyByteBuf var0) {
        byte var1 = 0;
        if (this.invulnerable) {
            var1 = (byte)(var1 | 1);
        }
        if (this.isFlying) {
            var1 = (byte)(var1 | 2);
        }
        if (this.canFly) {
            var1 = (byte)(var1 | 4);
        }
        if (this.instabuild) {
            var1 = (byte)(var1 | 8);
        }
        var0.writeByte(var1);
        var0.writeFloat(this.flyingSpeed);
        var0.writeFloat(this.walkingSpeed);
    }

    @Override
    public PacketType<ClientboundPlayerAbilitiesPacket> type() {
        return GamePacketTypes.CLIENTBOUND_PLAYER_ABILITIES;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handlePlayerAbilities(this);
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public boolean canFly() {
        return this.canFly;
    }

    public boolean canInstabuild() {
        return this.instabuild;
    }

    public float getFlyingSpeed() {
        return this.flyingSpeed;
    }

    public float getWalkingSpeed() {
        return this.walkingSpeed;
    }
}

