/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class ClientboundSetPlayerTeamPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSetPlayerTeamPacket> STREAM_CODEC = Packet.codec(ClientboundSetPlayerTeamPacket::write, ClientboundSetPlayerTeamPacket::new);
    private static final int METHOD_ADD = 0;
    private static final int METHOD_REMOVE = 1;
    private static final int METHOD_CHANGE = 2;
    private static final int METHOD_JOIN = 3;
    private static final int METHOD_LEAVE = 4;
    private static final int MAX_VISIBILITY_LENGTH = 40;
    private static final int MAX_COLLISION_LENGTH = 40;
    private final int method;
    private final String name;
    private final Collection<String> players;
    private final Optional<Parameters> parameters;

    private ClientboundSetPlayerTeamPacket(String var0, int var1, Optional<Parameters> var2, Collection<String> var3) {
        this.name = var0;
        this.method = var1;
        this.parameters = var2;
        this.players = ImmutableList.copyOf(var3);
    }

    public static ClientboundSetPlayerTeamPacket createAddOrModifyPacket(PlayerTeam var0, boolean var1) {
        return new ClientboundSetPlayerTeamPacket(var0.getName(), var1 ? 0 : 2, Optional.of(new Parameters(var0)), var1 ? var0.getPlayers() : ImmutableList.of());
    }

    public static ClientboundSetPlayerTeamPacket createRemovePacket(PlayerTeam var0) {
        return new ClientboundSetPlayerTeamPacket(var0.getName(), 1, Optional.empty(), (Collection<String>)ImmutableList.of());
    }

    public static ClientboundSetPlayerTeamPacket createPlayerPacket(PlayerTeam var0, String var1, Action var2) {
        return new ClientboundSetPlayerTeamPacket(var0.getName(), var2 == Action.ADD ? 3 : 4, Optional.empty(), (Collection<String>)ImmutableList.of((Object)var1));
    }

    private ClientboundSetPlayerTeamPacket(RegistryFriendlyByteBuf var0) {
        this.name = var0.readUtf();
        this.method = var0.readByte();
        this.parameters = ClientboundSetPlayerTeamPacket.shouldHaveParameters(this.method) ? Optional.of(new Parameters(var0)) : Optional.empty();
        this.players = ClientboundSetPlayerTeamPacket.shouldHavePlayerList(this.method) ? var0.readList(FriendlyByteBuf::readUtf) : ImmutableList.of();
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeUtf(this.name);
        var0.writeByte(this.method);
        if (ClientboundSetPlayerTeamPacket.shouldHaveParameters(this.method)) {
            this.parameters.orElseThrow(() -> new IllegalStateException("Parameters not present, but method is" + this.method)).write(var0);
        }
        if (ClientboundSetPlayerTeamPacket.shouldHavePlayerList(this.method)) {
            var0.writeCollection(this.players, FriendlyByteBuf::writeUtf);
        }
    }

    private static boolean shouldHavePlayerList(int var0) {
        return var0 == 0 || var0 == 3 || var0 == 4;
    }

    private static boolean shouldHaveParameters(int var0) {
        return var0 == 0 || var0 == 2;
    }

    @Nullable
    public Action getPlayerAction() {
        return switch (this.method) {
            case 0, 3 -> Action.ADD;
            case 4 -> Action.REMOVE;
            default -> null;
        };
    }

    @Nullable
    public Action getTeamAction() {
        return switch (this.method) {
            case 0 -> Action.ADD;
            case 1 -> Action.REMOVE;
            default -> null;
        };
    }

    @Override
    public PacketType<ClientboundSetPlayerTeamPacket> type() {
        return GamePacketTypes.CLIENTBOUND_SET_PLAYER_TEAM;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleSetPlayerTeamPacket(this);
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getPlayers() {
        return this.players;
    }

    public Optional<Parameters> getParameters() {
        return this.parameters;
    }

    public static class Parameters {
        private final Component displayName;
        private final Component playerPrefix;
        private final Component playerSuffix;
        private final Team.Visibility nametagVisibility;
        private final Team.CollisionRule collisionRule;
        private final ChatFormatting color;
        private final int options;

        public Parameters(PlayerTeam var0) {
            this.displayName = var0.getDisplayName();
            this.options = var0.packOptions();
            this.nametagVisibility = var0.getNameTagVisibility();
            this.collisionRule = var0.getCollisionRule();
            this.color = var0.getColor();
            this.playerPrefix = var0.getPlayerPrefix();
            this.playerSuffix = var0.getPlayerSuffix();
        }

        public Parameters(RegistryFriendlyByteBuf var0) {
            this.displayName = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(var0);
            this.options = var0.readByte();
            this.nametagVisibility = (Team.Visibility)Team.Visibility.STREAM_CODEC.decode(var0);
            this.collisionRule = (Team.CollisionRule)Team.CollisionRule.STREAM_CODEC.decode(var0);
            this.color = var0.readEnum(ChatFormatting.class);
            this.playerPrefix = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(var0);
            this.playerSuffix = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(var0);
        }

        public Component getDisplayName() {
            return this.displayName;
        }

        public int getOptions() {
            return this.options;
        }

        public ChatFormatting getColor() {
            return this.color;
        }

        public Team.Visibility getNametagVisibility() {
            return this.nametagVisibility;
        }

        public Team.CollisionRule getCollisionRule() {
            return this.collisionRule;
        }

        public Component getPlayerPrefix() {
            return this.playerPrefix;
        }

        public Component getPlayerSuffix() {
            return this.playerSuffix;
        }

        public void write(RegistryFriendlyByteBuf var0) {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(var0, this.displayName);
            var0.writeByte(this.options);
            Team.Visibility.STREAM_CODEC.encode(var0, this.nametagVisibility);
            Team.CollisionRule.STREAM_CODEC.encode(var0, this.collisionRule);
            var0.writeEnum(this.color);
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(var0, this.playerPrefix);
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(var0, this.playerSuffix);
        }
    }

    public static enum Action {
        ADD,
        REMOVE;

    }
}

