/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Queue;
import net.minecraft.util.ArrayListDeque;

public class SuppressedExceptionCollector {
    private static final int LATEST_ENTRY_COUNT = 8;
    private final Queue<LongEntry> latestEntries = new ArrayListDeque<LongEntry>();
    private final Object2IntLinkedOpenHashMap<ShortEntry> entryCounts = new Object2IntLinkedOpenHashMap();

    private static long currentTimeMs() {
        return System.currentTimeMillis();
    }

    public synchronized void addEntry(String var0, Throwable var1) {
        long var2 = SuppressedExceptionCollector.currentTimeMs();
        String var4 = var1.getMessage();
        this.latestEntries.add(new LongEntry(var2, var0, var1.getClass(), var4));
        while (this.latestEntries.size() > 8) {
            this.latestEntries.remove();
        }
        ShortEntry var5 = new ShortEntry(var0, var1.getClass());
        int var6 = this.entryCounts.getInt((Object)var5);
        this.entryCounts.putAndMoveToFirst((Object)var5, var6 + 1);
    }

    public synchronized String dump() {
        long var0 = SuppressedExceptionCollector.currentTimeMs();
        StringBuilder var2 = new StringBuilder();
        if (!this.latestEntries.isEmpty()) {
            var2.append("\n\t\tLatest entries:\n");
            for (LongEntry var4 : this.latestEntries) {
                var2.append("\t\t\t").append(var4.location).append(":").append(var4.cls).append(": ").append(var4.message).append(" (").append(var0 - var4.timestampMs).append("ms ago)").append("\n");
            }
        }
        if (!this.entryCounts.isEmpty()) {
            if (var2.isEmpty()) {
                var2.append("\n");
            }
            var2.append("\t\tEntry counts:\n");
            for (LongEntry var4 : Object2IntMaps.fastIterable(this.entryCounts)) {
                var2.append("\t\t\t").append(((ShortEntry)var4.getKey()).location).append(":").append(((ShortEntry)var4.getKey()).cls).append(" x ").append(var4.getIntValue()).append("\n");
            }
        }
        if (var2.isEmpty()) {
            return "~~NONE~~";
        }
        return var2.toString();
    }

    static final class LongEntry
    extends Record {
        final long timestampMs;
        final String location;
        final Class<? extends Throwable> cls;
        final String message;

        LongEntry(long var0, String var2, Class<? extends Throwable> var3, String var4) {
            this.timestampMs = var0;
            this.location = var2;
            this.cls = var3;
            this.message = var4;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LongEntry.class, "timestampMs;location;cls;message", "timestampMs", "location", "cls", "message"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LongEntry.class, "timestampMs;location;cls;message", "timestampMs", "location", "cls", "message"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LongEntry.class, "timestampMs;location;cls;message", "timestampMs", "location", "cls", "message"}, this, var0);
        }

        public long timestampMs() {
            return this.timestampMs;
        }

        public String location() {
            return this.location;
        }

        public Class<? extends Throwable> cls() {
            return this.cls;
        }

        public String message() {
            return this.message;
        }
    }

    static final class ShortEntry
    extends Record {
        final String location;
        final Class<? extends Throwable> cls;

        ShortEntry(String var0, Class<? extends Throwable> var1) {
            this.location = var0;
            this.cls = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShortEntry.class, "location;cls", "location", "cls"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShortEntry.class, "location;cls", "location", "cls"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShortEntry.class, "location;cls", "location", "cls"}, this, var0);
        }

        public String location() {
            return this.location;
        }

        public Class<? extends Throwable> cls() {
            return this.cls;
        }
    }
}

