/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec2;

public class WorldBorderCommand {
    private static final SimpleCommandExceptionType ERROR_SAME_CENTER = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.center.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_SIZE = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.nochange"));
    private static final SimpleCommandExceptionType ERROR_TOO_SMALL = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.small"));
    private static final SimpleCommandExceptionType ERROR_TOO_BIG = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.big", 5.9999968E7));
    private static final SimpleCommandExceptionType ERROR_TOO_FAR_OUT = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.set.failed.far", 2.9999984E7));
    private static final SimpleCommandExceptionType ERROR_SAME_WARNING_TIME = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.warning.time.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_WARNING_DISTANCE = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.warning.distance.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_DAMAGE_BUFFER = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.damage.buffer.failed"));
    private static final SimpleCommandExceptionType ERROR_SAME_DAMAGE_AMOUNT = new SimpleCommandExceptionType((Message)Component.translatable("commands.worldborder.damage.amount.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("worldborder").requires(Commands.hasPermission(2))).then(Commands.literal("add").then(((RequiredArgumentBuilder)Commands.argument("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(var0 -> WorldBorderCommand.setSize((CommandSourceStack)var0.getSource(), ((CommandSourceStack)var0.getSource()).getLevel().getWorldBorder().getSize() + DoubleArgumentType.getDouble((CommandContext)var0, (String)"distance"), 0L))).then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(var0 -> WorldBorderCommand.setSize((CommandSourceStack)var0.getSource(), ((CommandSourceStack)var0.getSource()).getLevel().getWorldBorder().getSize() + DoubleArgumentType.getDouble((CommandContext)var0, (String)"distance"), ((CommandSourceStack)var0.getSource()).getLevel().getWorldBorder().getLerpTime() + (long)IntegerArgumentType.getInteger((CommandContext)var0, (String)"time") * 1000L)))))).then(Commands.literal("set").then(((RequiredArgumentBuilder)Commands.argument("distance", DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(var0 -> WorldBorderCommand.setSize((CommandSourceStack)var0.getSource(), DoubleArgumentType.getDouble((CommandContext)var0, (String)"distance"), 0L))).then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(var0 -> WorldBorderCommand.setSize((CommandSourceStack)var0.getSource(), DoubleArgumentType.getDouble((CommandContext)var0, (String)"distance"), (long)IntegerArgumentType.getInteger((CommandContext)var0, (String)"time") * 1000L)))))).then(Commands.literal("center").then(Commands.argument("pos", Vec2Argument.vec2()).executes(var0 -> WorldBorderCommand.setCenter((CommandSourceStack)var0.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)var0, "pos")))))).then(((LiteralArgumentBuilder)Commands.literal("damage").then(Commands.literal("amount").then(Commands.argument("damagePerBlock", FloatArgumentType.floatArg((float)0.0f)).executes(var0 -> WorldBorderCommand.setDamageAmount((CommandSourceStack)var0.getSource(), FloatArgumentType.getFloat((CommandContext)var0, (String)"damagePerBlock")))))).then(Commands.literal("buffer").then(Commands.argument("distance", FloatArgumentType.floatArg((float)0.0f)).executes(var0 -> WorldBorderCommand.setDamageBuffer((CommandSourceStack)var0.getSource(), FloatArgumentType.getFloat((CommandContext)var0, (String)"distance"))))))).then(Commands.literal("get").executes(var0 -> WorldBorderCommand.getSize((CommandSourceStack)var0.getSource())))).then(((LiteralArgumentBuilder)Commands.literal("warning").then(Commands.literal("distance").then(Commands.argument("distance", IntegerArgumentType.integer((int)0)).executes(var0 -> WorldBorderCommand.setWarningDistance((CommandSourceStack)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"distance")))))).then(Commands.literal("time").then(Commands.argument("time", IntegerArgumentType.integer((int)0)).executes(var0 -> WorldBorderCommand.setWarningTime((CommandSourceStack)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"time"))))))));
    }

    private static int setDamageBuffer(CommandSourceStack var0, float var1) throws CommandSyntaxException {
        WorldBorder var2 = var0.getLevel().getWorldBorder();
        if (var2.getSafeZone() == (double)var1) {
            throw ERROR_SAME_DAMAGE_BUFFER.create();
        }
        var2.setSafeZone(var1);
        var0.sendSuccess(() -> Component.translatable("commands.worldborder.damage.buffer.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(var1))), true);
        return (int)var1;
    }

    private static int setDamageAmount(CommandSourceStack var0, float var1) throws CommandSyntaxException {
        WorldBorder var2 = var0.getLevel().getWorldBorder();
        if (var2.getDamagePerBlock() == (double)var1) {
            throw ERROR_SAME_DAMAGE_AMOUNT.create();
        }
        var2.setDamagePerBlock(var1);
        var0.sendSuccess(() -> Component.translatable("commands.worldborder.damage.amount.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(var1))), true);
        return (int)var1;
    }

    private static int setWarningTime(CommandSourceStack var0, int var1) throws CommandSyntaxException {
        WorldBorder var2 = var0.getLevel().getWorldBorder();
        if (var2.getWarningTime() == var1) {
            throw ERROR_SAME_WARNING_TIME.create();
        }
        var2.setWarningTime(var1);
        var0.sendSuccess(() -> Component.translatable("commands.worldborder.warning.time.success", var1), true);
        return var1;
    }

    private static int setWarningDistance(CommandSourceStack var0, int var1) throws CommandSyntaxException {
        WorldBorder var2 = var0.getLevel().getWorldBorder();
        if (var2.getWarningBlocks() == var1) {
            throw ERROR_SAME_WARNING_DISTANCE.create();
        }
        var2.setWarningBlocks(var1);
        var0.sendSuccess(() -> Component.translatable("commands.worldborder.warning.distance.success", var1), true);
        return var1;
    }

    private static int getSize(CommandSourceStack var0) {
        double var1 = var0.getLevel().getWorldBorder().getSize();
        var0.sendSuccess(() -> Component.translatable("commands.worldborder.get", String.format(Locale.ROOT, "%.0f", var1)), false);
        return Mth.floor(var1 + 0.5);
    }

    private static int setCenter(CommandSourceStack var0, Vec2 var1) throws CommandSyntaxException {
        WorldBorder var2 = var0.getLevel().getWorldBorder();
        if (var2.getCenterX() == (double)var1.x && var2.getCenterZ() == (double)var1.y) {
            throw ERROR_SAME_CENTER.create();
        }
        if ((double)Math.abs(var1.x) > 2.9999984E7 || (double)Math.abs(var1.y) > 2.9999984E7) {
            throw ERROR_TOO_FAR_OUT.create();
        }
        var2.setCenter(var1.x, var1.y);
        var0.sendSuccess(() -> Component.translatable("commands.worldborder.center.success", String.format(Locale.ROOT, "%.2f", Float.valueOf(var0.x)), String.format(Locale.ROOT, "%.2f", Float.valueOf(var0.y))), true);
        return 0;
    }

    private static int setSize(CommandSourceStack var0, double var1, long var3) throws CommandSyntaxException {
        WorldBorder var5 = var0.getLevel().getWorldBorder();
        double var6 = var5.getSize();
        if (var6 == var1) {
            throw ERROR_SAME_SIZE.create();
        }
        if (var1 < 1.0) {
            throw ERROR_TOO_SMALL.create();
        }
        if (var1 > 5.9999968E7) {
            throw ERROR_TOO_BIG.create();
        }
        if (var3 > 0L) {
            var5.lerpSizeBetween(var6, var1, var3);
            if (var1 > var6) {
                var0.sendSuccess(() -> Component.translatable("commands.worldborder.set.grow", String.format(Locale.ROOT, "%.1f", var1), Long.toString(var3 / 1000L)), true);
            } else {
                var0.sendSuccess(() -> Component.translatable("commands.worldborder.set.shrink", String.format(Locale.ROOT, "%.1f", var1), Long.toString(var3 / 1000L)), true);
            }
        } else {
            var5.setSize(var1);
            var0.sendSuccess(() -> Component.translatable("commands.worldborder.set.immediate", String.format(Locale.ROOT, "%.1f", var1)), true);
        }
        return (int)(var1 - var6);
    }
}

