/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftAllowListService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftAllowListServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftBanListService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftBanListServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftExecutorService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftExecutorServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftGameRuleService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftGameRuleServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftOperatorListService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftOperatorListServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftPlayerListService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftPlayerListServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftServerSettingsService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftServerSettingsServiceImpl;
import net.minecraft.server.jsonrpc.internalapi.MinecraftServerStateService;
import net.minecraft.server.jsonrpc.internalapi.MinecraftServerStateServiceImpl;
import net.minecraft.server.notifications.NotificationManager;

public class MinecraftApi {
    private final NotificationManager notificationManager;
    private final MinecraftAllowListService allowListService;
    private final MinecraftBanListService banListService;
    private final MinecraftPlayerListService minecraftPlayerListService;
    private final MinecraftGameRuleService gameRuleService;
    private final MinecraftOperatorListService minecraftOperatorListService;
    private final MinecraftServerSettingsService minecraftServerSettingsService;
    private final MinecraftServerStateService minecraftServerStateService;
    private final MinecraftExecutorService executorService;

    public MinecraftApi(NotificationManager var0, MinecraftAllowListService var1, MinecraftBanListService var2, MinecraftPlayerListService var3, MinecraftGameRuleService var4, MinecraftOperatorListService var5, MinecraftServerSettingsService var6, MinecraftServerStateService var7, MinecraftExecutorService var8) {
        this.notificationManager = var0;
        this.allowListService = var1;
        this.banListService = var2;
        this.minecraftPlayerListService = var3;
        this.gameRuleService = var4;
        this.minecraftOperatorListService = var5;
        this.minecraftServerSettingsService = var6;
        this.minecraftServerStateService = var7;
        this.executorService = var8;
    }

    public <V> CompletableFuture<V> submit(Supplier<V> var0) {
        return this.executorService.submit(var0);
    }

    public CompletableFuture<Void> submit(Runnable var0) {
        return this.executorService.submit(var0);
    }

    public MinecraftAllowListService allowListService() {
        return this.allowListService;
    }

    public MinecraftBanListService banListService() {
        return this.banListService;
    }

    public MinecraftPlayerListService playerListService() {
        return this.minecraftPlayerListService;
    }

    public MinecraftGameRuleService gameRuleService() {
        return this.gameRuleService;
    }

    public MinecraftOperatorListService operatorListService() {
        return this.minecraftOperatorListService;
    }

    public MinecraftServerSettingsService serverSettingsService() {
        return this.minecraftServerSettingsService;
    }

    public MinecraftServerStateService serverStateService() {
        return this.minecraftServerStateService;
    }

    public NotificationManager notificationManager() {
        return this.notificationManager;
    }

    public static MinecraftApi of(DedicatedServer var0) {
        JsonRpcLogger var1 = new JsonRpcLogger();
        MinecraftAllowListServiceImpl var2 = new MinecraftAllowListServiceImpl(var0, var1);
        MinecraftBanListServiceImpl var3 = new MinecraftBanListServiceImpl(var0, var1);
        MinecraftPlayerListServiceImpl var4 = new MinecraftPlayerListServiceImpl(var0, var1);
        MinecraftGameRuleServiceImpl var5 = new MinecraftGameRuleServiceImpl(var0, var1);
        MinecraftOperatorListServiceImpl var6 = new MinecraftOperatorListServiceImpl(var0, var1);
        MinecraftServerSettingsServiceImpl var7 = new MinecraftServerSettingsServiceImpl(var0, var1);
        MinecraftServerStateServiceImpl var8 = new MinecraftServerStateServiceImpl(var0, var1);
        MinecraftExecutorServiceImpl var9 = new MinecraftExecutorServiceImpl(var0);
        return new MinecraftApi(var0.notificationManager(), var2, var3, var4, var5, var6, var7, var8, var9);
    }
}

