/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserWhiteListEntry;

public class AllowlistService {
    public static List<PlayerDto> get(MinecraftApi var02) {
        return var02.allowListService().getEntries().stream().filter(var0 -> var0.getUser() != null).map(var0 -> PlayerDto.from((NameAndId)var0.getUser())).toList();
    }

    public static List<PlayerDto> add(MinecraftApi var0, List<PlayerDto> var12, ClientInfo var22) {
        List<CompletableFuture> var3 = var12.stream().map(var1 -> var0.playerListService().getUser(var1.id(), var1.name())).toList();
        for (Optional var5 : Util.sequence(var3).join()) {
            var5.ifPresent(var2 -> var0.allowListService().add(new UserWhiteListEntry((NameAndId)var2), var22));
        }
        return AllowlistService.get(var0);
    }

    public static List<PlayerDto> clear(MinecraftApi var0, ClientInfo var1) {
        var0.allowListService().clear(var1);
        return AllowlistService.get(var0);
    }

    public static List<PlayerDto> remove(MinecraftApi var0, List<PlayerDto> var12, ClientInfo var22) {
        List<CompletableFuture> var3 = var12.stream().map(var1 -> var0.playerListService().getUser(var1.id(), var1.name())).toList();
        for (Optional var5 : Util.sequence(var3).join()) {
            var5.ifPresent(var2 -> var0.allowListService().remove((NameAndId)var2, var22));
        }
        var0.allowListService().kickUnlistedPlayers(var22);
        return AllowlistService.get(var0);
    }

    public static List<PlayerDto> set(MinecraftApi var0, List<PlayerDto> var12, ClientInfo var22) {
        List<CompletableFuture> var3 = var12.stream().map(var1 -> var0.playerListService().getUser(var1.id(), var1.name())).toList();
        Set var4 = Util.sequence(var3).join().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        Set var5 = var0.allowListService().getEntries().stream().map(StoredUserEntry::getUser).collect(Collectors.toSet());
        var5.stream().filter(var1 -> !var4.contains(var1)).forEach(var2 -> var0.allowListService().remove((NameAndId)var2, var22));
        var4.stream().filter(var1 -> !var5.contains(var1)).forEach(var2 -> var0.allowListService().add(new UserWhiteListEntry((NameAndId)var2), var22));
        var0.allowListService().kickUnlistedPlayers(var22);
        return AllowlistService.get(var0);
    }
}

