/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.GameRules;

public class GameRulesService {
    public static List<TypedRule> get(MinecraftApi var0) {
        List<GameRules.Key> var1 = var0.gameRuleService().getAvailableGameRules().map(Map.Entry::getKey).toList();
        ArrayList<TypedRule> var2 = new ArrayList<TypedRule>();
        for (GameRules.Key var4 : var1) {
            Object var5 = var0.gameRuleService().getRule(var4);
            var2.add(GameRulesService.getTypedRule(var0, var4.getId(), var5));
        }
        return var2;
    }

    public static TypedRule getTypedRule(MinecraftApi var0, String var1, GameRules.Value<?> var2) {
        return var0.gameRuleService().getTypedRule(var1, var2);
    }

    public static TypedRule update(MinecraftApi var0, UntypedRule var1, ClientInfo var2) {
        return var0.gameRuleService().updateGameRule(var1, var2);
    }

    public record TypedRule(String key, String value, RuleType type) {
        public static final MapCodec<TypedRule> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("key").forGetter(TypedRule::key), (App)Codec.STRING.fieldOf("value").forGetter(TypedRule::value), (App)StringRepresentable.fromEnum(RuleType::values).fieldOf("type").forGetter(TypedRule::type)).apply((Applicative)var0, TypedRule::new));
    }

    public record UntypedRule(String key, String value) {
        public static final MapCodec<UntypedRule> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("key").forGetter(UntypedRule::key), (App)Codec.STRING.fieldOf("value").forGetter(UntypedRule::value)).apply((Applicative)var0, UntypedRule::new));
    }

    public static enum RuleType implements StringRepresentable
    {
        INT("integer"),
        BOOL("boolean");

        private final String name;

        private RuleType(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }
    }
}

