/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network.config;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.slf4j.Logger;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public class PrepareSpawnTask
implements ConfigurationTask {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type("prepare_spawn");
    public static final int PREPARE_CHUNK_RADIUS = 3;
    final MinecraftServer server;
    final ServerPlayer e;
    final LevelLoadListener loadListener;
    @Nullable
    private State state;

    public PrepareSpawnTask(MinecraftServer minecraftserver, ServerPlayer nameandid) {
        this.server = minecraftserver;
        this.e = nameandid;
        this.loadListener = minecraftserver.getLevelLoadListener();
    }

    @Override
    public void start(Consumer<Packet<?>> consumer) {
        try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(LOGGER);){
            Optional<ValueInput> optional = this.server.getPlayerList().loadPlayerData(this.e).map(nbttagcompound -> TagValueInput.create((ProblemReporter)problemreporter_j, (HolderLookup.Provider)this.server.registryAccess(), nbttagcompound));
            ServerPlayer.SavedPosition entityplayer_c = optional.flatMap(valueinput -> valueinput.read(ServerPlayer.SavedPosition.MAP_CODEC)).orElse(ServerPlayer.SavedPosition.EMPTY);
            LevelData.RespawnData worlddata_a = this.e.level().getRespawnData();
            Optional<ResourceKey<Level>> optional1 = entityplayer_c.dimension();
            MinecraftServer minecraftserver = this.server;
            Objects.requireNonNull(this.server);
            ServerLevel worldserver = optional1.map(minecraftserver::getLevel).orElseGet(() -> {
                ServerLevel worldserver1 = this.server.getLevel(worlddata_a.dimension());
                return worldserver1 != null ? worldserver1 : this.server.overworld();
            });
            CompletableFuture completablefuture = entityplayer_c.position().map(CompletableFuture::completedFuture).orElseGet(() -> PlayerSpawnFinder.findSpawn(worldserver, worlddata_a.pos()));
            Vec2 vec2f = entityplayer_c.rotation().orElse(new Vec2(worlddata_a.yaw(), worlddata_a.pitch()));
            this.state = new Preparing(worldserver, completablefuture, vec2f);
        }
    }

    @Override
    public boolean tick() {
        boolean flag;
        State preparespawntask_c = this.state;
        boolean b0 = false;
        if (preparespawntask_c instanceof Preparing) {
            Preparing preparespawntask_a = (Preparing)preparespawntask_c;
            Ready preparespawntask_b = preparespawntask_a.tick();
            if (preparespawntask_b != null) {
                this.state = preparespawntask_b;
                flag = true;
            } else {
                flag = false;
            }
        } else if (preparespawntask_c instanceof Ready) {
            Ready preparespawntask_b1 = (Ready)preparespawntask_c;
            flag = true;
        } else {
            flag = false;
        }
        return flag;
    }

    public ServerPlayer spawnPlayer(Connection networkmanager, CommonListenerCookie commonlistenercookie) {
        State preparespawntask_c = this.state;
        if (preparespawntask_c instanceof Ready) {
            Ready preparespawntask_b = (Ready)preparespawntask_c;
            return preparespawntask_b.spawn(networkmanager, commonlistenercookie);
        }
        throw new IllegalStateException("Player spawn was not ready");
    }

    public void keepAlive() {
        State preparespawntask_c = this.state;
        if (preparespawntask_c instanceof Ready) {
            Ready preparespawntask_b = (Ready)preparespawntask_c;
            preparespawntask_b.keepAlive();
        }
    }

    public void close() {
        State preparespawntask_c = this.state;
        if (preparespawntask_c instanceof Preparing) {
            Preparing preparespawntask_a = (Preparing)preparespawntask_c;
            preparespawntask_a.cancel();
        }
        this.state = null;
    }

    @Override
    public ConfigurationTask.Type type() {
        return TYPE;
    }

    private final class Preparing
    implements State {
        private final ServerLevel spawnLevel;
        private final CompletableFuture<Vec3> spawnPosition;
        private final Vec2 spawnAngle;
        @Nullable
        private CompletableFuture<?> chunkLoadFuture;
        private final ChunkLoadCounter chunkLoadCounter = new ChunkLoadCounter();

        Preparing(ServerLevel worldserver, CompletableFuture completablefuture, Vec2 vec2f) {
            this.spawnLevel = worldserver;
            this.spawnPosition = completablefuture;
            this.spawnAngle = vec2f;
        }

        public void cancel() {
            this.spawnPosition.cancel(false);
        }

        @Nullable
        public Ready tick() {
            if (!this.spawnPosition.isDone()) {
                return null;
            }
            Vec3 vec3d = this.spawnPosition.join();
            if (this.chunkLoadFuture == null) {
                ChunkPos chunkcoordintpair = new ChunkPos(BlockPos.containing(vec3d));
                this.chunkLoadCounter.track(this.spawnLevel, () -> {
                    this.chunkLoadFuture = this.spawnLevel.getChunkSource().addTicketAndLoadWithRadius(TicketType.PLAYER_SPAWN, chunkcoordintpair, 3);
                });
                PrepareSpawnTask.this.loadListener.start(LevelLoadListener.Stage.LOAD_PLAYER_CHUNKS, this.chunkLoadCounter.totalChunks());
                PrepareSpawnTask.this.loadListener.updateFocus(this.spawnLevel.dimension(), chunkcoordintpair);
            }
            PrepareSpawnTask.this.loadListener.update(LevelLoadListener.Stage.LOAD_PLAYER_CHUNKS, this.chunkLoadCounter.readyChunks(), this.chunkLoadCounter.totalChunks());
            if (!this.chunkLoadFuture.isDone()) {
                return null;
            }
            PrepareSpawnTask.this.loadListener.finish(LevelLoadListener.Stage.LOAD_PLAYER_CHUNKS);
            PrepareSpawnTask prepareSpawnTask = PrepareSpawnTask.this;
            Objects.requireNonNull(prepareSpawnTask);
            return prepareSpawnTask.new Ready(this.spawnLevel, vec3d, this.spawnAngle);
        }
    }

    private static sealed interface State
    permits Preparing, Ready {
    }

    private final class Ready
    implements State {
        private final ServerLevel spawnLevel;
        private final Vec3 spawnPosition;
        private final Vec2 spawnAngle;

        Ready(ServerLevel worldserver, Vec3 vec3d, Vec2 vec2f) {
            this.spawnLevel = worldserver;
            this.spawnPosition = vec3d;
            this.spawnAngle = vec2f;
        }

        public void keepAlive() {
            this.spawnLevel.getChunkSource().addTicketWithRadius(TicketType.PLAYER_SPAWN, new ChunkPos(BlockPos.containing(this.spawnPosition)), 3);
        }

        public ServerPlayer spawn(Connection networkmanager, CommonListenerCookie commonlistenercookie) {
            ChunkPos chunkcoordintpair = new ChunkPos(BlockPos.containing(this.spawnPosition));
            this.spawnLevel.waitForEntities(chunkcoordintpair, 3);
            ServerPlayer entityplayer = PrepareSpawnTask.this.e;
            try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(entityplayer.problemPath(), LOGGER);){
                Optional<ValueInput> optional = PrepareSpawnTask.this.server.getPlayerList().loadPlayerData(PrepareSpawnTask.this.e).map(nbttagcompound -> TagValueInput.create((ProblemReporter)problemreporter_j, (HolderLookup.Provider)PrepareSpawnTask.this.server.registryAccess(), nbttagcompound));
                Objects.requireNonNull(entityplayer);
                optional.ifPresent(entityplayer::load);
                entityplayer.snapTo(this.spawnPosition, this.spawnAngle.x, this.spawnAngle.y);
                CraftPlayer spawnPlayer = entityplayer.getBukkitEntity();
                PlayerSpawnLocationEvent ev = new PlayerSpawnLocationEvent((Player)spawnPlayer, spawnPlayer.getLocation());
                spawnPlayer.getServer().getPluginManager().callEvent((Event)ev);
                Location loc = ev.getSpawnLocation();
                ServerLevel spawnWorld = ((CraftWorld)loc.getWorld()).getHandle();
                entityplayer.spawnIn(spawnWorld, true);
                entityplayer.gameMode.setLevel(entityplayer.level());
                entityplayer.absSnapTo(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
                PrepareSpawnTask.this.server.getPlayerList().placeNewPlayer(networkmanager, entityplayer, commonlistenercookie);
                optional.ifPresent(valueinput -> {
                    entityplayer.loadAndSpawnEnderPearls((ValueInput)valueinput);
                    entityplayer.loadAndSpawnParentVehicle((ValueInput)valueinput);
                });
                ServerPlayer serverPlayer = entityplayer;
                return serverPlayer;
            }
        }
    }
}

