/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ProfiledReloadInstance;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;

public class SimpleReloadInstance<S>
implements ReloadInstance {
    private static final int PREPARATION_PROGRESS_WEIGHT = 2;
    private static final int EXTRA_RELOAD_PROGRESS_WEIGHT = 2;
    private static final int LISTENER_PROGRESS_WEIGHT = 1;
    final CompletableFuture<Unit> allPreparations = new CompletableFuture();
    @Nullable
    private CompletableFuture<List<S>> allDone;
    final Set<PreparableReloadListener> preparingListeners;
    private final int listenerCount;
    private final AtomicInteger startedTasks = new AtomicInteger();
    private final AtomicInteger finishedTasks = new AtomicInteger();
    private final AtomicInteger startedReloads = new AtomicInteger();
    private final AtomicInteger finishedReloads = new AtomicInteger();

    public static ReloadInstance of(ResourceManager var0, List<PreparableReloadListener> var1, Executor var2, Executor var3, CompletableFuture<Unit> var4) {
        SimpleReloadInstance<Void> var5 = new SimpleReloadInstance<Void>(var1);
        var5.startTasks(var2, var3, var0, var1, StateFactory.SIMPLE, var4);
        return var5;
    }

    protected SimpleReloadInstance(List<PreparableReloadListener> var0) {
        this.listenerCount = var0.size();
        this.preparingListeners = new HashSet<PreparableReloadListener>(var0);
    }

    protected void startTasks(Executor var0, Executor var1, ResourceManager var2, List<PreparableReloadListener> var3, StateFactory<S> var4, CompletableFuture<?> var5) {
        this.allDone = this.prepareTasks(var0, var1, var2, var3, var4, var5);
    }

    protected CompletableFuture<List<S>> prepareTasks(Executor var0, Executor var12, ResourceManager var2, List<PreparableReloadListener> var3, StateFactory<S> var4, CompletableFuture<?> var5) {
        Executor var6 = var1 -> {
            this.startedTasks.incrementAndGet();
            var0.execute(() -> {
                var1.run();
                this.finishedTasks.incrementAndGet();
            });
        };
        Executor var7 = var1 -> {
            this.startedReloads.incrementAndGet();
            var12.execute(() -> {
                var1.run();
                this.finishedReloads.incrementAndGet();
            });
        };
        this.startedTasks.incrementAndGet();
        var5.thenRun(this.finishedTasks::incrementAndGet);
        PreparableReloadListener.SharedState var8 = new PreparableReloadListener.SharedState(var2);
        var3.forEach(var1 -> var1.prepareSharedState(var8));
        CompletableFuture<Object> var9 = var5;
        ArrayList<CompletableFuture<S>> var10 = new ArrayList<CompletableFuture<S>>();
        for (PreparableReloadListener var122 : var3) {
            PreparableReloadListener.PreparationBarrier var13 = this.createBarrierForListener(var122, var9, var12);
            CompletableFuture<S> var14 = var4.create(var8, var13, var122, var6, var7);
            var10.add(var14);
            var9 = var14;
        }
        return Util.sequenceFailFast(var10);
    }

    private PreparableReloadListener.PreparationBarrier createBarrierForListener(final PreparableReloadListener var0, final CompletableFuture<?> var1, final Executor var2) {
        return new PreparableReloadListener.PreparationBarrier(){

            @Override
            public <T> CompletableFuture<T> wait(T var02) {
                var2.execute(() -> {
                    SimpleReloadInstance.this.preparingListeners.remove(var0);
                    if (SimpleReloadInstance.this.preparingListeners.isEmpty()) {
                        SimpleReloadInstance.this.allPreparations.complete(Unit.INSTANCE);
                    }
                });
                return SimpleReloadInstance.this.allPreparations.thenCombine((CompletionStage)var1, (var1, var2) -> var02);
            }
        };
    }

    @Override
    public CompletableFuture<?> done() {
        return Objects.requireNonNull(this.allDone, "not started");
    }

    @Override
    public float getActualProgress() {
        int var0 = this.listenerCount - this.preparingListeners.size();
        float var1 = SimpleReloadInstance.weightProgress(this.finishedTasks.get(), this.finishedReloads.get(), var0);
        float var2 = SimpleReloadInstance.weightProgress(this.startedTasks.get(), this.startedReloads.get(), this.listenerCount);
        return var1 / var2;
    }

    private static int weightProgress(int var0, int var1, int var2) {
        return var0 * 2 + var1 * 2 + var2 * 1;
    }

    public static ReloadInstance create(ResourceManager var0, List<PreparableReloadListener> var1, Executor var2, Executor var3, CompletableFuture<Unit> var4, boolean var5) {
        if (var5) {
            return ProfiledReloadInstance.of(var0, var1, var2, var3, var4);
        }
        return SimpleReloadInstance.of(var0, var1, var2, var3, var4);
    }

    @FunctionalInterface
    protected static interface StateFactory<S> {
        public static final StateFactory<Void> SIMPLE = (var0, var1, var2, var3, var4) -> var2.reload(var0, var3, var1, var4);

        public CompletableFuture<S> create(PreparableReloadListener.SharedState var1, PreparableReloadListener.PreparationBarrier var2, PreparableReloadListener var3, Executor var4, Executor var5);
    }
}

