/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHeldSlotPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.command.ColouredConsoleSender;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class PlayerList {
    public static final File USERBANLIST_FILE = new File("banned-players.json");
    public static final File IPBANLIST_FILE = new File("banned-ips.json");
    public static final File OPLIST_FILE = new File("ops.json");
    public static final File WHITELIST_FILE = new File("whitelist.json");
    public static final Component CHAT_FILTERED_FULL = Component.translatable("chat.filtered_full");
    public static final Component DUPLICATE_LOGIN_DISCONNECT_MESSAGE = Component.translatable("multiplayer.disconnect.duplicate_login");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SEND_PLAYER_INFO_INTERVAL = 600;
    private static final SimpleDateFormat BAN_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer server;
    public final List<ServerPlayer> players = new CopyOnWriteArrayList<ServerPlayer>();
    private final Map<UUID, ServerPlayer> playersByUUID = Maps.newHashMap();
    private final UserBanList bans;
    private final IpBanList ipBans;
    private final ServerOpList ops;
    private final UserWhiteList whitelist;
    public final PlayerDataStorage playerIo;
    private final LayeredRegistryAccess<RegistryLayer> registries;
    private int viewDistance;
    private int simulationDistance;
    private boolean allowCommandsForAllPlayers;
    private int sendAllPlayerInfoIn;
    private CraftServer cserver;
    private final Map<String, ServerPlayer> playersByName = new HashMap<String, ServerPlayer>();

    public PlayerList(MinecraftServer minecraftserver, LayeredRegistryAccess<RegistryLayer> layeredregistryaccess, PlayerDataStorage worldnbtstorage, NotificationService notificationservice) {
        this.cserver = minecraftserver.server = new CraftServer((DedicatedServer)minecraftserver, this);
        minecraftserver.console = ColouredConsoleSender.getInstance();
        this.server = minecraftserver;
        this.registries = layeredregistryaccess;
        this.playerIo = worldnbtstorage;
        this.whitelist = new UserWhiteList(WHITELIST_FILE, notificationservice);
        this.ops = new ServerOpList(OPLIST_FILE, notificationservice);
        this.bans = new UserBanList(USERBANLIST_FILE, notificationservice);
        this.ipBans = new IpBanList(IPBANLIST_FILE, notificationservice);
    }

    public void placeNewPlayer(Connection networkmanager, ServerPlayer entityplayer, CommonListenerCookie commonlistenercookie) {
        NameAndId nameandid = entityplayer.nameAndId();
        UserNameToIdResolver usernametoidresolver = this.server.services().nameToIdCache();
        Optional<NameAndId> optional = usernametoidresolver.get(nameandid.id());
        String s = optional.map(NameAndId::name).orElse(nameandid.name());
        String lastKnownName = entityplayer.getBukkitEntity().getLastKnownName();
        if (lastKnownName != null) {
            s = lastKnownName;
        }
        usernametoidresolver.add(nameandid);
        ServerLevel worldserver = entityplayer.level();
        String s1 = networkmanager.getLoggableAddress(this.server.logIPs());
        LevelData worlddata = worldserver.getLevelData();
        ServerGamePacketListenerImpl playerconnection = new ServerGamePacketListenerImpl(this.server, networkmanager, entityplayer, commonlistenercookie);
        networkmanager.setupInboundProtocol(GameProtocols.SERVERBOUND_TEMPLATE.bind(RegistryFriendlyByteBuf.decorator(this.server.registryAccess()), playerconnection), playerconnection);
        GameRules gamerules = worldserver.getGameRules();
        boolean flag = gamerules.getBoolean(GameRules.RULE_DO_IMMEDIATE_RESPAWN);
        boolean flag1 = gamerules.getBoolean(GameRules.RULE_REDUCEDDEBUGINFO);
        boolean flag2 = gamerules.getBoolean(GameRules.RULE_LIMITED_CRAFTING);
        playerconnection.send(new ClientboundLoginPacket(entityplayer.getId(), worlddata.isHardcore(), this.server.levelKeys(), this.getMaxPlayers(), worldserver.spigotConfig.viewDistance, worldserver.spigotConfig.simulationDistance, flag1, !flag, flag2, entityplayer.createCommonSpawnInfo(worldserver), this.server.enforceSecureProfile()));
        entityplayer.getBukkitEntity().sendSupportedChannels();
        playerconnection.send(new ClientboundChangeDifficultyPacket(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
        playerconnection.send(new ClientboundPlayerAbilitiesPacket(entityplayer.getAbilities()));
        playerconnection.send(new ClientboundSetHeldSlotPacket(entityplayer.getInventory().getSelectedSlot()));
        RecipeManager craftingmanager = this.server.getRecipeManager();
        playerconnection.send(new ClientboundUpdateRecipesPacket(craftingmanager.getSynchronizedItemProperties(), craftingmanager.getSynchronizedStonecutterRecipes()));
        this.sendPlayerPermissionLevel(entityplayer);
        entityplayer.getStats().markAllDirty();
        entityplayer.getRecipeBook().sendInitialRecipeBook(entityplayer);
        this.updateEntireScoreboard(worldserver.getScoreboard(), entityplayer);
        this.server.invalidateStatus();
        MutableComponent ichatmutablecomponent = entityplayer.getGameProfile().name().equalsIgnoreCase(s) ? Component.translatable("multiplayer.player.joined", entityplayer.getDisplayName()) : Component.translatable("multiplayer.player.joined.renamed", entityplayer.getDisplayName(), s);
        ichatmutablecomponent.withStyle(ChatFormatting.YELLOW);
        String joinMessage = CraftChatMessage.fromComponent(ichatmutablecomponent);
        playerconnection.teleport(entityplayer.getX(), entityplayer.getY(), entityplayer.getZ(), entityplayer.getYRot(), entityplayer.getXRot());
        ServerStatus serverping = this.server.getStatus();
        if (serverping != null && !commonlistenercookie.transferred()) {
            entityplayer.sendServerStatus(serverping);
        }
        this.players.add(entityplayer);
        this.playersByName.put(entityplayer.getScoreboardName().toLowerCase(Locale.ROOT), entityplayer);
        this.playersByUUID.put(entityplayer.getUUID(), entityplayer);
        CraftPlayer bukkitPlayer = entityplayer.getBukkitEntity();
        entityplayer.containerMenu.transferTo(entityplayer.containerMenu, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((org.bukkit.entity.Player)bukkitPlayer, joinMessage);
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!entityplayer.connection.isAcceptingMessages()) {
            return;
        }
        joinMessage = playerJoinEvent.getJoinMessage();
        if (joinMessage != null && joinMessage.length() > 0) {
            for (Component line : CraftChatMessage.fromString(joinMessage)) {
                this.server.getPlayerList().broadcastSystemMessage(line, false);
            }
        }
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(entityplayer));
        for (int i = 0; i < this.players.size(); ++i) {
            ServerPlayer entityplayer1 = this.players.get(i);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                entityplayer1.connection.send(packet);
            }
            if (!bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
            entityplayer.connection.send(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(entityplayer1)));
        }
        entityplayer.sentListPacket = true;
        entityplayer.refreshEntityData(entityplayer);
        this.sendLevelInfo(entityplayer, worldserver);
        if (entityplayer.level() == worldserver && !worldserver.players().contains(entityplayer)) {
            worldserver.addNewPlayer(entityplayer);
            this.server.getCustomBossEvents().onPlayerConnect(entityplayer);
        }
        worldserver = entityplayer.level();
        this.sendActivePlayerEffects(entityplayer);
        entityplayer.initInventoryMenu();
        this.server.notificationManager().playerJoined(entityplayer);
        LOGGER.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{entityplayer.getPlainTextName(), s1, entityplayer.getId(), worldserver.J.getLevelName(), entityplayer.getX(), entityplayer.getY(), entityplayer.getZ()});
    }

    public void updateEntireScoreboard(ServerScoreboard scoreboardserver, ServerPlayer entityplayer) {
        HashSet set = Sets.newHashSet();
        for (PlayerTeam scoreboardteam : scoreboardserver.getPlayerTeams()) {
            entityplayer.connection.send(ClientboundSetPlayerTeamPacket.createAddOrModifyPacket(scoreboardteam, true));
        }
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            Objective scoreboardobjective = scoreboardserver.getDisplayObjective(displayslot);
            if (scoreboardobjective == null || set.contains(scoreboardobjective)) continue;
            for (Packet<?> packet : scoreboardserver.getStartTrackingPackets(scoreboardobjective)) {
                entityplayer.connection.send(packet);
            }
            set.add(scoreboardobjective);
        }
    }

    public void addWorldborderListener(final ServerLevel worldserver) {
        worldserver.getWorldBorder().addListener(new BorderChangeListener(){

            @Override
            public void onSetSize(WorldBorder worldborder, double d0) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderSizePacket(worldborder), worldserver.dimension());
            }

            @Override
            public void onLerpSize(WorldBorder worldborder, double d0, double d1, long i) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderLerpSizePacket(worldborder), worldserver.dimension());
            }

            @Override
            public void onSetCenter(WorldBorder worldborder, double d0, double d1) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderCenterPacket(worldborder), worldserver.dimension());
            }

            @Override
            public void onSetWarningTime(WorldBorder worldborder, int i) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderWarningDelayPacket(worldborder), worldserver.dimension());
            }

            @Override
            public void onSetWarningBlocks(WorldBorder worldborder, int i) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderWarningDistancePacket(worldborder), worldserver.dimension());
            }

            @Override
            public void onSetDamagePerBlock(WorldBorder worldborder, double d0) {
            }

            @Override
            public void onSetSafeZone(WorldBorder worldborder, double d0) {
            }
        });
    }

    public Optional<CompoundTag> loadPlayerData(Player nameandid) {
        CompoundTag nbttagcompound = this.server.getWorldData().getLoadedPlayerTag();
        if (this.server.isSingleplayerOwner(nameandid.nameAndId()) && nbttagcompound != null) {
            LOGGER.debug("loading single player");
            return Optional.of(nbttagcompound);
        }
        return this.playerIo.load(nameandid);
    }

    protected void save(ServerPlayer entityplayer) {
        PlayerAdvancements advancementdataplayer;
        if (!entityplayer.getBukkitEntity().isPersistent()) {
            return;
        }
        this.playerIo.save(entityplayer);
        ServerStatsCounter serverstatisticmanager = entityplayer.getStats();
        if (serverstatisticmanager != null) {
            serverstatisticmanager.save();
        }
        if ((advancementdataplayer = entityplayer.getAdvancements()) != null) {
            advancementdataplayer.save();
        }
    }

    public String remove(ServerPlayer entityplayer) {
        Object entity;
        ServerLevel worldserver = entityplayer.level();
        entityplayer.awardStat(Stats.LEAVE_GAME);
        if (entityplayer.containerMenu != entityplayer.inventoryMenu) {
            entityplayer.closeContainer();
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((org.bukkit.entity.Player)entityplayer.getBukkitEntity(), (String)(entityplayer.kickLeaveMessage != null ? entityplayer.kickLeaveMessage : "\u00a7e" + entityplayer.getScoreboardName() + " left the game"));
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        entityplayer.getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        entityplayer.doTick();
        this.save(entityplayer);
        if (entityplayer.isPassenger() && ((Entity)(entity = entityplayer.getRootVehicle())).hasExactlyOnePlayerPassenger()) {
            LOGGER.debug("Removing player mount");
            entityplayer.stopRiding();
            ((Entity)entity).getPassengersAndSelf().forEach(entity1 -> entity1.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER, EntityRemoveEvent.Cause.PLAYER_QUIT));
        }
        entityplayer.unRide();
        for (ThrownEnderpearl entityenderpearl : entityplayer.getEnderPearls()) {
            entityenderpearl.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER, EntityRemoveEvent.Cause.PLAYER_QUIT);
        }
        worldserver.removePlayerImmediately(entityplayer, Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        entityplayer.getAdvancements().stopListening();
        this.players.remove(entityplayer);
        this.playersByName.remove(entityplayer.getScoreboardName().toLowerCase(Locale.ROOT));
        this.server.getCustomBossEvents().onPlayerDisconnect(entityplayer);
        UUID uuid = entityplayer.getUUID();
        ServerPlayer entityplayer1 = this.playersByUUID.get(uuid);
        if (entityplayer1 == entityplayer) {
            this.playersByUUID.remove(uuid);
            this.server.notificationManager().playerLeft(entityplayer);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(entityplayer.getUUID()));
        for (int i = 0; i < this.players.size(); ++i) {
            ServerPlayer entityplayer2 = this.players.get(i);
            if (entityplayer2.getBukkitEntity().canSee(entityplayer.getBukkitEntity())) {
                entityplayer2.connection.send(packet);
                continue;
            }
            entityplayer2.getBukkitEntity().onEntityRemove(entityplayer);
        }
        this.cserver.getScoreboardManager().removePlayer(entityplayer.getBukkitEntity());
        return playerQuitEvent.getQuitMessage();
    }

    @Nullable
    public ServerPlayer canPlayerLogin(ServerLoginPacketListenerImpl loginlistener, GameProfile gameprofile) {
        NameAndId nameandid = new NameAndId(gameprofile);
        UUID uuid = gameprofile.id();
        Set set = Sets.newIdentityHashSet();
        for (ServerPlayer entityplayer : this.players) {
            if (!entityplayer.getUUID().equals(uuid)) continue;
            set.add(entityplayer);
        }
        for (ServerPlayer entityplayer2 : set) {
            this.save(entityplayer2);
            entityplayer2.connection.disconnect(DUPLICATE_LOGIN_DISCONNECT_MESSAGE);
        }
        SocketAddress socketaddress = loginlistener.connection.getRemoteAddress();
        ServerPlayer entity = new ServerPlayer(this.server, this.server.getLevel(Level.OVERWORLD), gameprofile, ClientInformation.createDefault());
        entity.transferCookieConnection = loginlistener;
        CraftPlayer player = entity.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((org.bukkit.entity.Player)player, loginlistener.connection.hostname, ((InetSocketAddress)socketaddress).getAddress(), ((InetSocketAddress)loginlistener.connection.channel.remoteAddress()).getAddress());
        if (this.bans.isBanned(nameandid)) {
            UserBanListEntry gameprofilebanentry = (UserBanListEntry)this.bans.get(nameandid);
            MutableComponent ichatmutablecomponent = Component.translatable("multiplayer.disconnect.banned.reason", gameprofilebanentry.getReasonMessage());
            if (gameprofilebanentry.getExpires() != null) {
                ichatmutablecomponent.append(Component.translatable("multiplayer.disconnect.banned.expiration", BAN_DATE_FORMAT.format(gameprofilebanentry.getExpires())));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent));
        } else if (!this.isWhiteListed(nameandid)) {
            MutableComponent ichatmutablecomponent = Component.translatable("multiplayer.disconnect.not_whitelisted");
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, SpigotConfig.whitelistMessage);
        } else if (this.ipBans.isBanned(socketaddress)) {
            IpBanListEntry ipbanentry = this.ipBans.get(socketaddress);
            MutableComponent ichatmutablecomponent1 = Component.translatable("multiplayer.disconnect.banned_ip.reason", ipbanentry.getReasonMessage());
            if (ipbanentry.getExpires() != null) {
                ichatmutablecomponent1.append(Component.translatable("multiplayer.disconnect.banned_ip.expiration", BAN_DATE_FORMAT.format(ipbanentry.getExpires())));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent1));
        } else if (this.players.size() >= this.getMaxPlayers() && !this.canBypassPlayerLimit(nameandid)) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, SpigotConfig.serverFullMessage);
        }
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            loginlistener.disconnect(event.getKickMessage());
            return null;
        }
        return entity;
    }

    public boolean disconnectAllPlayersWithProfile(UUID uuid, ServerPlayer player) {
        return player == null;
    }

    public ServerPlayer respawn(ServerPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, flag, entity_removalreason, reason, null);
    }

    public ServerPlayer respawn(ServerPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason, Location location) {
        BlockPos blockposition;
        BlockState iblockdata;
        Object worlddata_a;
        ServerLevel worldserver2;
        TeleportTransition teleporttransition;
        entityplayer.stopRiding();
        this.players.remove(entityplayer);
        this.playersByName.remove(entityplayer.getScoreboardName().toLowerCase(Locale.ROOT));
        entityplayer.level().removePlayerImmediately(entityplayer, entity_removalreason);
        ServerPlayer entityplayer1 = entityplayer;
        ServerLevel fromWorld = entityplayer.level();
        entityplayer.wonGame = false;
        entityplayer1.connection = entityplayer.connection;
        entityplayer1.restoreFrom(entityplayer, flag);
        entityplayer1.setId(entityplayer.getId());
        entityplayer1.setMainArm(entityplayer.getMainArm());
        for (String s : entityplayer.getTags()) {
            entityplayer1.addTag(s);
        }
        if (location == null) {
            teleporttransition = entityplayer.findRespawnPositionAndUseSpawnBlock(!flag, TeleportTransition.DO_NOTHING, reason);
            if (!flag) {
                entityplayer.reset();
            }
        } else {
            teleporttransition = new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), Vec3.ZERO, location.getYaw(), location.getPitch(), TeleportTransition.DO_NOTHING);
        }
        if (teleporttransition == null) {
            return entityplayer;
        }
        ServerLevel worldserver = teleporttransition.newLevel();
        entityplayer1.spawnIn(worldserver, flag);
        entityplayer1.unsetRemoved();
        entityplayer1.setShiftKeyDown(false);
        Vec3 vec3d = teleporttransition.position();
        entityplayer1.forceSetPositionRotation(vec3d.x, vec3d.y, vec3d.z, teleporttransition.yRot(), teleporttransition.xRot());
        if (teleporttransition.missingRespawnBlock()) {
            entityplayer1.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
            entityplayer1.setRespawnPosition(null, false, PlayerSpawnChangeEvent.Cause.RESET);
        }
        byte b0 = (byte)(flag ? 1 : 0);
        ServerLevel worldserver1 = entityplayer1.level();
        LevelData worlddata = worldserver1.getLevelData();
        entityplayer1.connection.send(new ClientboundRespawnPacket(entityplayer1.createCommonSpawnInfo(worldserver1), b0));
        entityplayer1.connection.send(new ClientboundSetChunkCacheRadiusPacket(worldserver1.spigotConfig.viewDistance));
        entityplayer1.connection.send(new ClientboundSetSimulationDistancePacket(worldserver1.spigotConfig.simulationDistance));
        entityplayer1.connection.teleport(CraftLocation.toBukkit(entityplayer1.position(), (World)worldserver1.getWorld(), entityplayer1.getYRot(), entityplayer1.getXRot()));
        entityplayer1.connection.send(new ClientboundSetDefaultSpawnPositionPacket(worldserver.getRespawnData()));
        entityplayer1.connection.send(new ClientboundChangeDifficultyPacket(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
        entityplayer1.connection.send(new ClientboundSetExperiencePacket(entityplayer1.experienceProgress, entityplayer1.totalExperience, entityplayer1.experienceLevel));
        this.sendActivePlayerEffects(entityplayer1);
        this.sendLevelInfo(entityplayer1, worldserver);
        this.sendPlayerPermissionLevel(entityplayer1);
        if (!entityplayer.connection.isDisconnected()) {
            worldserver.addRespawnedPlayer(entityplayer1);
            this.players.add(entityplayer1);
            this.playersByName.put(entityplayer1.getScoreboardName().toLowerCase(Locale.ROOT), entityplayer1);
            this.playersByUUID.put(entityplayer1.getUUID(), entityplayer1);
        }
        entityplayer1.setHealth(entityplayer1.getHealth());
        ServerPlayer.RespawnConfig entityplayer_respawnconfig = entityplayer1.getRespawnConfig();
        if (!flag && entityplayer_respawnconfig != null && (worldserver2 = this.server.getLevel(((LevelData.RespawnData)(worlddata_a = entityplayer_respawnconfig.respawnData())).dimension())) != null && (iblockdata = worldserver2.getBlockState(blockposition = ((LevelData.RespawnData)worlddata_a).pos())).is(Blocks.RESPAWN_ANCHOR)) {
            entityplayer1.connection.send(new ClientboundSoundPacket(SoundEvents.RESPAWN_ANCHOR_DEPLETE, SoundSource.BLOCKS, blockposition.getX(), blockposition.getY(), blockposition.getZ(), 1.0f, 1.0f, worldserver.getRandom().nextLong()));
        }
        this.sendAllPlayerInfo(entityplayer);
        entityplayer.onUpdateAbilities();
        for (MobEffectInstance mobEffect : entityplayer.getActiveEffects()) {
            entityplayer.connection.send(new ClientboundUpdateMobEffectPacket(entityplayer.getId(), mobEffect, false));
        }
        entityplayer.triggerDimensionChangeTriggers(worldserver);
        if (fromWorld != worldserver) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((org.bukkit.entity.Player)entityplayer.getBukkitEntity(), (World)fromWorld.getWorld());
            this.server.server.getPluginManager().callEvent((Event)event);
        }
        if (entityplayer.connection.isDisconnected()) {
            this.save(entityplayer);
        }
        return entityplayer1;
    }

    public void sendActivePlayerEffects(ServerPlayer entityplayer) {
        this.sendActiveEffects(entityplayer, entityplayer.connection);
    }

    public void sendActiveEffects(LivingEntity entityliving, ServerGamePacketListenerImpl playerconnection) {
        for (MobEffectInstance mobeffect : entityliving.getActiveEffects()) {
            playerconnection.send(new ClientboundUpdateMobEffectPacket(entityliving.getId(), mobeffect, false));
        }
    }

    public void sendPlayerPermissionLevel(ServerPlayer entityplayer) {
        int i = this.server.getProfilePermissions(entityplayer.nameAndId());
        this.sendPlayerPermissionLevel(entityplayer, i);
    }

    public void tick() {
        if (++this.sendAllPlayerInfoIn > 600) {
            for (int i = 0; i < this.players.size(); ++i) {
                final ServerPlayer target = this.players.get(i);
                target.connection.send(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY), this.players.stream().filter(new Predicate<ServerPlayer>(){

                    @Override
                    public boolean test(ServerPlayer input) {
                        return target.getBukkitEntity().canSee(input.getBukkitEntity());
                    }
                }).collect(Collectors.toList())));
            }
            this.sendAllPlayerInfoIn = 0;
        }
    }

    public void broadcastAll(Packet<?> packet) {
        for (ServerPlayer entityplayer : this.players) {
            entityplayer.connection.send(packet);
        }
    }

    public void broadcastAll(Packet packet, Player entityhuman) {
        for (int i = 0; i < this.players.size(); ++i) {
            ServerPlayer entityplayer = this.players.get(i);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            this.players.get((int)i).connection.send(packet);
        }
    }

    public void broadcastAll(Packet packet, Level world) {
        for (int i = 0; i < world.players().size(); ++i) {
            ((ServerPlayer)world.players().get((int)i)).connection.send(packet);
        }
    }

    public void broadcastAll(Packet<?> packet, ResourceKey<Level> resourcekey) {
        for (ServerPlayer entityplayer : this.players) {
            if (entityplayer.level().dimension() != resourcekey) continue;
            entityplayer.connection.send(packet);
        }
    }

    public void broadcastSystemToTeam(Player entityhuman, Component ichatbasecomponent) {
        PlayerTeam scoreboardteambase = entityhuman.getTeam();
        if (scoreboardteambase != null) {
            for (String s : ((Team)scoreboardteambase).getPlayers()) {
                ServerPlayer entityplayer = this.getPlayerByName(s);
                if (entityplayer == null || entityplayer == entityhuman) continue;
                entityplayer.sendSystemMessage(ichatbasecomponent);
            }
        }
    }

    public void broadcastSystemToAllExceptTeam(Player entityhuman, Component ichatbasecomponent) {
        PlayerTeam scoreboardteambase = entityhuman.getTeam();
        if (scoreboardteambase == null) {
            this.broadcastSystemMessage(ichatbasecomponent, false);
        } else {
            for (int i = 0; i < this.players.size(); ++i) {
                ServerPlayer entityplayer = this.players.get(i);
                if (entityplayer.getTeam() == scoreboardteambase) continue;
                entityplayer.sendSystemMessage(ichatbasecomponent);
            }
        }
    }

    public String[] getPlayerNamesArray() {
        String[] astring = new String[this.players.size()];
        for (int i = 0; i < this.players.size(); ++i) {
            astring[i] = this.players.get(i).getGameProfile().name();
        }
        return astring;
    }

    public UserBanList getBans() {
        return this.bans;
    }

    public IpBanList getIpBans() {
        return this.ipBans;
    }

    public void op(NameAndId nameandid) {
        this.op(nameandid, Optional.empty(), Optional.empty());
    }

    public void op(NameAndId nameandid, Optional<Integer> optional, Optional<Boolean> optional1) {
        this.ops.add(new ServerOpListEntry(nameandid, optional.orElse(this.server.operatorUserPermissionLevel()), optional1.orElse(this.ops.canBypassPlayerLimit(nameandid))));
        ServerPlayer entityplayer = this.getPlayer(nameandid.id());
        if (entityplayer != null) {
            this.sendPlayerPermissionLevel(entityplayer);
        }
    }

    public void deop(NameAndId nameandid) {
        ServerPlayer entityplayer;
        if (this.ops.remove(nameandid) && (entityplayer = this.getPlayer(nameandid.id())) != null) {
            this.sendPlayerPermissionLevel(entityplayer);
        }
    }

    private void sendPlayerPermissionLevel(ServerPlayer entityplayer, int i) {
        if (entityplayer.connection != null) {
            byte b0 = i <= 0 ? (byte)24 : (i >= 4 ? (byte)28 : (byte)((byte)(24 + i)));
            entityplayer.connection.send(new ClientboundEntityEventPacket(entityplayer, b0));
        }
        entityplayer.getBukkitEntity().recalculatePermissions();
        this.server.getCommands().sendCommands(entityplayer);
    }

    public boolean isWhiteListed(NameAndId nameandid) {
        return !this.isUsingWhitelist() || this.ops.contains(nameandid) || this.whitelist.contains(nameandid);
    }

    public boolean isOp(NameAndId nameandid) {
        return this.ops.contains(nameandid) || this.server.isSingleplayerOwner(nameandid) && this.server.getWorldData().isAllowCommands() || this.allowCommandsForAllPlayers;
    }

    @Nullable
    public ServerPlayer getPlayerByName(String s) {
        return this.playersByName.get(s.toLowerCase(Locale.ROOT));
    }

    public void broadcast(@Nullable Player entityhuman, double d0, double d1, double d2, double d3, ResourceKey<Level> resourcekey, Packet<?> packet) {
        for (int i = 0; i < this.players.size(); ++i) {
            double d6;
            double d5;
            double d4;
            ServerPlayer entityplayer = this.players.get(i);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || entityplayer == entityhuman || entityplayer.level().dimension() != resourcekey || !((d4 = d0 - entityplayer.getX()) * d4 + (d5 = d1 - entityplayer.getY()) * d5 + (d6 = d2 - entityplayer.getZ()) * d6 < d3 * d3)) continue;
            entityplayer.connection.send(packet);
        }
    }

    public void saveAll() {
        for (int i = 0; i < this.players.size(); ++i) {
            this.save(this.players.get(i));
        }
    }

    public UserWhiteList getWhiteList() {
        return this.whitelist;
    }

    public String[] getWhiteListNames() {
        return this.whitelist.getUserList();
    }

    public ServerOpList getOps() {
        return this.ops;
    }

    public String[] getOpNames() {
        return this.ops.getUserList();
    }

    public void reloadWhiteList() {
    }

    public void sendLevelInfo(ServerPlayer entityplayer, ServerLevel worldserver) {
        WorldBorder worldborder = worldserver.getWorldBorder();
        entityplayer.connection.send(new ClientboundInitializeBorderPacket(worldborder));
        entityplayer.connection.send(new ClientboundSetTimePacket(worldserver.getGameTime(), worldserver.getDayTime(), worldserver.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
        entityplayer.connection.send(new ClientboundSetDefaultSpawnPositionPacket(worldserver.getRespawnData()));
        if (worldserver.isRaining()) {
            entityplayer.setPlayerWeather(WeatherType.DOWNFALL, false);
            entityplayer.updateWeather(-worldserver.rainLevel, worldserver.rainLevel, -worldserver.thunderLevel, worldserver.thunderLevel);
        }
        entityplayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.LEVEL_CHUNKS_LOAD_START, 0.0f));
        this.server.tickRateManager().updateJoiningPlayer(entityplayer);
    }

    public void sendAllPlayerInfo(ServerPlayer entityplayer) {
        entityplayer.inventoryMenu.sendAllDataToRemote();
        entityplayer.getBukkitEntity().updateScaledHealth();
        entityplayer.refreshEntityData(entityplayer);
        entityplayer.connection.send(new ClientboundSetHeldSlotPacket(entityplayer.getInventory().getSelectedSlot()));
        int i = entityplayer.level().getGameRules().getBoolean(GameRules.RULE_REDUCEDDEBUGINFO) ? 22 : 23;
        entityplayer.connection.send(new ClientboundEntityEventPacket(entityplayer, (byte)i));
        float immediateRespawn = entityplayer.level().getGameRules().getBoolean(GameRules.RULE_DO_IMMEDIATE_RESPAWN) ? 1.0f : 0.0f;
        entityplayer.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.IMMEDIATE_RESPAWN, immediateRespawn));
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public int getMaxPlayers() {
        return this.server.getMaxPlayers();
    }

    public boolean isUsingWhitelist() {
        return this.server.isUsingWhitelist();
    }

    public List<ServerPlayer> getPlayersWithAddress(String s) {
        ArrayList list = Lists.newArrayList();
        for (ServerPlayer entityplayer : this.players) {
            if (!entityplayer.getIpAddress().equals(s)) continue;
            list.add(entityplayer);
        }
        return list;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    @Nullable
    public CompoundTag getSingleplayerData() {
        return null;
    }

    public void setAllowCommandsForAllPlayers(boolean flag) {
        this.allowCommandsForAllPlayers = flag;
    }

    public void removeAll() {
        for (ServerPlayer player : this.players) {
            player.connection.disconnect(CraftChatMessage.fromStringOrEmpty(this.server.server.getShutdownMessage()));
        }
    }

    public void broadcastMessage(Component[] iChatBaseComponents) {
        for (Component component : iChatBaseComponents) {
            this.broadcastSystemMessage(component, false);
        }
    }

    public void broadcastSystemMessage(Component ichatbasecomponent, boolean flag) {
        this.broadcastSystemMessage(ichatbasecomponent, entityplayer -> ichatbasecomponent, flag);
    }

    public void broadcastSystemMessage(Component ichatbasecomponent, Function<ServerPlayer, Component> function, boolean flag) {
        this.server.sendSystemMessage(ichatbasecomponent);
        for (ServerPlayer entityplayer : this.players) {
            Component ichatbasecomponent1 = function.apply(entityplayer);
            if (ichatbasecomponent1 == null) continue;
            entityplayer.sendSystemMessage(ichatbasecomponent1, flag);
        }
    }

    public void broadcastChatMessage(PlayerChatMessage playerchatmessage, CommandSourceStack commandlistenerwrapper, ChatType.Bound chatmessagetype_a) {
        Objects.requireNonNull(commandlistenerwrapper);
        this.broadcastChatMessage(playerchatmessage, commandlistenerwrapper::shouldFilterMessageTo, commandlistenerwrapper.getPlayer(), chatmessagetype_a);
    }

    public void broadcastChatMessage(PlayerChatMessage playerchatmessage, ServerPlayer entityplayer, ChatType.Bound chatmessagetype_a) {
        Objects.requireNonNull(entityplayer);
        this.broadcastChatMessage(playerchatmessage, entityplayer::shouldFilterMessageTo, entityplayer, chatmessagetype_a);
    }

    private void broadcastChatMessage(PlayerChatMessage playerchatmessage, Predicate<ServerPlayer> predicate, @Nullable ServerPlayer entityplayer, ChatType.Bound chatmessagetype_a) {
        boolean flag = this.verifyChatTrusted(playerchatmessage);
        this.server.logChatMessage(playerchatmessage.decoratedContent(), chatmessagetype_a, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.create(playerchatmessage);
        boolean flag1 = false;
        for (ServerPlayer entityplayer1 : this.players) {
            boolean flag2 = predicate.test(entityplayer1);
            entityplayer1.sendChatMessage(outgoingchatmessage, flag2, chatmessagetype_a);
            flag1 |= flag2 && playerchatmessage.isFullyFiltered();
        }
        if (flag1 && entityplayer != null) {
            entityplayer.sendSystemMessage(CHAT_FILTERED_FULL);
        }
    }

    private boolean verifyChatTrusted(PlayerChatMessage playerchatmessage) {
        return playerchatmessage.hasSignature() && !playerchatmessage.hasExpiredServer(Instant.now());
    }

    public ServerStatsCounter getPlayerStats(ServerPlayer entityhuman) {
        GameProfile gameprofile = entityhuman.getGameProfile();
        UUID uuid = gameprofile.id();
        ServerStatsCounter serverstatisticmanager = entityhuman.getStats();
        return serverstatisticmanager == null ? this.getPlayerStats(uuid, gameprofile.name()) : serverstatisticmanager;
    }

    public ServerStatsCounter getPlayerStats(UUID uuid, String displayName) {
        ServerStatsCounter serverstatisticmanager;
        ServerPlayer entityhuman = this.getPlayer(uuid);
        ServerStatsCounter serverStatsCounter = serverstatisticmanager = entityhuman == null ? null : entityhuman.getStats();
        if (serverstatisticmanager == null) {
            File file2;
            Path path;
            File file = this.server.getWorldPath(LevelResource.PLAYER_STATS_DIR).toFile();
            File file1 = new File(file, String.valueOf(uuid) + ".json");
            if (!file1.exists() && FileUtil.isPathNormalized(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtil.isPathPortable(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new ServerStatsCounter(this.server, file1);
        }
        return serverstatisticmanager;
    }

    public PlayerAdvancements getPlayerAdvancements(ServerPlayer entityplayer) {
        UUID uuid = entityplayer.getUUID();
        PlayerAdvancements advancementdataplayer = entityplayer.getAdvancements();
        if (advancementdataplayer == null) {
            Path path = this.server.getWorldPath(LevelResource.PLAYER_ADVANCEMENTS_DIR).resolve(String.valueOf(uuid) + ".json");
            advancementdataplayer = new PlayerAdvancements(this.server.getFixerUpper(), this, this.server.getAdvancements(), path, entityplayer);
        }
        advancementdataplayer.setPlayer(entityplayer);
        return advancementdataplayer;
    }

    public void setViewDistance(int i) {
        this.viewDistance = i;
        this.broadcastAll(new ClientboundSetChunkCacheRadiusPacket(i));
        for (ServerLevel worldserver : this.server.getAllLevels()) {
            if (worldserver == null) continue;
            worldserver.getChunkSource().setViewDistance(i);
        }
    }

    public void setSimulationDistance(int i) {
        this.simulationDistance = i;
        this.broadcastAll(new ClientboundSetSimulationDistancePacket(i));
        for (ServerLevel worldserver : this.server.getAllLevels()) {
            if (worldserver == null) continue;
            worldserver.getChunkSource().setSimulationDistance(i);
        }
    }

    public List<ServerPlayer> getPlayers() {
        return this.players;
    }

    @Nullable
    public ServerPlayer getPlayer(UUID uuid) {
        return this.playersByUUID.get(uuid);
    }

    @Nullable
    public ServerPlayer getPlayer(String s) {
        for (ServerPlayer entityplayer : this.players) {
            if (!entityplayer.getGameProfile().name().equalsIgnoreCase(s)) continue;
            return entityplayer;
        }
        return null;
    }

    public boolean canBypassPlayerLimit(NameAndId nameandid) {
        return false;
    }

    public void reloadResources() {
        for (ServerPlayer player : this.players) {
            player.getAdvancements().reload(this.server.getAdvancements());
            player.getAdvancements().flushDirty(player, false);
        }
        this.broadcastAll(new ClientboundUpdateTagsPacket(TagNetworkSerialization.serializeTagsToNetwork(this.registries)));
        this.reloadRecipes();
    }

    public void reloadRecipes() {
        RecipeManager craftingmanager = this.server.getRecipeManager();
        ClientboundUpdateRecipesPacket packetplayoutrecipeupdate = new ClientboundUpdateRecipesPacket(craftingmanager.getSynchronizedItemProperties(), craftingmanager.getSynchronizedStonecutterRecipes());
        for (ServerPlayer entityplayer : this.players) {
            entityplayer.connection.send(packetplayoutrecipeupdate);
            entityplayer.getRecipeBook().sendInitialRecipeBook(entityplayer);
        }
    }

    public boolean isAllowCommandsForAllPlayers() {
        return this.allowCommandsForAllPlayers;
    }
}

