/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.Objects;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.StoredUserList;

public class ServerOpList
extends StoredUserList<NameAndId, ServerOpListEntry> {
    public ServerOpList(File var0, NotificationService var1) {
        super(var0, var1);
    }

    @Override
    protected StoredUserEntry<NameAndId> createEntry(JsonObject var0) {
        return new ServerOpListEntry(var0);
    }

    @Override
    public String[] getUserList() {
        return (String[])this.getEntries().stream().map(StoredUserEntry::getUser).filter(Objects::nonNull).map(NameAndId::name).toArray(String[]::new);
    }

    @Override
    public boolean add(ServerOpListEntry var0) {
        if (super.add(var0)) {
            if (var0.getUser() != null) {
                this.notificationService.playerOped(var0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(NameAndId var0) {
        ServerOpListEntry var1 = (ServerOpListEntry)this.get(var0);
        if (super.remove(var0)) {
            if (var1 != null) {
                this.notificationService.playerDeoped(var1);
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (ServerOpListEntry var1 : this.getEntries()) {
            if (var1.getUser() == null) continue;
            this.notificationService.playerDeoped(var1);
        }
        super.clear();
    }

    public boolean canBypassPlayerLimit(NameAndId var0) {
        ServerOpListEntry var1 = (ServerOpListEntry)this.get(var0);
        if (var1 != null) {
            return var1.getBypassesPlayerLimit();
        }
        return false;
    }

    @Override
    protected String getKeyForUser(NameAndId var0) {
        return var0.id().toString();
    }

    @Override
    protected /* synthetic */ String getKeyForUser(Object object) {
        return this.getKeyForUser((NameAndId)object);
    }
}

