/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatsCounter
extends StatsCounter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Map<Stat<?>, Integer>> STATS_CODEC = Codec.dispatchedMap(BuiltInRegistries.STAT_TYPE.byNameCodec(), Util.memoize(ServerStatsCounter::createTypedStatsCodec)).xmap(map -> {
        HashMap map1 = new HashMap();
        map.forEach((statisticwrapper, map2) -> map1.putAll(map2));
        return map1;
    }, map -> map.entrySet().stream().collect(Collectors.groupingBy(entry -> ((Stat)entry.getKey()).getType(), Util.toMap())));
    private final MinecraftServer server;
    private final File file;
    private final Set<Stat<?>> dirty = Sets.newHashSet();

    private static <T> Codec<Map<Stat<T>, Integer>> createTypedStatsCodec(StatType<T> statisticwrapper) {
        Codec<T> codec = statisticwrapper.getRegistry().byNameCodec();
        Objects.requireNonNull(statisticwrapper);
        Codec codec1 = codec.flatComapMap(statisticwrapper::get, statistic -> statistic.getType() == statisticwrapper ? DataResult.success(statistic.getValue()) : DataResult.error(() -> {
            String s = String.valueOf(statisticwrapper);
            return "Expected type " + s + ", but got " + String.valueOf(statistic.getType());
        }));
        return Codec.unboundedMap((Codec)codec1, (Codec)Codec.INT);
    }

    public ServerStatsCounter(MinecraftServer minecraftserver, File file) {
        this.server = minecraftserver;
        this.file = file;
        for (Map.Entry<ResourceLocation, Integer> entry : SpigotConfig.forcedStats.entrySet()) {
            Stat<ResourceLocation> wrapper = Stats.CUSTOM.get(entry.getKey());
            this.stats.put(wrapper, entry.getValue().intValue());
        }
        if (file.isFile()) {
            try {
                this.parseLocal(minecraftserver.getFixerUpper(), FileUtils.readFileToString((File)file));
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't read statistics file {}", (Object)file, (Object)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                LOGGER.error("Couldn't parse statistics file {}", (Object)file, (Object)jsonparseexception);
            }
        }
    }

    public void save() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.file, (String)this.toJson());
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save stats", (Throwable)ioexception);
        }
    }

    @Override
    public void setValue(Player entityhuman, Stat<?> statistic, int i) {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        super.setValue(entityhuman, statistic, i);
        this.dirty.add(statistic);
    }

    private Set<Stat<?>> getDirty() {
        HashSet set = Sets.newHashSet(this.dirty);
        this.dirty.clear();
        return set;
    }

    public void parseLocal(DataFixer datafixer, String s) {
        try {
            JsonElement jsonelement = StrictJsonParser.parse(s);
            if (jsonelement.isJsonNull()) {
                LOGGER.error("Unable to parse Stat data from {}", (Object)this.file);
                return;
            }
            Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement);
            dynamic = DataFixTypes.STATS.updateToCurrentVersion(datafixer, dynamic, NbtUtils.getDataVersion(dynamic, 1343));
            this.stats.putAll(STATS_CODEC.parse(dynamic.get("stats").orElseEmptyMap()).resultOrPartial(s1 -> LOGGER.error("Failed to parse statistics for {}: {}", (Object)this.file, s1)).orElse(Map.of()));
        }
        catch (JsonParseException jsonparseexception) {
            LOGGER.error("Unable to parse Stat data from {}", (Object)this.file, (Object)jsonparseexception);
        }
    }

    protected String toJson() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.add("stats", (JsonElement)STATS_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.stats).getOrThrow());
        jsonobject.addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().dataVersion().version());
        return jsonobject.toString();
    }

    public void markAllDirty() {
        this.dirty.addAll((Collection<Stat<?>>)this.stats.keySet());
    }

    public void sendStats(ServerPlayer entityplayer) {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (Stat<?> statistic : this.getDirty()) {
            object2intmap.put(statistic, this.getValue(statistic));
        }
        entityplayer.connection.send(new ClientboundAwardStatsPacket((Object2IntMap<Stat<?>>)object2intmap));
    }
}

