/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;

public record ModCheck(Confidence confidence, String description) {
    public static ModCheck identify(String var0, Supplier<String> var1, String var2, Class<?> var3) {
        String var4 = var1.get();
        if (!var0.equals(var4)) {
            return new ModCheck(Confidence.DEFINITELY, var2 + " brand changed to '" + var4 + "'");
        }
        if (var3.getSigners() == null) {
            return new ModCheck(Confidence.VERY_LIKELY, var2 + " jar signature invalidated");
        }
        return new ModCheck(Confidence.PROBABLY_NOT, var2 + " jar signature and brand is untouched");
    }

    public boolean shouldReportAsModified() {
        return this.confidence.shouldReportAsModified;
    }

    public ModCheck merge(ModCheck var0) {
        return new ModCheck((Confidence)((Object)ObjectUtils.max((Comparable[])new Confidence[]{this.confidence, var0.confidence})), this.description + "; " + var0.description);
    }

    public String fullDescription() {
        return this.confidence.description + " " + this.description;
    }

    public static enum Confidence {
        PROBABLY_NOT("Probably not.", false),
        VERY_LIKELY("Very likely;", true),
        DEFINITELY("Definitely;", true);

        final String description;
        final boolean shouldReportAsModified;

        private Confidence(String var2, boolean var3) {
            this.description = var2;
            this.shouldReportAsModified = var3;
        }
    }
}

