/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SpawnUtil {
    public static <T extends Mob> Optional<T> trySpawnMob(EntityType<T> entitytypes, EntitySpawnReason entityspawnreason, ServerLevel worldserver, BlockPos blockposition, int i, int j, int k, Strategy spawnutil_a, boolean flag) {
        return SpawnUtil.trySpawnMob(entitytypes, entityspawnreason, worldserver, blockposition, i, j, k, spawnutil_a, flag, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public static <T extends Mob> Optional<T> trySpawnMob(EntityType<T> entitytypes, EntitySpawnReason entityspawnreason, ServerLevel worldserver, BlockPos blockposition, int i, int j, int k, Strategy spawnutil_a, boolean flag, CreatureSpawnEvent.SpawnReason reason) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        for (int l = 0; l < i; ++l) {
            Mob t0;
            int i1 = Mth.randomBetweenInclusive(worldserver.random, -j, j);
            int j1 = Mth.randomBetweenInclusive(worldserver.random, -j, j);
            blockposition_mutableblockposition.setWithOffset(blockposition, i1, k, j1);
            if (!worldserver.getWorldBorder().isWithinBounds(blockposition_mutableblockposition) || !SpawnUtil.moveToPossibleSpawnPosition(worldserver, k, blockposition_mutableblockposition, spawnutil_a) || flag && !worldserver.noCollision(entitytypes.getSpawnAABB((double)blockposition_mutableblockposition.getX() + 0.5, blockposition_mutableblockposition.getY(), (double)blockposition_mutableblockposition.getZ() + 0.5)) || (t0 = (Mob)entitytypes.create(worldserver, null, blockposition_mutableblockposition, entityspawnreason, false, false)) == null) continue;
            if (t0.checkSpawnRules(worldserver, entityspawnreason) && t0.checkSpawnObstruction(worldserver)) {
                worldserver.addFreshEntityWithPassengers(t0, reason);
                if (t0.isRemoved()) {
                    return Optional.empty();
                }
                t0.playAmbientSound();
                return Optional.of(t0);
            }
            t0.discard(null);
        }
        return Optional.empty();
    }

    private static boolean moveToPossibleSpawnPosition(ServerLevel worldserver, int i, BlockPos.MutableBlockPos blockposition_mutableblockposition, Strategy spawnutil_a) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition1 = new BlockPos.MutableBlockPos().set(blockposition_mutableblockposition);
        BlockState iblockdata = worldserver.getBlockState(blockposition_mutableblockposition1);
        for (int j = i; j >= -i; --j) {
            blockposition_mutableblockposition.move(Direction.DOWN);
            blockposition_mutableblockposition1.setWithOffset((Vec3i)blockposition_mutableblockposition, Direction.UP);
            BlockState iblockdata1 = worldserver.getBlockState(blockposition_mutableblockposition);
            if (spawnutil_a.canSpawnOn(worldserver, blockposition_mutableblockposition, iblockdata1, blockposition_mutableblockposition1, iblockdata)) {
                blockposition_mutableblockposition.move(Direction.UP);
                return true;
            }
            iblockdata = iblockdata1;
        }
        return false;
    }

    public static interface Strategy {
        @Deprecated
        public static final Strategy LEGACY_IRON_GOLEM = (worldserver, blockposition, iblockdata, blockposition1, iblockdata1) -> !(iblockdata.is(Blocks.COBWEB) || iblockdata.is(Blocks.CACTUS) || iblockdata.is(Blocks.GLASS_PANE) || iblockdata.getBlock() instanceof StainedGlassPaneBlock || iblockdata.getBlock() instanceof StainedGlassBlock || iblockdata.getBlock() instanceof LeavesBlock || iblockdata.is(Blocks.CONDUIT) || iblockdata.is(Blocks.ICE) || iblockdata.is(Blocks.TNT) || iblockdata.is(Blocks.GLOWSTONE) || iblockdata.is(Blocks.BEACON) || iblockdata.is(Blocks.SEA_LANTERN) || iblockdata.is(Blocks.FROSTED_ICE) || iblockdata.is(Blocks.TINTED_GLASS) || iblockdata.is(Blocks.GLASS)) ? (iblockdata1.isAir() || iblockdata1.liquid()) && (iblockdata.isSolid() || iblockdata.is(Blocks.POWDER_SNOW)) : false;
        public static final Strategy ON_TOP_OF_COLLIDER = (worldserver, blockposition, iblockdata, blockposition1, iblockdata1) -> iblockdata1.getCollisionShape(worldserver, blockposition1).isEmpty() && Block.isFaceFull(iblockdata.getCollisionShape(worldserver, blockposition), Direction.UP);
        public static final Strategy ON_TOP_OF_COLLIDER_NO_LEAVES = (worldserver, blockposition, iblockdata, blockposition1, iblockdata1) -> iblockdata1.getCollisionShape(worldserver, blockposition1).isEmpty() && !iblockdata.is(BlockTags.LEAVES) && Block.isFaceFull(iblockdata.getCollisionShape(worldserver, blockposition), Direction.UP);

        public boolean canSpawnOn(ServerLevel var1, BlockPos var2, BlockState var3, BlockPos var4, BlockState var5);
    }
}

