/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.References;

public class StructureSettingsFlattenFix
extends DataFix {
    public StructureSettingsFlattenFix(Schema var0) {
        super(var0, false);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(References.WORLD_GEN_SETTINGS);
        OpticFinder var1 = var0.findField("dimensions");
        return this.fixTypeEverywhereTyped("StructureSettingsFlatten", var0, var12 -> var12.updateTyped(var1, var1 -> Util.writeAndReadTypedOrThrow(var1, var1.type(), var0 -> var0.updateMapValues(StructureSettingsFlattenFix::fixDimension))));
    }

    private static Pair<Dynamic<?>, Dynamic<?>> fixDimension(Pair<Dynamic<?>, Dynamic<?>> var0) {
        Dynamic var1 = (Dynamic)var0.getSecond();
        return Pair.of((Object)((Dynamic)var0.getFirst()), (Object)var1.update("generator", var02 -> var02.update("settings", var0 -> var0.update("structures", StructureSettingsFlattenFix::fixStructures))));
    }

    private static Dynamic<?> fixStructures(Dynamic<?> var0) {
        Dynamic var1 = var0.get("structures").orElseEmptyMap().updateMapValues(var12 -> var12.mapSecond(var1 -> var1.set("type", var0.createString("minecraft:random_spread"))));
        return (Dynamic)DataFixUtils.orElse(var0.get("stronghold").result().map(var2 -> var1.set("minecraft:stronghold", var2.set("type", var0.createString("minecraft:concentric_rings")))), (Object)var1);
    }
}

