/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.util.profiling.metrics.MetricCategory;

public class MetricSampler {
    private final String name;
    private final MetricCategory category;
    private final DoubleSupplier sampler;
    private final ByteBuf ticks;
    private final ByteBuf values;
    private volatile boolean isRunning;
    @Nullable
    private final Runnable beforeTick;
    @Nullable
    final ThresholdTest thresholdTest;
    private double currentValue;

    protected MetricSampler(String var0, MetricCategory var1, DoubleSupplier var2, @Nullable Runnable var3, @Nullable ThresholdTest var4) {
        this.name = var0;
        this.category = var1;
        this.beforeTick = var3;
        this.sampler = var2;
        this.thresholdTest = var4;
        this.values = ByteBufAllocator.DEFAULT.buffer();
        this.ticks = ByteBufAllocator.DEFAULT.buffer();
        this.isRunning = true;
    }

    public static MetricSampler create(String var0, MetricCategory var1, DoubleSupplier var2) {
        return new MetricSampler(var0, var1, var2, null, null);
    }

    public static <T> MetricSampler create(String var0, MetricCategory var1, T var2, ToDoubleFunction<T> var3) {
        return MetricSampler.builder(var0, var1, var3, var2).build();
    }

    public static <T> MetricSamplerBuilder<T> builder(String var0, MetricCategory var1, ToDoubleFunction<T> var2, T var3) {
        if (var2 == null) {
            throw new IllegalStateException();
        }
        return new MetricSamplerBuilder<T>(var0, var1, var2, var3);
    }

    public void onStartTick() {
        if (!this.isRunning) {
            throw new IllegalStateException("Not running");
        }
        if (this.beforeTick != null) {
            this.beforeTick.run();
        }
    }

    public void onEndTick(int var0) {
        this.verifyRunning();
        this.currentValue = this.sampler.getAsDouble();
        this.values.writeDouble(this.currentValue);
        this.ticks.writeInt(var0);
    }

    public void onFinished() {
        this.verifyRunning();
        this.values.release();
        this.ticks.release();
        this.isRunning = false;
    }

    private void verifyRunning() {
        if (!this.isRunning) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Sampler for metric %s not started!", this.name));
        }
    }

    DoubleSupplier getSampler() {
        return this.sampler;
    }

    public String getName() {
        return this.name;
    }

    public MetricCategory getCategory() {
        return this.category;
    }

    public SamplerResult result() {
        Int2DoubleOpenHashMap var0 = new Int2DoubleOpenHashMap();
        int var1 = Integer.MIN_VALUE;
        int var2 = Integer.MIN_VALUE;
        while (this.values.isReadable(8)) {
            int var3 = this.ticks.readInt();
            if (var1 == Integer.MIN_VALUE) {
                var1 = var3;
            }
            var0.put(var3, this.values.readDouble());
            var2 = var3;
        }
        return new SamplerResult(var1, var2, (Int2DoubleMap)var0);
    }

    public boolean triggersThreshold() {
        return this.thresholdTest != null && this.thresholdTest.test(this.currentValue);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        MetricSampler var1 = (MetricSampler)var0;
        return this.name.equals(var1.name) && this.category.equals((Object)var1.category);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static interface ThresholdTest {
        public boolean test(double var1);
    }

    public static class MetricSamplerBuilder<T> {
        private final String name;
        private final MetricCategory category;
        private final DoubleSupplier sampler;
        private final T context;
        @Nullable
        private Runnable beforeTick;
        @Nullable
        private ThresholdTest thresholdTest;

        public MetricSamplerBuilder(String var0, MetricCategory var1, ToDoubleFunction<T> var2, T var3) {
            this.name = var0;
            this.category = var1;
            this.sampler = () -> var2.applyAsDouble(var3);
            this.context = var3;
        }

        public MetricSamplerBuilder<T> withBeforeTick(Consumer<T> var0) {
            this.beforeTick = () -> var0.accept(this.context);
            return this;
        }

        public MetricSamplerBuilder<T> withThresholdAlert(ThresholdTest var0) {
            this.thresholdTest = var0;
            return this;
        }

        public MetricSampler build() {
            return new MetricSampler(this.name, this.category, this.sampler, this.beforeTick, this.thresholdTest);
        }
    }

    public static class SamplerResult {
        private final Int2DoubleMap recording;
        private final int firstTick;
        private final int lastTick;

        public SamplerResult(int var0, int var1, Int2DoubleMap var2) {
            this.firstTick = var0;
            this.lastTick = var1;
            this.recording = var2;
        }

        public double valueAtTick(int var0) {
            return this.recording.get(var0);
        }

        public int getFirstTick() {
            return this.firstTick;
        }

        public int getLastTick() {
            return this.lastTick;
        }
    }

    public static class ValueIncreasedByPercentage
    implements ThresholdTest {
        private final float percentageIncreaseThreshold;
        private double previousValue = Double.MIN_VALUE;

        public ValueIncreasedByPercentage(float var0) {
            this.percentageIncreaseThreshold = var0;
        }

        @Override
        public boolean test(double var0) {
            boolean var2 = this.previousValue == Double.MIN_VALUE || var0 <= this.previousValue ? false : (var0 - this.previousValue) / this.previousValue >= (double)this.percentageIncreaseThreshold;
            this.previousValue = var0;
            return var2;
        }
    }
}

