/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityTargetEvent;

public interface NeutralMob {
    public static final String TAG_ANGER_TIME = "AngerTime";
    public static final String TAG_ANGRY_AT = "AngryAt";

    public int getRemainingPersistentAngerTime();

    public void setRemainingPersistentAngerTime(int var1);

    @Nullable
    public UUID getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable UUID var1);

    public void startPersistentAngerTimer();

    default public void addPersistentAngerSaveData(ValueOutput valueoutput) {
        valueoutput.putInt(TAG_ANGER_TIME, this.getRemainingPersistentAngerTime());
        valueoutput.storeNullable(TAG_ANGRY_AT, UUIDUtil.CODEC, this.getPersistentAngerTarget());
    }

    default public void readPersistentAngerSaveData(Level world, ValueInput valueinput) {
        this.setRemainingPersistentAngerTime(valueinput.getIntOr(TAG_ANGER_TIME, 0));
        if (world instanceof ServerLevel) {
            Entity entity;
            ServerLevel worldserver = (ServerLevel)world;
            UUID uuid = valueinput.read(TAG_ANGRY_AT, UUIDUtil.CODEC).orElse(null);
            this.setPersistentAngerTarget(uuid);
            Entity entity2 = entity = uuid != null ? worldserver.getEntity(uuid) : null;
            if (entity instanceof LivingEntity) {
                LivingEntity entityliving = (LivingEntity)entity;
                this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, false);
            }
        }
    }

    default public void updatePersistentAnger(ServerLevel worldserver, boolean flag) {
        LivingEntity entityliving = this.getTarget();
        UUID uuid = this.getPersistentAngerTarget();
        if ((entityliving == null || entityliving.isDeadOrDying()) && uuid != null && worldserver.getEntity(uuid) instanceof Mob) {
            this.stopBeingAngry();
        } else {
            if (entityliving != null && !Objects.equals(uuid, entityliving.getUUID())) {
                this.setPersistentAngerTarget(entityliving.getUUID());
                this.startPersistentAngerTimer();
            }
            if (!(this.getRemainingPersistentAngerTime() <= 0 || entityliving != null && entityliving.getType() == EntityType.PLAYER && flag)) {
                this.setRemainingPersistentAngerTime(this.getRemainingPersistentAngerTime() - 1);
                if (this.getRemainingPersistentAngerTime() == 0) {
                    this.stopBeingAngry();
                }
            }
        }
    }

    default public boolean isAngryAt(LivingEntity entityliving, ServerLevel worldserver) {
        return !this.canAttack(entityliving) ? false : (entityliving.getType() == EntityType.PLAYER && this.isAngryAtAllPlayers(worldserver) ? true : entityliving.getUUID().equals(this.getPersistentAngerTarget()));
    }

    default public boolean isAngryAtAllPlayers(ServerLevel worldserver) {
        return worldserver.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER) && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        return this.getRemainingPersistentAngerTime() > 0;
    }

    default public void playerDied(ServerLevel worldserver, Player entityhuman) {
        if (worldserver.getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS) && entityhuman.getUUID().equals(this.getPersistentAngerTarget())) {
            this.stopBeingAngry();
        }
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
        this.setRemainingPersistentAngerTime(0);
    }

    @Nullable
    public LivingEntity getLastHurtByMob();

    public void setLastHurtByMob(@Nullable LivingEntity var1);

    public void setTarget(@Nullable LivingEntity var1);

    public boolean setTarget(@Nullable LivingEntity var1, EntityTargetEvent.TargetReason var2, boolean var3);

    public boolean canAttack(LivingEntity var1);

    @Nullable
    public LivingEntity getTarget();
}

