/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableLong;

public class AcquirePoi {
    public static final int SCAN_RANGE = 48;

    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> var0, MemoryModuleType<GlobalPos> var1, boolean var2, Optional<Byte> var3, BiPredicate<ServerLevel, BlockPos> var4) {
        return AcquirePoi.create(var0, var1, var1, var2, var3, var4);
    }

    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> var02, MemoryModuleType<GlobalPos> var12, boolean var2, Optional<Byte> var3) {
        return AcquirePoi.create(var02, var12, var12, var2, var3, (var0, var1) -> true);
    }

    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> var0, MemoryModuleType<GlobalPos> var1, MemoryModuleType<GlobalPos> var22, boolean var3, Optional<Byte> var4, BiPredicate<ServerLevel, BlockPos> var5) {
        int var6 = 5;
        int var7 = 20;
        MutableLong var8 = new MutableLong(0L);
        Long2ObjectOpenHashMap var9 = new Long2ObjectOpenHashMap();
        OneShot<PathfinderMob> var10 = BehaviorBuilder.create(arg_0 -> AcquirePoi.lambda$create$10(var22, var3, var8, (Long2ObjectMap)var9, var0, var5, var4, arg_0));
        if (var22 == var1) {
            return var10;
        }
        return BehaviorBuilder.create(var2 -> var2.group(var2.absent(var1)).apply((Applicative)var2, var1 -> var10));
    }

    @Nullable
    public static Path findPathToPois(Mob var0, Set<Pair<Holder<PoiType>, BlockPos>> var1) {
        if (var1.isEmpty()) {
            return null;
        }
        HashSet<BlockPos> var2 = new HashSet<BlockPos>();
        int var3 = 1;
        for (Pair<Holder<PoiType>, BlockPos> var5 : var1) {
            var3 = Math.max(var3, ((PoiType)((Holder)var5.getFirst()).value()).validRange());
            var2.add((BlockPos)var5.getSecond());
        }
        return var0.getNavigation().createPath(var2, var3);
    }

    private static /* synthetic */ App lambda$create$10(MemoryModuleType var0, boolean var1, MutableLong var2, Long2ObjectMap var3, Predicate var4, BiPredicate var5, Optional var62, BehaviorBuilder.Instance var7) {
        return var7.group(var7.absent(var0)).apply((Applicative)var7, var6 -> (var7, var82, var9) -> {
            if (var1 && var82.isBaby()) {
                return false;
            }
            if (var2.getValue() == 0L) {
                var2.setValue(var7.getGameTime() + (long)var7.random.nextInt(20));
                return false;
            }
            if (var7.getGameTime() < var2.getValue()) {
                return false;
            }
            var2.setValue(var9 + 20L + (long)var7.getRandom().nextInt(20));
            PoiManager var11 = var7.getPoiManager();
            var3.long2ObjectEntrySet().removeIf(var2 -> !((JitteredLinearRetry)var2.getValue()).isStillValid(var9));
            Predicate<BlockPos> var12 = var3 -> {
                JitteredLinearRetry var4 = (JitteredLinearRetry)var3.get(var3.asLong());
                if (var4 == null) {
                    return true;
                }
                if (!var4.shouldRetry(var9)) {
                    return false;
                }
                var4.markAttempt(var9);
                return true;
            };
            Set<Pair<Holder<PoiType>, BlockPos>> var13 = var11.findAllClosestFirstWithType(var4, var12, var82.blockPosition(), 48, PoiManager.Occupancy.HAS_SPACE).limit(5L).filter(var2 -> var5.test(var7, (BlockPos)var2.getSecond())).collect(Collectors.toSet());
            Path var14 = AcquirePoi.findPathToPois(var82, var13);
            if (var14 != null && var14.canReach()) {
                BlockPos var15 = var14.getTarget();
                var11.getType(var15).ifPresent(var8 -> {
                    var11.take(var4, (var1, var2) -> var2.equals(var15), var15, 1);
                    var6.set(GlobalPos.of(var7.dimension(), var15));
                    var62.ifPresent(var2 -> var7.broadcastEntityEvent(var82, (byte)var2));
                    var3.clear();
                    var7.debugSynchronizers().updatePoi(var15);
                });
            } else {
                for (Pair<Holder<PoiType>, BlockPos> var16 : var13) {
                    var3.computeIfAbsent(((BlockPos)var16.getSecond()).asLong(), var3 -> new JitteredLinearRetry(var0.random, var9));
                }
            }
            return true;
        });
    }

    static class JitteredLinearRetry {
        private static final int MIN_INTERVAL_INCREASE = 40;
        private static final int MAX_INTERVAL_INCREASE = 80;
        private static final int MAX_RETRY_PATHFINDING_INTERVAL = 400;
        private final RandomSource random;
        private long previousAttemptTimestamp;
        private long nextScheduledAttemptTimestamp;
        private int currentDelay;

        JitteredLinearRetry(RandomSource var0, long var1) {
            this.random = var0;
            this.markAttempt(var1);
        }

        public void markAttempt(long var0) {
            this.previousAttemptTimestamp = var0;
            int var2 = this.currentDelay + this.random.nextInt(40) + 40;
            this.currentDelay = Math.min(var2, 400);
            this.nextScheduledAttemptTimestamp = var0 + (long)this.currentDelay;
        }

        public boolean isStillValid(long var0) {
            return var0 - this.previousAttemptTimestamp < 400L;
        }

        public boolean shouldRetry(long var0) {
            return var0 >= this.nextScheduledAttemptTimestamp;
        }

        public String toString() {
            return "RetryMarker{, previousAttemptAt=" + this.previousAttemptTimestamp + ", nextScheduledAttemptAt=" + this.nextScheduledAttemptTimestamp + ", currentDelay=" + this.currentDelay + "}";
        }
    }
}

