/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class LongJumpMidJump
extends Behavior<Mob> {
    public static final int TIME_OUT_DURATION = 100;
    private final UniformInt timeBetweenLongJumps;
    private final SoundEvent landingSound;

    public LongJumpMidJump(UniformInt var0, SoundEvent var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 100);
        this.timeBetweenLongJumps = var0;
        this.landingSound = var1;
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Mob var1, long var2) {
        return !var1.onGround();
    }

    @Override
    protected void start(ServerLevel var0, Mob var1, long var2) {
        var1.setDiscardFriction(true);
        var1.setPose(Pose.LONG_JUMPING);
    }

    @Override
    protected void stop(ServerLevel var0, Mob var1, long var2) {
        if (var1.onGround()) {
            var1.setDeltaMovement(var1.getDeltaMovement().multiply(0.1f, 1.0, 0.1f));
            var0.playSound(null, var1, this.landingSound, SoundSource.NEUTRAL, 2.0f, 1.0f);
        }
        var1.setDiscardFriction(false);
        var1.setPose(Pose.STANDING);
        var1.getBrain().eraseMemory(MemoryModuleType.LONG_JUMP_MID_JUMP);
        var1.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, this.timeBetweenLongJumps.sample(var0.random));
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Mob)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Mob)livingEntity, l);
    }
}

