/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.AcquirePoi;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class SetClosestHomeAsWalkTarget {
    private static final int CACHE_TIMEOUT = 40;
    private static final int BATCH_SIZE = 5;
    private static final int RATE = 20;
    private static final int OK_DISTANCE_SQR = 4;

    public static BehaviorControl<PathfinderMob> create(float var0) {
        Long2LongOpenHashMap var1 = new Long2LongOpenHashMap();
        MutableLong var2 = new MutableLong(0L);
        return BehaviorBuilder.create(arg_0 -> SetClosestHomeAsWalkTarget.lambda$create$6(var2, (Long2LongMap)var1, var0, arg_0));
    }

    private static /* synthetic */ App lambda$create$6(MutableLong var0, Long2LongMap var1, float var2, BehaviorBuilder.Instance var32) {
        return var32.group(var32.absent(MemoryModuleType.WALK_TARGET), var32.absent(MemoryModuleType.HOME)).apply((Applicative)var32, (var3, var42) -> (var4, var5, var6) -> {
            if (var4.getGameTime() - var0.getValue() < 20L) {
                return false;
            }
            PoiManager var8 = var4.getPoiManager();
            Optional<BlockPos> var9 = var8.findClosest(var0 -> var0.is(PoiTypes.HOME), var5.blockPosition(), 48, PoiManager.Occupancy.ANY);
            if (var9.isEmpty() || var9.get().distSqr(var5.blockPosition()) <= 4.0) {
                return false;
            }
            MutableInt var10 = new MutableInt(0);
            var0.setValue(var4.getGameTime() + (long)var4.getRandom().nextInt(20));
            Predicate<BlockPos> var11 = var3 -> {
                ServerLevel var4 = var3.asLong();
                if (var1.containsKey(var4)) {
                    return false;
                }
                if (var10.incrementAndGet() >= 5) {
                    return false;
                }
                var1.put(var4, var0.getValue() + 40L);
                return true;
            };
            Set<Pair<Holder<PoiType>, BlockPos>> var122 = var8.findAllWithType(var0 -> var0.is(PoiTypes.HOME), var11, var5.blockPosition(), 48, PoiManager.Occupancy.ANY).collect(Collectors.toSet());
            Path var13 = AcquirePoi.findPathToPois(var5, var122);
            if (var13 != null && var13.canReach()) {
                BlockPos var14 = var13.getTarget();
                Optional<Holder<PoiType>> var15 = var8.getType(var14);
                if (var15.isPresent()) {
                    var3.set(new WalkTarget(var14, var2, 1));
                    var4.debugSynchronizers().updatePoi(var14);
                }
            } else if (var10.getValue() < 5) {
                var1.long2LongEntrySet().removeIf(var1 -> var1.getLongValue() < var0.getValue());
            }
            return true;
        });
    }
}

