/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ValidateNearbyPoi {
    private static final int MAX_DISTANCE = 16;

    public static BehaviorControl<LivingEntity> create(Predicate<Holder<PoiType>> var0, MemoryModuleType<GlobalPos> var1) {
        return BehaviorBuilder.create(var22 -> var22.group(var22.present(var1)).apply((Applicative)var22, var2 -> (var3, var4, var5) -> {
            GlobalPos var7 = (GlobalPos)var22.get(var2);
            BlockPos var8 = var7.pos();
            if (var3.dimension() != var7.dimension() || !var8.closerToCenterThan(var4.position(), 16.0)) {
                return false;
            }
            ServerLevel var9 = var3.getServer().getLevel(var7.dimension());
            if (var9 == null || !var9.getPoiManager().exists(var8, var0)) {
                var2.erase();
            } else if (ValidateNearbyPoi.bedIsOccupied(var9, var8, var4)) {
                var2.erase();
                if (!ValidateNearbyPoi.bedIsOccupiedByVillager(var9, var8)) {
                    var3.getPoiManager().release(var8);
                    var3.debugSynchronizers().updatePoi(var8);
                }
            }
            return true;
        }));
    }

    private static boolean bedIsOccupied(ServerLevel var0, BlockPos var1, LivingEntity var2) {
        BlockState var3 = var0.getBlockState(var1);
        return var3.is(BlockTags.BEDS) && var3.getValue(BedBlock.OCCUPIED) != false && !var2.isSleeping();
    }

    private static boolean bedIsOccupiedByVillager(ServerLevel var0, BlockPos var1) {
        List<Villager> var2 = var0.getEntitiesOfClass(Villager.class, new AABB(var1), LivingEntity::isSleeping);
        return !var2.isEmpty();
    }
}

