/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.ServerDebugSubscribers;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class PathNavigation {
    private static final int MAX_TIME_RECOMPUTE = 20;
    private static final int STUCK_CHECK_INTERVAL = 100;
    private static final float STUCK_THRESHOLD_DISTANCE_FACTOR = 0.25f;
    protected final Mob mob;
    protected final Level level;
    @Nullable
    protected Path path;
    protected double speedModifier;
    protected int tick;
    protected int lastStuckCheck;
    protected Vec3 lastStuckCheckPos = Vec3.ZERO;
    protected Vec3i timeoutCachedNode = Vec3i.ZERO;
    protected long timeoutTimer;
    protected long lastTimeoutCheck;
    protected double timeoutLimit;
    protected float maxDistanceToWaypoint = 0.5f;
    protected boolean hasDelayedRecomputation;
    protected long timeLastRecompute;
    protected NodeEvaluator nodeEvaluator;
    @Nullable
    private BlockPos targetPos;
    private int reachRange;
    private float maxVisitedNodesMultiplier = 1.0f;
    private final PathFinder pathFinder;
    private boolean isStuck;
    private float requiredPathLength = 16.0f;

    public PathNavigation(Mob var0, Level var1) {
        this.mob = var0;
        this.level = var1;
        this.pathFinder = this.createPathFinder(Mth.floor(var0.getAttributeBaseValue(Attributes.FOLLOW_RANGE) * 16.0));
        if (var1 instanceof ServerLevel) {
            ServerLevel var2 = (ServerLevel)var1;
            ServerDebugSubscribers var3 = var2.getServer().debugSubscribers();
            this.pathFinder.setCaptureDebug(() -> var3.hasAnySubscriberFor(DebugSubscriptions.ENTITY_PATHS));
        }
    }

    public void updatePathfinderMaxVisitedNodes() {
        int var0 = Mth.floor(this.getMaxPathLength() * 16.0f);
        this.pathFinder.setMaxVisitedNodes(var0);
    }

    public void setRequiredPathLength(float var0) {
        this.requiredPathLength = var0;
        this.updatePathfinderMaxVisitedNodes();
    }

    private float getMaxPathLength() {
        return Math.max((float)this.mob.getAttributeValue(Attributes.FOLLOW_RANGE), this.requiredPathLength);
    }

    public void resetMaxVisitedNodesMultiplier() {
        this.maxVisitedNodesMultiplier = 1.0f;
    }

    public void setMaxVisitedNodesMultiplier(float var0) {
        this.maxVisitedNodesMultiplier = var0;
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    protected abstract PathFinder createPathFinder(int var1);

    public void setSpeedModifier(double var0) {
        this.speedModifier = var0;
    }

    public void recomputePath() {
        if (this.level.getGameTime() - this.timeLastRecompute > 20L) {
            if (this.targetPos != null) {
                this.path = null;
                this.path = this.createPath(this.targetPos, this.reachRange);
                this.timeLastRecompute = this.level.getGameTime();
                this.hasDelayedRecomputation = false;
            }
        } else {
            this.hasDelayedRecomputation = true;
        }
    }

    @Nullable
    public final Path createPath(double var0, double var2, double var4, int var6) {
        return this.createPath(BlockPos.containing(var0, var2, var4), var6);
    }

    @Nullable
    public Path createPath(Stream<BlockPos> var0, int var1) {
        return this.createPath(var0.collect(Collectors.toSet()), 8, false, var1);
    }

    @Nullable
    public Path createPath(Set<BlockPos> var0, int var1) {
        return this.createPath(var0, 8, false, var1);
    }

    @Nullable
    public Path createPath(BlockPos var0, int var1) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)var0), 8, false, var1);
    }

    @Nullable
    public Path createPath(BlockPos var0, int var1, int var2) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)var0), 8, false, var1, var2);
    }

    @Nullable
    public Path createPath(Entity var0, int var1) {
        return this.createPath((Set<BlockPos>)ImmutableSet.of((Object)var0.blockPosition()), 16, true, var1);
    }

    @Nullable
    protected Path createPath(Set<BlockPos> var0, int var1, boolean var2, int var3) {
        return this.createPath(var0, var1, var2, var3, this.getMaxPathLength());
    }

    @Nullable
    protected Path createPath(Set<BlockPos> var0, int var1, boolean var2, int var3, float var4) {
        if (var0.isEmpty()) {
            return null;
        }
        if (this.mob.getY() < (double)this.level.getMinY()) {
            return null;
        }
        if (!this.canUpdatePath()) {
            return null;
        }
        if (this.path != null && !this.path.isDone() && var0.contains(this.targetPos)) {
            return this.path;
        }
        ProfilerFiller var5 = Profiler.get();
        var5.push("pathfind");
        BlockPos var6 = var2 ? this.mob.blockPosition().above() : this.mob.blockPosition();
        int var7 = (int)(var4 + (float)var1);
        PathNavigationRegion var8 = new PathNavigationRegion(this.level, var6.offset(-var7, -var7, -var7), var6.offset(var7, var7, var7));
        Path var9 = this.pathFinder.findPath(var8, this.mob, var0, var4, var3, this.maxVisitedNodesMultiplier);
        var5.pop();
        if (var9 != null && var9.getTarget() != null) {
            this.targetPos = var9.getTarget();
            this.reachRange = var3;
            this.resetStuckTimeout();
        }
        return var9;
    }

    public boolean moveTo(double var0, double var2, double var4, double var6) {
        return this.moveTo(this.createPath(var0, var2, var4, 1), var6);
    }

    public boolean moveTo(double var0, double var2, double var4, int var6, double var7) {
        return this.moveTo(this.createPath(var0, var2, var4, var6), var7);
    }

    public boolean moveTo(Entity var0, double var1) {
        Path var3 = this.createPath(var0, 1);
        return var3 != null && this.moveTo(var3, var1);
    }

    public boolean moveTo(@Nullable Path var0, double var1) {
        if (var0 == null) {
            this.path = null;
            return false;
        }
        if (!var0.sameAs(this.path)) {
            this.path = var0;
        }
        if (this.isDone()) {
            return false;
        }
        this.trimPath();
        if (this.path.getNodeCount() <= 0) {
            return false;
        }
        this.speedModifier = var1;
        Vec3 var3 = this.getTempMobPos();
        this.lastStuckCheck = this.tick;
        this.lastStuckCheckPos = var3;
        return true;
    }

    @Nullable
    public Path getPath() {
        return this.path;
    }

    public void tick() {
        Vec3 var0;
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (this.isDone()) {
            return;
        }
        if (this.canUpdatePath()) {
            this.followThePath();
        } else if (this.path != null && !this.path.isDone()) {
            var0 = this.getTempMobPos();
            Vec3 var1 = this.path.getNextEntityPos(this.mob);
            if (var0.y > var1.y && !this.mob.onGround() && Mth.floor(var0.x) == Mth.floor(var1.x) && Mth.floor(var0.z) == Mth.floor(var1.z)) {
                this.path.advance();
            }
        }
        if (this.isDone()) {
            return;
        }
        var0 = this.path.getNextEntityPos(this.mob);
        this.mob.getMoveControl().setWantedPosition(var0.x, this.getGroundY(var0), var0.z, this.speedModifier);
    }

    protected double getGroundY(Vec3 var0) {
        BlockPos var1 = BlockPos.containing(var0);
        return this.level.getBlockState(var1.below()).isAir() ? var0.y : WalkNodeEvaluator.getFloorLevel(this.level, var1);
    }

    protected void followThePath() {
        boolean var8;
        Vec3 var0 = this.getTempMobPos();
        this.maxDistanceToWaypoint = this.mob.getBbWidth() > 0.75f ? this.mob.getBbWidth() / 2.0f : 0.75f - this.mob.getBbWidth() / 2.0f;
        BlockPos var1 = this.path.getNextNodePos();
        double var2 = Math.abs(this.mob.getX() - ((double)var1.getX() + 0.5));
        double var4 = Math.abs(this.mob.getY() - (double)var1.getY());
        double var6 = Math.abs(this.mob.getZ() - ((double)var1.getZ() + 0.5));
        boolean bl = var8 = var2 < (double)this.maxDistanceToWaypoint && var6 < (double)this.maxDistanceToWaypoint && var4 < 1.0;
        if (var8 || this.canCutCorner(this.path.getNextNode().type) && this.shouldTargetNextNodeInDirection(var0)) {
            this.path.advance();
        }
        this.doStuckDetection(var0);
    }

    private boolean shouldTargetNextNodeInDirection(Vec3 var0) {
        boolean var10;
        if (this.path.getNextNodeIndex() + 1 >= this.path.getNodeCount()) {
            return false;
        }
        Vec3 var1 = Vec3.atBottomCenterOf(this.path.getNextNodePos());
        if (!var0.closerThan(var1, 2.0)) {
            return false;
        }
        if (this.canMoveDirectly(var0, this.path.getNextEntityPos(this.mob))) {
            return true;
        }
        Vec3 var2 = Vec3.atBottomCenterOf(this.path.getNodePos(this.path.getNextNodeIndex() + 1));
        Vec3 var3 = var1.subtract(var0);
        Vec3 var4 = var2.subtract(var0);
        double var5 = var3.lengthSqr();
        double var7 = var4.lengthSqr();
        boolean var9 = var7 < var5;
        boolean bl = var10 = var5 < 0.5;
        if (var9 || var10) {
            Vec3 var11 = var3.normalize();
            Vec3 var12 = var4.normalize();
            return var12.dot(var11) < 0.0;
        }
        return false;
    }

    protected void doStuckDetection(Vec3 var0) {
        if (this.tick - this.lastStuckCheck > 100) {
            float var1 = this.mob.getSpeed() >= 1.0f ? this.mob.getSpeed() : this.mob.getSpeed() * this.mob.getSpeed();
            float var2 = var1 * 100.0f * 0.25f;
            if (var0.distanceToSqr(this.lastStuckCheckPos) < (double)(var2 * var2)) {
                this.isStuck = true;
                this.stop();
            } else {
                this.isStuck = false;
            }
            this.lastStuckCheck = this.tick;
            this.lastStuckCheckPos = var0;
        }
        if (this.path != null && !this.path.isDone()) {
            BlockPos var1 = this.path.getNextNodePos();
            long var2 = this.level.getGameTime();
            if (var1.equals(this.timeoutCachedNode)) {
                this.timeoutTimer += var2 - this.lastTimeoutCheck;
            } else {
                this.timeoutCachedNode = var1;
                double var4 = var0.distanceTo(Vec3.atBottomCenterOf(this.timeoutCachedNode));
                double d = this.timeoutLimit = this.mob.getSpeed() > 0.0f ? var4 / (double)this.mob.getSpeed() * 20.0 : 0.0;
            }
            if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
                this.timeoutPath();
            }
            this.lastTimeoutCheck = var2;
        }
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.stop();
    }

    private void resetStuckTimeout() {
        this.timeoutCachedNode = Vec3i.ZERO;
        this.timeoutTimer = 0L;
        this.timeoutLimit = 0.0;
        this.isStuck = false;
    }

    public boolean isDone() {
        return this.path == null || this.path.isDone();
    }

    public boolean isInProgress() {
        return !this.isDone();
    }

    public void stop() {
        this.path = null;
    }

    protected abstract Vec3 getTempMobPos();

    protected abstract boolean canUpdatePath();

    protected void trimPath() {
        if (this.path == null) {
            return;
        }
        for (int var0 = 0; var0 < this.path.getNodeCount(); ++var0) {
            Node var1 = this.path.getNode(var0);
            Node var2 = var0 + 1 < this.path.getNodeCount() ? this.path.getNode(var0 + 1) : null;
            BlockState var3 = this.level.getBlockState(new BlockPos(var1.x, var1.y, var1.z));
            if (!var3.is(BlockTags.CAULDRONS)) continue;
            this.path.replaceNode(var0, var1.cloneAndMove(var1.x, var1.y + 1, var1.z));
            if (var2 == null || var1.y < var2.y) continue;
            this.path.replaceNode(var0 + 1, var1.cloneAndMove(var2.x, var1.y + 1, var2.z));
        }
    }

    protected boolean canMoveDirectly(Vec3 var0, Vec3 var1) {
        return false;
    }

    public boolean canCutCorner(PathType var0) {
        return var0 != PathType.DANGER_FIRE && var0 != PathType.DANGER_OTHER && var0 != PathType.WALKABLE_DOOR;
    }

    protected static boolean isClearForMovementBetween(Mob var0, Vec3 var1, Vec3 var2, boolean var3) {
        Vec3 var4 = new Vec3(var2.x, var2.y + (double)var0.getBbHeight() * 0.5, var2.z);
        return var0.level().clip(new ClipContext(var1, var4, ClipContext.Block.COLLIDER, var3 ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, var0)).getType() == HitResult.Type.MISS;
    }

    public boolean isStableDestination(BlockPos var0) {
        BlockPos var1 = var0.below();
        return this.level.getBlockState(var1).isSolidRender();
    }

    public NodeEvaluator getNodeEvaluator() {
        return this.nodeEvaluator;
    }

    public void setCanFloat(boolean var0) {
        this.nodeEvaluator.setCanFloat(var0);
    }

    public boolean canFloat() {
        return this.nodeEvaluator.canFloat();
    }

    public boolean shouldRecomputePath(BlockPos var0) {
        if (this.hasDelayedRecomputation) {
            return false;
        }
        if (this.path == null || this.path.isDone() || this.path.getNodeCount() == 0) {
            return false;
        }
        Node var1 = this.path.getEndNode();
        Vec3 var2 = new Vec3(((double)var1.x + this.mob.getX()) / 2.0, ((double)var1.y + this.mob.getY()) / 2.0, ((double)var1.z + this.mob.getZ()) / 2.0);
        return var0.closerToCenterThan(var2, this.path.getNodeCount() - this.path.getNextNodeIndex());
    }

    public float getMaxDistanceToWaypoint() {
        return this.maxDistanceToWaypoint;
    }

    public boolean isStuck() {
        return this.isStuck;
    }

    public abstract boolean canNavigateGround();

    public void setCanOpenDoors(boolean var0) {
        this.nodeEvaluator.setCanOpenDoors(var0);
    }
}

