/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class Squid
extends AgeableWaterCreature {
    public float xBodyRot;
    public float xBodyRotO;
    public float zBodyRot;
    public float zBodyRotO;
    public float tentacleMovement;
    public float oldTentacleMovement;
    public float tentacleAngle;
    public float oldTentacleAngle;
    private float speed;
    private float tentacleSpeed;
    private float rotateSpeed;
    Vec3 movementVector = Vec3.ZERO;

    public Squid(EntityType<? extends Squid> var0, Level var1) {
        super((EntityType<? extends AgeableWaterCreature>)var0, var1);
        this.random.setSeed(this.getId());
        this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new SquidRandomMovementGoal(this));
        this.goalSelector.addGoal(1, new SquidFleeGoal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.SQUID_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource var0) {
        return SoundEvents.SQUID_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.SQUID_DEATH;
    }

    protected SoundEvent getSquirtSound() {
        return SoundEvents.SQUID_SQUIRT;
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel var0, AgeableMob var1) {
        return EntityType.SQUID.create(var0, EntitySpawnReason.BREEDING);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.08;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.xBodyRotO = this.xBodyRot;
        this.zBodyRotO = this.zBodyRot;
        this.oldTentacleMovement = this.tentacleMovement;
        this.oldTentacleAngle = this.tentacleAngle;
        this.tentacleMovement += this.tentacleSpeed;
        if ((double)this.tentacleMovement > Math.PI * 2) {
            if (this.level().isClientSide()) {
                this.tentacleMovement = (float)Math.PI * 2;
            } else {
                this.tentacleMovement -= (float)Math.PI * 2;
                if (this.random.nextInt(10) == 0) {
                    this.tentacleSpeed = 1.0f / (this.random.nextFloat() + 1.0f) * 0.2f;
                }
                this.level().broadcastEntityEvent(this, (byte)19);
            }
        }
        if (this.isInWater()) {
            if (this.tentacleMovement < (float)Math.PI) {
                float var0 = this.tentacleMovement / (float)Math.PI;
                this.tentacleAngle = Mth.sin(var0 * var0 * (float)Math.PI) * (float)Math.PI * 0.25f;
                if ((double)var0 > 0.75) {
                    if (this.isLocalInstanceAuthoritative()) {
                        this.setDeltaMovement(this.movementVector);
                    }
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                if (this.isLocalInstanceAuthoritative()) {
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
                }
                this.rotateSpeed *= 0.99f;
            }
            Vec3 var0 = this.getDeltaMovement();
            double var1 = var0.horizontalDistance();
            this.yBodyRot += (-((float)Mth.atan2(var0.x, var0.z)) * 57.295776f - this.yBodyRot) * 0.1f;
            this.setYRot(this.yBodyRot);
            this.zBodyRot += (float)Math.PI * this.rotateSpeed * 1.5f;
            this.xBodyRot += (-((float)Mth.atan2(var1, var0.y)) * 57.295776f - this.xBodyRot) * 0.1f;
        } else {
            this.tentacleAngle = Mth.abs(Mth.sin(this.tentacleMovement)) * (float)Math.PI * 0.25f;
            if (!this.level().isClientSide()) {
                double var0 = this.getDeltaMovement().y;
                var0 = this.hasEffect(MobEffects.LEVITATION) ? 0.05 * (double)(this.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) : (var0 -= this.getGravity());
                this.setDeltaMovement(0.0, var0 * (double)0.98f, 0.0);
            }
            this.xBodyRot += (-90.0f - this.xBodyRot) * 0.02f;
        }
    }

    @Override
    public boolean hurtServer(ServerLevel var0, DamageSource var1, float var2) {
        if (super.hurtServer(var0, var1, var2) && this.getLastHurtByMob() != null) {
            this.spawnInk();
            return true;
        }
        return false;
    }

    private Vec3 rotateVector(Vec3 var0) {
        Vec3 var1 = var0.xRot(this.xBodyRotO * ((float)Math.PI / 180));
        var1 = var1.yRot(-this.yBodyRotO * ((float)Math.PI / 180));
        return var1;
    }

    private void spawnInk() {
        this.makeSound(this.getSquirtSound());
        Vec3 var0 = this.rotateVector(new Vec3(0.0, -1.0, 0.0)).add(this.getX(), this.getY(), this.getZ());
        for (int var1 = 0; var1 < 30; ++var1) {
            Vec3 var2 = this.rotateVector(new Vec3((double)this.random.nextFloat() * 0.6 - 0.3, -1.0, (double)this.random.nextFloat() * 0.6 - 0.3));
            float var3 = this.isBaby() ? 0.1f : 0.3f;
            Vec3 var4 = var2.scale(var3 + this.random.nextFloat() * 2.0f);
            ((ServerLevel)this.level()).sendParticles(this.getInkParticle(), var0.x, var0.y + 0.5, var0.z, 0, var4.x, var4.y, var4.z, 0.1f);
        }
    }

    protected ParticleOptions getInkParticle() {
        return ParticleTypes.SQUID_INK;
    }

    @Override
    public void travel(Vec3 var0) {
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 19) {
            this.tentacleMovement = 0.0f;
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public boolean hasMovementVector() {
        return this.movementVector.lengthSqr() > (double)1.0E-5f;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor var0, DifficultyInstance var1, EntitySpawnReason var2, @Nullable SpawnGroupData var3) {
        SpawnGroupData var4 = Objects.requireNonNullElseGet(var3, () -> new AgeableMob.AgeableMobGroupData(0.05f));
        return super.finalizeSpawn(var0, var1, var2, var4);
    }

    static class SquidRandomMovementGoal
    extends Goal {
        private final Squid squid;

        public SquidRandomMovementGoal(Squid var0) {
            this.squid = var0;
        }

        @Override
        public boolean canUse() {
            return true;
        }

        @Override
        public void tick() {
            int var0 = this.squid.getNoActionTime();
            if (var0 > 100) {
                this.squid.movementVector = Vec3.ZERO;
            } else if (this.squid.getRandom().nextInt(SquidRandomMovementGoal.reducedTickDelay(50)) == 0 || !this.squid.wasTouchingWater || !this.squid.hasMovementVector()) {
                float var1 = this.squid.getRandom().nextFloat() * ((float)Math.PI * 2);
                this.squid.movementVector = new Vec3(Mth.cos(var1) * 0.2f, -0.1f + this.squid.getRandom().nextFloat() * 0.2f, Mth.sin(var1) * 0.2f);
            }
        }
    }

    class SquidFleeGoal
    extends Goal {
        private static final float SQUID_FLEE_SPEED = 3.0f;
        private static final float SQUID_FLEE_MIN_DISTANCE = 5.0f;
        private static final float SQUID_FLEE_MAX_DISTANCE = 10.0f;
        private int fleeTicks;

        SquidFleeGoal() {
        }

        @Override
        public boolean canUse() {
            LivingEntity var0 = Squid.this.getLastHurtByMob();
            if (Squid.this.isInWater() && var0 != null) {
                return Squid.this.distanceToSqr(var0) < 100.0;
            }
            return false;
        }

        @Override
        public void start() {
            this.fleeTicks = 0;
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            ++this.fleeTicks;
            LivingEntity var0 = Squid.this.getLastHurtByMob();
            if (var0 == null) {
                return;
            }
            Vec3 var1 = new Vec3(Squid.this.getX() - var0.getX(), Squid.this.getY() - var0.getY(), Squid.this.getZ() - var0.getZ());
            BlockState var2 = Squid.this.level().getBlockState(BlockPos.containing(Squid.this.getX() + var1.x, Squid.this.getY() + var1.y, Squid.this.getZ() + var1.z));
            FluidState var3 = Squid.this.level().getFluidState(BlockPos.containing(Squid.this.getX() + var1.x, Squid.this.getY() + var1.y, Squid.this.getZ() + var1.z));
            if (var3.is(FluidTags.WATER) || var2.isAir()) {
                double var4 = var1.length();
                if (var4 > 0.0) {
                    var1.normalize();
                    double var6 = 3.0;
                    if (var4 > 5.0) {
                        var6 -= (var4 - 5.0) / 5.0;
                    }
                    if (var6 > 0.0) {
                        var1 = var1.scale(var6);
                    }
                }
                if (var2.isAir()) {
                    var1 = var1.subtract(0.0, var1.y, 0.0);
                }
                Squid.this.movementVector = new Vec3(var1.x / 20.0, var1.y / 20.0, var1.z / 20.0);
            }
            if (this.fleeTicks % 10 == 5) {
                Squid.this.level().addParticle(ParticleTypes.BUBBLE, Squid.this.getX(), Squid.this.getY(), Squid.this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }
}

