/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.camel.CamelAi;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityDamageEvent;

public class Camel
extends AbstractHorse {
    public static final float BABY_SCALE = 0.45f;
    public static final int DASH_COOLDOWN_TICKS = 55;
    public static final int MAX_HEAD_Y_ROT = 30;
    private static final float RUNNING_SPEED_BONUS = 0.1f;
    private static final float DASH_VERTICAL_MOMENTUM = 1.4285f;
    private static final float DASH_HORIZONTAL_MOMENTUM = 22.2222f;
    private static final int DASH_MINIMUM_DURATION_TICKS = 5;
    private static final int SITDOWN_DURATION_TICKS = 40;
    private static final int STANDUP_DURATION_TICKS = 52;
    private static final int IDLE_MINIMAL_DURATION_TICKS = 80;
    private static final float SITTING_HEIGHT_DIFFERENCE = 1.43f;
    private static final long DEFAULT_LAST_POSE_CHANGE_TICK = 0L;
    public static final EntityDataAccessor<Boolean> DASH = SynchedEntityData.defineId(Camel.class, EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK = SynchedEntityData.defineId(Camel.class, EntityDataSerializers.LONG);
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState sitPoseAnimationState = new AnimationState();
    public final AnimationState sitUpAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState dashAnimationState = new AnimationState();
    private static final EntityDimensions SITTING_DIMENSIONS = EntityDimensions.scalable(EntityType.CAMEL.getWidth(), EntityType.CAMEL.getHeight() - 1.43f).withEyeHeight(0.845f);
    private int dashCooldown = 0;
    private int idleAnimationTimeout = 0;

    public Camel(EntityType<? extends Camel> entitytypes, Level world) {
        super((EntityType<? extends AbstractHorse>)entitytypes, world);
        this.moveControl = new CamelMoveControl();
        this.lookControl = new CamelLookControl();
        GroundPathNavigation navigation = (GroundPathNavigation)this.getNavigation();
        navigation.setCanFloat(true);
        navigation.setCanWalkOverFences(true);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putLong("LastPoseTick", this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        long i = valueinput.getLongOr("LastPoseTick", 0L);
        if (i < 0L) {
            this.setPose(Pose.SITTING);
        }
        this.resetLastPoseChangeTick(i);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Camel.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 32.0).add(Attributes.MOVEMENT_SPEED, 0.09f).add(Attributes.JUMP_STRENGTH, 0.42f).add(Attributes.STEP_HEIGHT, 1.5);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DASH, false);
        datawatcher_a.define(LAST_POSE_CHANGE_TICK, 0L);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldaccess, DifficultyInstance difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable SpawnGroupData groupdataentity) {
        CamelAi.initMemories(this, worldaccess.getRandom());
        this.resetLastPoseChangeTickToFullStand(worldaccess.getLevel().getGameTime());
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    public static boolean checkCamelSpawnRules(EntityType<Camel> entitytypes, LevelAccessor generatoraccess, EntitySpawnReason entityspawnreason, BlockPos blockposition, RandomSource randomsource) {
        return generatoraccess.getBlockState(blockposition.below()).is(BlockTags.CAMELS_SPAWNABLE_ON) && Camel.isBrightEnoughToSpawn(generatoraccess, blockposition);
    }

    protected Brain.Provider<Camel> brainProvider() {
        return CamelAi.brainProvider();
    }

    @Override
    protected void registerGoals() {
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return CamelAi.makeBrain(this.brainProvider().makeBrain(dynamic));
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose entitypose) {
        return entitypose == Pose.SITTING ? SITTING_DIMENSIONS.scale(this.getAgeScale()) : super.getDefaultDimensions(entitypose);
    }

    @Override
    protected void customServerAiStep(ServerLevel worldserver) {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("camelBrain");
        Brain<?> behaviorcontroller = this.getBrain();
        behaviorcontroller.tick(worldserver, this);
        gameprofilerfiller.pop();
        gameprofilerfiller.push("camelActivityUpdate");
        CamelAi.updateActivity(this);
        gameprofilerfiller.pop();
        super.customServerAiStep(worldserver);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isDashing() && this.dashCooldown < 50 && (this.onGround() || this.isInLiquid() || this.isPassenger())) {
            this.setDashing(false);
        }
        if (this.dashCooldown > 0) {
            --this.dashCooldown;
            if (this.dashCooldown == 0) {
                this.level().playSound((Entity)null, this.blockPosition(), SoundEvents.CAMEL_DASH_READY, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.refuseToMove()) {
            this.clampHeadRotationToBody();
        }
        if (this.isCamelSitting() && this.isInWater()) {
            this.standUpInstantly();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isCamelVisuallySitting()) {
            this.sitUpAnimationState.stop();
            this.dashAnimationState.stop();
            if (this.isVisuallySittingDown()) {
                this.sitAnimationState.startIfStopped(this.tickCount);
                this.sitPoseAnimationState.stop();
            } else {
                this.sitAnimationState.stop();
                this.sitPoseAnimationState.startIfStopped(this.tickCount);
            }
        } else {
            this.sitAnimationState.stop();
            this.sitPoseAnimationState.stop();
            this.dashAnimationState.animateWhen(this.isDashing(), this.tickCount);
            this.sitUpAnimationState.animateWhen(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.tickCount);
        }
    }

    @Override
    protected void updateWalkAnimation(float f) {
        float f1 = this.getPose() == Pose.STANDING && !this.dashAnimationState.isStarted() ? Math.min(f * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f1, 0.2f, this.isBaby() ? 3.0f : 1.0f);
    }

    @Override
    public void travel(Vec3 vec3d) {
        if (this.refuseToMove() && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            vec3d = vec3d.multiply(0.0, 1.0, 0.0);
        }
        super.travel(vec3d);
    }

    @Override
    protected void tickRidden(Player entityhuman, Vec3 vec3d) {
        super.tickRidden(entityhuman, vec3d);
        if (entityhuman.zza > 0.0f && this.isCamelSitting() && !this.isInPoseTransition()) {
            this.standUp();
        }
    }

    public boolean refuseToMove() {
        return this.isCamelSitting() || this.isInPoseTransition();
    }

    @Override
    protected float getRiddenSpeed(Player entityhuman) {
        float f = entityhuman.isSprinting() && this.getJumpCooldown() == 0 ? 0.1f : 0.0f;
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) + f;
    }

    @Override
    protected Vec2 getRiddenRotation(LivingEntity entityliving) {
        return this.refuseToMove() ? new Vec2(this.getXRot(), this.getYRot()) : super.getRiddenRotation(entityliving);
    }

    @Override
    protected Vec3 getRiddenInput(Player entityhuman, Vec3 vec3d) {
        return this.refuseToMove() ? Vec3.ZERO : super.getRiddenInput(entityhuman, vec3d);
    }

    @Override
    public boolean canJump() {
        return !this.refuseToMove() && super.canJump();
    }

    @Override
    public void onPlayerJump(int i) {
        if (this.isSaddled() && this.dashCooldown <= 0 && this.onGround()) {
            super.onPlayerJump(i);
        }
    }

    @Override
    public boolean canSprint() {
        return true;
    }

    @Override
    protected void executeRidersJump(float f, Vec3 vec3d) {
        double d0 = this.getJumpPower();
        this.addDeltaMovement(this.getLookAngle().multiply(1.0, 0.0, 1.0).normalize().scale((double)(22.2222f * f) * this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)this.getBlockSpeedFactor()).add(0.0, (double)(1.4285f * f) * d0, 0.0));
        this.dashCooldown = 55;
        this.setDashing(true);
        this.hasImpulse = true;
    }

    public boolean isDashing() {
        return this.entityData.get(DASH);
    }

    public void setDashing(boolean flag) {
        this.entityData.set(DASH, flag);
    }

    @Override
    public void handleStartJump(int i) {
        this.makeSound(SoundEvents.CAMEL_DASH);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.setDashing(true);
    }

    @Override
    public void handleStopJump() {
    }

    @Override
    public int getJumpCooldown() {
        return this.dashCooldown;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.CAMEL_AMBIENT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.CAMEL_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return SoundEvents.CAMEL_HURT;
    }

    @Override
    protected void playStepSound(BlockPos blockposition, BlockState iblockdata) {
        if (iblockdata.is(BlockTags.CAMEL_SAND_STEP_SOUND_BLOCKS)) {
            this.playSound(SoundEvents.CAMEL_STEP_SAND, 1.0f, 1.0f);
        } else {
            this.playSound(SoundEvents.CAMEL_STEP, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(ItemTags.CAMEL_FOOD);
    }

    @Override
    public InteractionResult mobInteract(Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (entityhuman.isSecondaryUseActive() && !this.isBaby()) {
            this.openCustomInventoryScreen(entityhuman);
            return InteractionResult.SUCCESS;
        }
        InteractionResult enuminteractionresult = itemstack.interactLivingEntity(entityhuman, this, enumhand);
        if (enuminteractionresult.consumesAction()) {
            return enuminteractionresult;
        }
        if (this.isFood(itemstack)) {
            return this.fedFood(entityhuman, itemstack);
        }
        if (this.getPassengers().size() < 2 && !this.isBaby()) {
            this.doPlayerRide(entityhuman);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onElasticLeashPull() {
        super.onElasticLeashPull();
        if (this.isCamelSitting() && !this.isInPoseTransition() && this.canCamelChangePose()) {
            this.standUp();
        }
    }

    @Override
    public Vec3[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets(this, 0.02, 0.48, 0.25, 0.82);
    }

    public boolean canCamelChangePose() {
        return this.wouldNotSuffocateAtTargetPose(this.isCamelSitting() ? Pose.STANDING : Pose.SITTING);
    }

    @Override
    protected boolean handleEating(Player entityhuman, ItemStack itemstack) {
        SoundEvent soundeffect;
        boolean flag2;
        boolean flag1;
        boolean flag;
        if (!this.isFood(itemstack)) {
            return false;
        }
        boolean bl = flag = this.getHealth() < this.getMaxHealth();
        if (flag) {
            this.heal(2.0f);
        }
        boolean bl2 = flag1 = this.isTamed() && this.getAge() == 0 && this.canFallInLove();
        if (flag1) {
            this.setInLove(entityhuman);
        }
        if (flag2 = this.isBaby()) {
            this.level().addParticle(ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!this.level().isClientSide()) {
                this.ageUp(10);
            }
        }
        if (!(flag || flag1 || flag2)) {
            return false;
        }
        if (!this.isSilent() && (soundeffect = this.getEatingSound()) != null) {
            this.level().playSound((Entity)null, this.getX(), this.getY(), this.getZ(), soundeffect, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.gameEvent(GameEvent.EAT);
        return true;
    }

    @Override
    protected boolean canPerformRearing() {
        return false;
    }

    @Override
    public boolean canMate(Animal entityanimal) {
        if (entityanimal != this && entityanimal instanceof Camel) {
            Camel camel = (Camel)entityanimal;
            if (this.canParent() && camel.canParent()) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    @Override
    @Nullable
    public Camel getBreedOffspring(ServerLevel worldserver, AgeableMob entityageable) {
        return EntityType.CAMEL.create(worldserver, EntitySpawnReason.BREEDING);
    }

    @Override
    @Nullable
    protected SoundEvent getEatingSound() {
        return SoundEvents.CAMEL_EAT;
    }

    @Override
    public boolean actuallyHurt(ServerLevel worldserver, DamageSource damagesource, float f, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(worldserver, damagesource, f, event);
        if (!damageResult) {
            return false;
        }
        this.standUpInstantly();
        return true;
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entitysize, float f) {
        int i = Math.max(this.getPassengers().indexOf(entity), 0);
        boolean flag = i == 0;
        float f1 = 0.5f;
        float f2 = (float)(this.isRemoved() ? (double)0.01f : this.getBodyAnchorAnimationYOffset(flag, 0.0f, entitysize, f));
        if (this.getPassengers().size() > 1) {
            if (!flag) {
                f1 = -0.7f;
            }
            if (entity instanceof Animal) {
                f1 += 0.2f;
            }
        }
        return new Vec3(0.0, f2, f1 * f).yRot(-this.getYRot() * ((float)Math.PI / 180));
    }

    @Override
    public float getAgeScale() {
        return this.isBaby() ? 0.45f : 1.0f;
    }

    private double getBodyAnchorAnimationYOffset(boolean flag, float f, EntityDimensions entitysize, float f1) {
        double d0 = entitysize.height() - 0.375f * f1;
        float f2 = f1 * 1.43f;
        float f3 = f2 - f1 * 0.2f;
        float f4 = f2 - f3;
        boolean flag1 = this.isInPoseTransition();
        boolean flag2 = this.isCamelSitting();
        if (flag1) {
            float f5;
            int j;
            int i;
            int n = i = flag2 ? 40 : 52;
            if (flag2) {
                j = 28;
                f5 = flag ? 0.5f : 0.1f;
            } else {
                j = flag ? 24 : 32;
                f5 = flag ? 0.6f : 0.35f;
            }
            float f6 = Mth.clamp((float)this.getPoseTime() + f, 0.0f, (float)i);
            boolean flag3 = f6 < (float)j;
            float f7 = flag3 ? f6 / (float)j : (f6 - (float)j) / (float)(i - j);
            float f8 = f2 - f5 * f3;
            d0 += flag2 ? (double)Mth.lerp(f7, flag3 ? f2 : f8, flag3 ? f8 : f4) : (double)Mth.lerp(f7, flag3 ? f4 - f2 : f4 - f8, flag3 ? f4 - f8 : 0.0f);
        }
        if (flag2 && !flag1) {
            d0 += (double)f4;
        }
        return d0;
    }

    @Override
    public Vec3 getLeashOffset(float f) {
        EntityDimensions entitysize = this.getDimensions(this.getPose());
        float f1 = this.getAgeScale();
        return new Vec3(0.0, this.getBodyAnchorAnimationYOffset(true, f, entitysize, f1) - (double)(0.2f * f1), entitysize.width() * 0.56f);
    }

    @Override
    public int getMaxHeadYRot() {
        return 30;
    }

    @Override
    protected boolean canAddPassenger(Entity entity) {
        return this.getPassengers().size() <= 2;
    }

    public boolean isCamelSitting() {
        return this.entityData.get(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isCamelVisuallySitting() {
        return this.getPoseTime() < 0L != this.isCamelSitting();
    }

    public boolean isInPoseTransition() {
        long i = this.getPoseTime();
        return i < (long)(this.isCamelSitting() ? 40 : 52);
    }

    private boolean isVisuallySittingDown() {
        return this.isCamelSitting() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void sitDown() {
        if (!this.isCamelSitting()) {
            this.makeSound(SoundEvents.CAMEL_SIT);
            this.setPose(Pose.SITTING);
            this.gameEvent(GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(-this.level().getGameTime());
        }
    }

    public void standUp() {
        if (this.isCamelSitting()) {
            this.makeSound(SoundEvents.CAMEL_STAND);
            this.setPose(Pose.STANDING);
            this.gameEvent(GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(this.level().getGameTime());
        }
    }

    public void standUpInstantly() {
        this.setPose(Pose.STANDING);
        this.gameEvent(GameEvent.ENTITY_ACTION);
        this.resetLastPoseChangeTickToFullStand(this.level().getGameTime());
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long i) {
        this.entityData.set(LAST_POSE_CHANGE_TICK, i);
    }

    private void resetLastPoseChangeTickToFullStand(long i) {
        this.resetLastPoseChangeTick(Math.max(0L, i - 52L - 1L));
    }

    public long getPoseTime() {
        return this.level().getGameTime() - Math.abs(this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    @Override
    protected Holder<SoundEvent> getEquipSound(EquipmentSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return enumitemslot == EquipmentSlot.SADDLE ? SoundEvents.CAMEL_SADDLE : super.getEquipSound(enumitemslot, itemstack, equippable);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        if (!this.firstTick && DASH.equals(datawatcherobject)) {
            this.dashCooldown = this.dashCooldown == 0 ? 55 : this.dashCooldown;
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    public boolean isTamed() {
        return true;
    }

    @Override
    public void openCustomInventoryScreen(Player entityhuman) {
        if (!this.level().isClientSide()) {
            entityhuman.openHorseInventory(this, this.inventory);
        }
    }

    @Override
    protected BodyRotationControl createBodyControl() {
        return new CamelBodyRotationControl(this);
    }

    private class CamelMoveControl
    extends MoveControl {
        public CamelMoveControl() {
            super(Camel.this);
        }

        @Override
        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO && !Camel.this.isLeashed() && Camel.this.isCamelSitting() && !Camel.this.isInPoseTransition() && Camel.this.canCamelChangePose()) {
                Camel.this.standUp();
            }
            super.tick();
        }
    }

    private class CamelLookControl
    extends LookControl {
        CamelLookControl() {
            super(Camel.this);
        }

        @Override
        public void tick() {
            if (!Camel.this.hasControllingPassenger()) {
                super.tick();
            }
        }
    }

    private class CamelBodyRotationControl
    extends BodyRotationControl {
        public CamelBodyRotationControl(Camel camel2) {
            super(camel2);
        }

        @Override
        public void clientTick() {
            if (!Camel.this.refuseToMove()) {
                super.clientTick();
            }
        }
    }
}

