/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.breeze.BreezeUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LongJump
extends Behavior<Breeze> {
    private static final int REQUIRED_AIR_BLOCKS_ABOVE = 4;
    private static final int JUMP_COOLDOWN_TICKS = 10;
    private static final int JUMP_COOLDOWN_WHEN_HURT_TICKS = 2;
    private static final int INHALING_DURATION_TICKS = Math.round(10.0f);
    private static final float DEFAULT_FOLLOW_RANGE = 24.0f;
    private static final float DEFAULT_MAX_JUMP_VELOCITY = 1.4f;
    private static final float MAX_JUMP_VELOCITY_MULTIPLIER = 0.058333334f;
    private static final ObjectArrayList<Integer> ALLOWED_ANGLES = new ObjectArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{40, 55, 60, 75, 80}));

    @VisibleForTesting
    public LongJump() {
        super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_PRESENT, MemoryModuleType.BREEZE_JUMP_COOLDOWN, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREEZE_JUMP_INHALING, MemoryStatus.REGISTERED, MemoryModuleType.BREEZE_JUMP_TARGET, MemoryStatus.REGISTERED, MemoryModuleType.BREEZE_SHOOT, MemoryStatus.VALUE_ABSENT, MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREEZE_LEAVING_WATER, MemoryStatus.REGISTERED), 200);
    }

    public static boolean canRun(ServerLevel var0, Breeze var1) {
        if (!var1.onGround() && !var1.isInWater()) {
            return false;
        }
        if (Swim.shouldSwim(var1)) {
            return false;
        }
        if (var1.getBrain().checkMemory(MemoryModuleType.BREEZE_JUMP_TARGET, MemoryStatus.VALUE_PRESENT)) {
            return true;
        }
        LivingEntity var2 = var1.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (var2 == null) {
            return false;
        }
        if (LongJump.outOfAggroRange(var1, var2)) {
            var1.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            return false;
        }
        if (LongJump.tooCloseForJump(var1, var2)) {
            return false;
        }
        if (!LongJump.canJumpFromCurrentPosition(var0, var1)) {
            return false;
        }
        BlockPos var3 = LongJump.snapToSurface(var1, BreezeUtil.randomPointBehindTarget(var2, var1.getRandom()));
        if (var3 == null) {
            return false;
        }
        BlockState var4 = var0.getBlockState(var3.below());
        if (var1.getType().isBlockDangerous(var4)) {
            return false;
        }
        if (!BreezeUtil.hasLineOfSight(var1, var3.getCenter()) && !BreezeUtil.hasLineOfSight(var1, var3.above(4).getCenter())) {
            return false;
        }
        var1.getBrain().setMemory(MemoryModuleType.BREEZE_JUMP_TARGET, var3);
        return true;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Breeze var1) {
        return LongJump.canRun(var0, var1);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Breeze var1, long var2) {
        return var1.getPose() != Pose.STANDING && !var1.getBrain().hasMemoryValue(MemoryModuleType.BREEZE_JUMP_COOLDOWN);
    }

    @Override
    protected void start(ServerLevel var0, Breeze var12, long var2) {
        if (var12.getBrain().checkMemory(MemoryModuleType.BREEZE_JUMP_INHALING, MemoryStatus.VALUE_ABSENT)) {
            var12.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_JUMP_INHALING, Unit.INSTANCE, INHALING_DURATION_TICKS);
        }
        var12.setPose(Pose.INHALING);
        var0.playSound(null, var12, SoundEvents.BREEZE_CHARGE, SoundSource.HOSTILE, 1.0f, 1.0f);
        var12.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_TARGET).ifPresent(var1 -> var12.lookAt(EntityAnchorArgument.Anchor.EYES, var1.getCenter()));
    }

    @Override
    protected void tick(ServerLevel var0, Breeze var12, long var2) {
        boolean var4 = var12.isInWater();
        if (!var4 && var12.getBrain().checkMemory(MemoryModuleType.BREEZE_LEAVING_WATER, MemoryStatus.VALUE_PRESENT)) {
            var12.getBrain().eraseMemory(MemoryModuleType.BREEZE_LEAVING_WATER);
        }
        if (LongJump.isFinishedInhaling(var12)) {
            Vec3 var5 = var12.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_TARGET).flatMap(var1 -> LongJump.calculateOptimalJumpVector(var12, var12.getRandom(), Vec3.atBottomCenterOf(var1))).orElse(null);
            if (var5 == null) {
                var12.setPose(Pose.STANDING);
                return;
            }
            if (var4) {
                var12.getBrain().setMemory(MemoryModuleType.BREEZE_LEAVING_WATER, Unit.INSTANCE);
            }
            var12.playSound(SoundEvents.BREEZE_JUMP, 1.0f, 1.0f);
            var12.setPose(Pose.LONG_JUMPING);
            var12.setYRot(var12.yBodyRot);
            var12.setDiscardFriction(true);
            var12.setDeltaMovement(var5);
        } else if (LongJump.isFinishedJumping(var12)) {
            var12.playSound(SoundEvents.BREEZE_LAND, 1.0f, 1.0f);
            var12.setPose(Pose.STANDING);
            var12.setDiscardFriction(false);
            boolean var5 = var12.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
            var12.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_JUMP_COOLDOWN, Unit.INSTANCE, var5 ? 2L : 10L);
            var12.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT, Unit.INSTANCE, 100L);
        }
    }

    @Override
    protected void stop(ServerLevel var0, Breeze var1, long var2) {
        if (var1.getPose() == Pose.LONG_JUMPING || var1.getPose() == Pose.INHALING) {
            var1.setPose(Pose.STANDING);
        }
        var1.getBrain().eraseMemory(MemoryModuleType.BREEZE_JUMP_TARGET);
        var1.getBrain().eraseMemory(MemoryModuleType.BREEZE_JUMP_INHALING);
        var1.getBrain().eraseMemory(MemoryModuleType.BREEZE_LEAVING_WATER);
    }

    private static boolean isFinishedInhaling(Breeze var0) {
        return var0.getBrain().getMemory(MemoryModuleType.BREEZE_JUMP_INHALING).isEmpty() && var0.getPose() == Pose.INHALING;
    }

    private static boolean isFinishedJumping(Breeze var0) {
        boolean var1 = var0.getPose() == Pose.LONG_JUMPING;
        boolean var2 = var0.onGround();
        boolean var3 = var0.isInWater() && var0.getBrain().checkMemory(MemoryModuleType.BREEZE_LEAVING_WATER, MemoryStatus.VALUE_ABSENT);
        return var1 && (var2 || var3);
    }

    @Nullable
    private static BlockPos snapToSurface(LivingEntity var0, Vec3 var1) {
        ClipContext var2 = new ClipContext(var1, var1.relative(Direction.DOWN, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, var0);
        BlockHitResult var3 = var0.level().clip(var2);
        if (((HitResult)var3).getType() == HitResult.Type.BLOCK) {
            return BlockPos.containing(var3.getLocation()).above();
        }
        ClipContext var4 = new ClipContext(var1, var1.relative(Direction.UP, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, var0);
        BlockHitResult var5 = var0.level().clip(var4);
        if (((HitResult)var5).getType() == HitResult.Type.BLOCK) {
            return BlockPos.containing(var5.getLocation()).above();
        }
        return null;
    }

    private static boolean outOfAggroRange(Breeze var0, LivingEntity var1) {
        return !var1.closerThan(var0, var0.getAttributeValue(Attributes.FOLLOW_RANGE));
    }

    private static boolean tooCloseForJump(Breeze var0, LivingEntity var1) {
        return var1.distanceTo(var0) - 4.0f <= 0.0f;
    }

    private static boolean canJumpFromCurrentPosition(ServerLevel var0, Breeze var1) {
        BlockPos var2 = var1.blockPosition();
        if (var0.getBlockState(var2).is(Blocks.HONEY_BLOCK)) {
            return false;
        }
        for (int var3 = 1; var3 <= 4; ++var3) {
            BlockPos var4 = var2.relative(Direction.UP, var3);
            if (var0.getBlockState(var4).isAir() || var0.getFluidState(var4).is(FluidTags.WATER)) continue;
            return false;
        }
        return true;
    }

    private static Optional<Vec3> calculateOptimalJumpVector(Breeze var0, RandomSource var1, Vec3 var22) {
        List<Integer> var3 = Util.shuffledCopy(ALLOWED_ANGLES, var1);
        for (int var5 : var3) {
            float var6 = 0.058333334f * (float)var0.getAttributeValue(Attributes.FOLLOW_RANGE);
            Optional<Vec3> var7 = LongJumpUtil.calculateJumpVectorForAngle(var0, var22, var6, var5, false);
            if (!var7.isPresent()) continue;
            if (var0.hasEffect(MobEffects.JUMP_BOOST)) {
                double var8 = var7.get().normalize().y * (double)var0.getJumpBoostPower();
                return var7.map(var2 -> var2.add(0.0, var8, 0.0));
            }
            return var7;
        }
        return Optional.empty();
    }

    @Override
    protected /* synthetic */ boolean checkExtraStartConditions(ServerLevel serverLevel, LivingEntity livingEntity) {
        return this.checkExtraStartConditions(serverLevel, (Breeze)livingEntity);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Breeze)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Breeze)livingEntity, l);
    }
}

