/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public abstract class AbstractThrownPotion
extends ThrowableItemProjectile {
    public static final double SPLASH_RANGE = 4.0;
    protected static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<LivingEntity> WATER_SENSITIVE_OR_ON_FIRE = entityliving -> entityliving.isSensitiveToWater() || entityliving.isOnFire();

    public AbstractThrownPotion(EntityType<? extends AbstractThrownPotion> entitytypes, Level world) {
        super((EntityType<? extends ThrowableItemProjectile>)entitytypes, world);
    }

    public AbstractThrownPotion(EntityType<? extends AbstractThrownPotion> entitytypes, Level world, LivingEntity entityliving, ItemStack itemstack) {
        super(entitytypes, entityliving, world, itemstack);
    }

    public AbstractThrownPotion(EntityType<? extends AbstractThrownPotion> entitytypes, Level world, double d0, double d1, double d2, ItemStack itemstack) {
        super(entitytypes, d0, d1, d2, world, itemstack);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    @Override
    protected void onHitBlock(BlockHitResult movingobjectpositionblock) {
        super.onHitBlock(movingobjectpositionblock);
        if (!this.level().isClientSide()) {
            ItemStack itemstack = this.getItem();
            Direction enumdirection = movingobjectpositionblock.getDirection();
            BlockPos blockposition = movingobjectpositionblock.getBlockPos();
            BlockPos blockposition1 = blockposition.relative(enumdirection);
            PotionContents potioncontents = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            if (potioncontents.is(Potions.WATER)) {
                this.dowseFire(blockposition1);
                this.dowseFire(blockposition1.relative(enumdirection.getOpposite()));
                for (Direction enumdirection1 : Direction.Plane.HORIZONTAL) {
                    this.dowseFire(blockposition1.relative(enumdirection1));
                }
            }
        }
    }

    @Override
    protected void onHit(HitResult movingobjectposition) {
        super.onHit(movingobjectposition);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            ItemStack itemstack = this.getItem();
            PotionContents potioncontents = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            if (potioncontents.is(Potions.WATER)) {
                this.onHitAsWater(worldserver);
            } else {
                this.onHitAsPotion(worldserver, itemstack, movingobjectposition);
            }
            int i = potioncontents.potion().isPresent() && potioncontents.potion().get().value().hasInstantEffects() ? 2007 : 2002;
            worldserver.levelEvent(i, this.blockPosition(), potioncontents.getColor());
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    private void onHitAsWater(ServerLevel worldserver) {
        AABB axisalignedbb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        for (LivingEntity entityliving : this.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb, WATER_SENSITIVE_OR_ON_FIRE)) {
            double d0 = this.distanceToSqr(entityliving);
            if (!(d0 < 16.0)) continue;
            if (entityliving.isSensitiveToWater()) {
                entityliving.hurtServer(worldserver, this.damageSources().indirectMagic(this, this.getOwner()), 1.0f);
            }
            if (!entityliving.isOnFire() || !entityliving.isAlive()) continue;
            entityliving.extinguishFire();
        }
        for (Axolotl axolotl : this.level().getEntitiesOfClass(Axolotl.class, axisalignedbb)) {
            axolotl.rehydrate();
        }
    }

    protected abstract void onHitAsPotion(ServerLevel var1, ItemStack var2, HitResult var3);

    private void dowseFire(BlockPos blockposition) {
        BlockState iblockdata = this.level().getBlockState(blockposition);
        if (iblockdata.is(BlockTags.FIRE)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, Blocks.AIR.defaultBlockState())) {
                this.level().destroyBlock(blockposition, false, this);
            }
        } else if (AbstractCandleBlock.isLit(iblockdata)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, (BlockState)iblockdata.setValue(AbstractCandleBlock.LIT, false))) {
                AbstractCandleBlock.extinguish(null, iblockdata, this.level(), blockposition);
            }
        } else if (CampfireBlock.isLitCampfire(iblockdata) && CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, (BlockState)iblockdata.setValue(CampfireBlock.LIT, false))) {
            this.level().levelEvent(null, 1009, blockposition, 0);
            CampfireBlock.dowse(this.getOwner(), this.level(), blockposition, iblockdata);
            this.level().setBlockAndUpdate(blockposition, (BlockState)iblockdata.setValue(CampfireBlock.LIT, false));
        }
    }

    @Override
    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity entityliving, DamageSource damagesource) {
        double d0 = entityliving.position().x - this.position().x;
        double d1 = entityliving.position().z - this.position().z;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

