/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;

public abstract class AbstractMinecart
extends VehicleEntity {
    private static final Vec3 LOWERED_PASSENGER_ATTACHMENT = new Vec3(0.0, 0.0, 0.0);
    private static final EntityDataAccessor<Optional<BlockState>> DATA_ID_CUSTOM_DISPLAY_BLOCK = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.OPTIONAL_BLOCK_STATE);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_OFFSET = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final ImmutableMap<Pose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)Pose.STANDING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.CROUCHING, (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)Pose.SWIMMING, (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private static final boolean DEFAULT_FLIPPED_ROTATION = false;
    private boolean onRails;
    private boolean flipped = false;
    private final MinecartBehavior behavior;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = Maps.newEnumMap((Map)((Map)Util.make(() -> {
        Vec3i baseblockposition = Direction.WEST.getUnitVec3i();
        Vec3i baseblockposition1 = Direction.EAST.getUnitVec3i();
        Vec3i baseblockposition2 = Direction.NORTH.getUnitVec3i();
        Vec3i baseblockposition3 = Direction.SOUTH.getUnitVec3i();
        Vec3i baseblockposition4 = baseblockposition.below();
        Vec3i baseblockposition5 = baseblockposition1.below();
        Vec3i baseblockposition6 = baseblockposition2.below();
        Vec3i baseblockposition7 = baseblockposition3.below();
        return ImmutableMap.of((Object)RailShape.NORTH_SOUTH, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition3), (Object)RailShape.EAST_WEST, (Object)Pair.of((Object)baseblockposition, (Object)baseblockposition1), (Object)RailShape.ASCENDING_EAST, (Object)Pair.of((Object)baseblockposition4, (Object)baseblockposition1), (Object)RailShape.ASCENDING_WEST, (Object)Pair.of((Object)baseblockposition, (Object)baseblockposition5), (Object)RailShape.ASCENDING_NORTH, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition7), (Object)RailShape.ASCENDING_SOUTH, (Object)Pair.of((Object)baseblockposition6, (Object)baseblockposition3), (Object)RailShape.SOUTH_EAST, (Object)Pair.of((Object)baseblockposition3, (Object)baseblockposition1), (Object)RailShape.SOUTH_WEST, (Object)Pair.of((Object)baseblockposition3, (Object)baseblockposition), (Object)RailShape.NORTH_WEST, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition), (Object)RailShape.NORTH_EAST, (Object)Pair.of((Object)baseblockposition2, (Object)baseblockposition1));
    })));
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95;
    private double flyingY = 0.95;
    private double flyingZ = 0.95;
    public Double maxSpeed;
    public double powRailAccelMult = 1.0;

    protected AbstractMinecart(EntityType<?> entitytypes, Level world) {
        super(entitytypes, world);
        this.blocksBuilding = true;
        this.behavior = AbstractMinecart.useExperimentalMovement(world) ? new NewMinecartBehavior(this) : new OldMinecartBehavior(this);
    }

    protected AbstractMinecart(EntityType<?> entitytypes, Level world, double d0, double d1, double d2) {
        this(entitytypes, world);
        this.setInitialPos(d0, d1, d2);
    }

    public void setInitialPos(double d0, double d1, double d2) {
        this.setPos(d0, d1, d2);
        this.xo = d0;
        this.yo = d1;
        this.zo = d2;
    }

    @Nullable
    public static <T extends AbstractMinecart> T createMinecart(Level world, double d0, double d1, double d2, EntityType<T> entitytypes, EntitySpawnReason entityspawnreason, ItemStack itemstack, @Nullable Player entityhuman) {
        AbstractMinecart t0 = (AbstractMinecart)entitytypes.create(world, entityspawnreason);
        if (t0 != null) {
            t0.setInitialPos(d0, d1, d2);
            EntityType.createDefaultStackConfig(world, itemstack, entityhuman).accept(t0);
            MinecartBehavior minecartbehavior = t0.getBehavior();
            if (minecartbehavior instanceof NewMinecartBehavior) {
                NewMinecartBehavior newminecartbehavior = (NewMinecartBehavior)minecartbehavior;
                BlockPos blockposition = t0.getCurrentBlockPosOrRailBelow();
                BlockState iblockdata = world.getBlockState(blockposition);
                newminecartbehavior.adjustToRails(blockposition, iblockdata, true);
            }
        }
        return (T)t0;
    }

    public MinecartBehavior getBehavior() {
        return this.behavior;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_ID_CUSTOM_DISPLAY_BLOCK, Optional.empty());
        datawatcher_a.define(DATA_ID_DISPLAY_OFFSET, this.getDefaultDisplayOffset());
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return AbstractBoat.canVehicleCollide(this, entity);
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public Vec3 getRelativePortalPosition(Direction.Axis enumdirection_enumaxis, BlockUtil.FoundRectangle blockutil_rectangle) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(enumdirection_enumaxis, blockutil_rectangle));
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entitysize, float f) {
        boolean flag = entity instanceof Villager || entity instanceof WanderingTrader;
        return flag ? LOWERED_PASSENGER_ATTACHMENT : super.getPassengerAttachmentPoint(entity, entitysize, f);
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity entityliving) {
        Direction enumdirection = this.getMotionDirection();
        if (enumdirection.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(entityliving);
        }
        int[][] aint = DismountHelper.offsetsForDirection(enumdirection);
        BlockPos blockposition = this.blockPosition();
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        ImmutableList<Pose> immutablelist = entityliving.getDismountPoses();
        for (Pose entitypose : immutablelist) {
            EntityDimensions entitysize = entityliving.getDimensions(entitypose);
            float f = Math.min(entitysize.width(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableiterator1 = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)entitypose)).iterator();
            while (unmodifiableiterator1.hasNext()) {
                int i = (Integer)unmodifiableiterator1.next();
                for (int[] aint1 : aint) {
                    blockposition_mutableblockposition.set(blockposition.getX() + aint1[0], blockposition.getY() + i, blockposition.getZ() + aint1[1]);
                    double d0 = this.level().getBlockFloorHeight(DismountHelper.nonClimbableShape(this.level(), blockposition_mutableblockposition), () -> DismountHelper.nonClimbableShape(this.level(), (BlockPos)blockposition_mutableblockposition.below()));
                    if (!DismountHelper.isBlockFloorValid(d0)) continue;
                    AABB axisalignedbb = new AABB(-f, 0.0, -f, f, entitysize.height(), f);
                    Vec3 vec3d = Vec3.upFromBottomCenterOf(blockposition_mutableblockposition, d0);
                    if (!DismountHelper.canDismountTo(this.level(), entityliving, axisalignedbb.move(vec3d))) continue;
                    entityliving.setPose(entitypose);
                    return vec3d;
                }
            }
        }
        double d1 = this.getBoundingBox().maxY;
        blockposition_mutableblockposition.set((double)blockposition.getX(), d1, (double)blockposition.getZ());
        for (Pose entitypose1 : immutablelist) {
            int j;
            double d3;
            double d2 = entityliving.getDimensions(entitypose1).height();
            if (!(d1 + d2 <= (d3 = DismountHelper.findCeilingFrom(blockposition_mutableblockposition, j = Mth.ceil(d1 - (double)blockposition_mutableblockposition.getY() + d2), blockposition1 -> this.level().getBlockState((BlockPos)blockposition1).getCollisionShape(this.level(), (BlockPos)blockposition1))))) continue;
            entityliving.setPose(entitypose1);
            break;
        }
        return super.getDismountLocationForPassenger(entityliving);
    }

    @Override
    protected float getBlockSpeedFactor() {
        BlockState iblockdata = this.level().getBlockState(this.blockPosition());
        return iblockdata.is(BlockTags.RAILS) ? 1.0f : super.getBlockSpeedFactor();
    }

    @Override
    public void animateHurt(float f) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    public static Pair<Vec3i, Vec3i> exits(RailShape blockpropertytrackposition) {
        return EXITS.get(blockpropertytrackposition);
    }

    @Override
    public Direction getMotionDirection() {
        return this.behavior.getMotionDirection();
    }

    @Override
    protected double getDefaultGravity() {
        return this.isInWater() ? 0.005 : 0.04;
    }

    @Override
    public void tick() {
        double prevX = this.getX();
        double prevY = this.getY();
        double prevZ = this.getZ();
        float prevYaw = this.getYRot();
        float prevPitch = this.getXRot();
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkBelowWorld();
        this.behavior.tick();
        CraftWorld bworld = this.level().getWorld();
        Location from = new Location((World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
        Location to = CraftLocation.toBukkit(this.position(), (World)bworld, this.getYRot(), this.getXRot());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        this.level().getCraftServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (!from.equals((Object)to)) {
            this.level().getCraftServer().getPluginManager().callEvent((Event)new VehicleMoveEvent(vehicle, from, to));
        }
        this.updateInWaterStateAndDoFluidPushing();
        if (this.isInLava()) {
            this.lavaIgnite();
            this.lavaHurt();
            this.fallDistance *= 0.5;
        }
        this.firstTick = false;
    }

    public boolean isFirstTick() {
        return this.firstTick;
    }

    public BlockPos getCurrentBlockPosOrRailBelow() {
        int i = Mth.floor(this.getX());
        int j = Mth.floor(this.getY());
        int k = Mth.floor(this.getZ());
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            double d0 = this.getY() - 0.1 - (double)1.0E-5f;
            if (this.level().getBlockState(BlockPos.containing(i, d0, k)).is(BlockTags.RAILS)) {
                j = Mth.floor(d0);
            }
        } else if (this.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
            --j;
        }
        return new BlockPos(i, j, k);
    }

    protected double getMaxSpeed(ServerLevel worldserver) {
        return this.behavior.getMaxSpeed(worldserver);
    }

    public void activateMinecart(int i, int j, int k, boolean flag) {
    }

    @Override
    public void lerpPositionAndRotationStep(int i, double d0, double d1, double d2, double d3, double d4) {
        super.lerpPositionAndRotationStep(i, d0, d1, d2, d3, d4);
    }

    @Override
    public void applyGravity() {
        super.applyGravity();
    }

    @Override
    public void reapplyPosition() {
        super.reapplyPosition();
    }

    @Override
    public boolean updateInWaterStateAndDoFluidPushing() {
        return super.updateInWaterStateAndDoFluidPushing();
    }

    @Override
    public Vec3 getKnownMovement() {
        return this.behavior.getKnownMovement(super.getKnownMovement());
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.behavior.getInterpolation();
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        this.behavior.lerpMotion(this.getDeltaMovement());
    }

    @Override
    public void lerpMotion(Vec3 vec3d) {
        this.behavior.lerpMotion(vec3d);
    }

    protected void moveAlongTrack(ServerLevel worldserver) {
        this.behavior.moveAlongTrack(worldserver);
    }

    protected void comeOffTrack(ServerLevel worldserver) {
        double d0 = this.getMaxSpeed(worldserver);
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(Mth.clamp(vec3d.x, -d0, d0), vec3d.y, Mth.clamp(vec3d.z, -d0, d0));
        if (this.onGround()) {
            this.setDeltaMovement(new Vec3(this.getDeltaMovement().x * this.derailedX, this.getDeltaMovement().y * this.derailedY, this.getDeltaMovement().z * this.derailedZ));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.onGround()) {
            this.setDeltaMovement(new Vec3(this.getDeltaMovement().x * this.flyingX, this.getDeltaMovement().y * this.flyingY, this.getDeltaMovement().z * this.flyingZ));
        }
    }

    protected double makeStepAlongTrack(BlockPos blockposition, RailShape blockpropertytrackposition, double d0) {
        return this.behavior.stepAlongTrack(blockposition, blockpropertytrackposition, d0);
    }

    @Override
    public void move(MoverType enummovetype, Vec3 vec3d) {
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            Vec3 vec3d1 = this.position().add(vec3d);
            super.move(enummovetype, vec3d);
            boolean flag = this.behavior.pushAndPickupEntities();
            if (flag) {
                super.move(enummovetype, vec3d1.subtract(this.position()));
            }
            if (enummovetype.equals((Object)MoverType.PISTON)) {
                this.onRails = false;
            }
        } else {
            super.move(enummovetype, vec3d);
            this.applyEffectsFromBlocks();
        }
    }

    @Override
    public void applyEffectsFromBlocks() {
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            super.applyEffectsFromBlocks();
        } else {
            this.applyEffectsFromBlocks(this.position(), this.position());
            this.clearMovementThisTick();
        }
    }

    @Override
    public boolean isOnRails() {
        return this.onRails;
    }

    public void setOnRails(boolean flag) {
        this.onRails = flag;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean flag) {
        this.flipped = flag;
    }

    public Vec3 getRedstoneDirection(BlockPos blockposition) {
        BlockState iblockdata = this.level().getBlockState(blockposition);
        if (iblockdata.is(Blocks.POWERED_RAIL) && iblockdata.getValue(PoweredRailBlock.POWERED).booleanValue()) {
            RailShape blockpropertytrackposition = iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty());
            if (blockpropertytrackposition == RailShape.EAST_WEST) {
                if (this.isRedstoneConductor(blockposition.west())) {
                    return new Vec3(1.0, 0.0, 0.0);
                }
                if (this.isRedstoneConductor(blockposition.east())) {
                    return new Vec3(-1.0, 0.0, 0.0);
                }
            } else if (blockpropertytrackposition == RailShape.NORTH_SOUTH) {
                if (this.isRedstoneConductor(blockposition.north())) {
                    return new Vec3(0.0, 0.0, 1.0);
                }
                if (this.isRedstoneConductor(blockposition.south())) {
                    return new Vec3(0.0, 0.0, -1.0);
                }
            }
            return Vec3.ZERO;
        }
        return Vec3.ZERO;
    }

    public boolean isRedstoneConductor(BlockPos blockposition) {
        return this.level().getBlockState(blockposition).isRedstoneConductor(this.level(), blockposition);
    }

    protected Vec3 applyNaturalSlowdown(Vec3 vec3d) {
        double d0 = this.behavior.getSlowdownFactor();
        Vec3 vec3d1 = vec3d.multiply(d0, 0.0, d0);
        if (this.isInWater()) {
            vec3d1 = vec3d1.scale(0.95f);
        }
        return vec3d1;
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        this.setCustomDisplayBlockState(valueinput.read("DisplayState", BlockState.CODEC));
        this.setDisplayOffset(valueinput.getIntOr("DisplayOffset", this.getDefaultDisplayOffset()));
        this.flipped = valueinput.getBooleanOr("FlippedRotation", false);
        this.firstTick = valueinput.getBooleanOr("HasTicked", false);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        this.getCustomDisplayBlockState().ifPresent(iblockdata -> valueoutput.store("DisplayState", BlockState.CODEC, iblockdata));
        int i = this.getDisplayOffset();
        if (i != this.getDefaultDisplayOffset()) {
            valueoutput.putInt("DisplayOffset", i);
        }
        valueoutput.putBoolean("FlippedRotation", this.flipped);
        valueoutput.putBoolean("HasTicked", this.firstTick);
    }

    @Override
    public void push(Entity entity) {
        if (!(this.level().isClientSide() || entity.noPhysics || this.noPhysics || this.hasPassenger(entity))) {
            double d1;
            VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
            this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
            if (collisionEvent.isCancelled()) {
                return;
            }
            double d0 = entity.getX() - this.getX();
            double d2 = d0 * d0 + (d1 = entity.getZ() - this.getZ()) * d1;
            if (d2 >= (double)1.0E-4f) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.1f;
                d1 *= (double)0.1f;
                d0 *= 0.5;
                d1 *= 0.5;
                if (entity instanceof AbstractMinecart) {
                    AbstractMinecart entityminecartabstract = (AbstractMinecart)entity;
                    this.pushOtherMinecart(entityminecartabstract, d0, d1);
                } else {
                    this.push(-d0, 0.0, -d1);
                    entity.push(d0 / 4.0, 0.0, d1 / 4.0);
                }
            }
        }
    }

    private void pushOtherMinecart(AbstractMinecart entityminecartabstract, double d0, double d1) {
        double d3;
        double d2;
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            d2 = this.getDeltaMovement().x;
            d3 = this.getDeltaMovement().z;
        } else {
            d2 = entityminecartabstract.getX() - this.getX();
            d3 = entityminecartabstract.getZ() - this.getZ();
        }
        Vec3 vec3d = new Vec3(d2, 0.0, d3).normalize();
        Vec3 vec3d1 = new Vec3(Mth.cos(this.getYRot() * ((float)Math.PI / 180)), 0.0, Mth.sin(this.getYRot() * ((float)Math.PI / 180))).normalize();
        double d4 = Math.abs(vec3d.dot(vec3d1));
        if (d4 >= (double)0.8f || AbstractMinecart.useExperimentalMovement(this.level())) {
            Vec3 vec3d2 = this.getDeltaMovement();
            Vec3 vec3d3 = entityminecartabstract.getDeltaMovement();
            if (entityminecartabstract.isFurnace() && !this.isFurnace()) {
                this.setDeltaMovement(vec3d2.multiply(0.2, 1.0, 0.2));
                this.push(vec3d3.x - d0, 0.0, vec3d3.z - d1);
                entityminecartabstract.setDeltaMovement(vec3d3.multiply(0.95, 1.0, 0.95));
            } else if (!entityminecartabstract.isFurnace() && this.isFurnace()) {
                entityminecartabstract.setDeltaMovement(vec3d3.multiply(0.2, 1.0, 0.2));
                entityminecartabstract.push(vec3d2.x + d0, 0.0, vec3d2.z + d1);
                this.setDeltaMovement(vec3d2.multiply(0.95, 1.0, 0.95));
            } else {
                double d5 = (vec3d3.x + vec3d2.x) / 2.0;
                double d6 = (vec3d3.z + vec3d2.z) / 2.0;
                this.setDeltaMovement(vec3d2.multiply(0.2, 1.0, 0.2));
                this.push(d5 - d0, 0.0, d6 - d1);
                entityminecartabstract.setDeltaMovement(vec3d3.multiply(0.2, 1.0, 0.2));
                entityminecartabstract.push(d5 + d0, 0.0, d6 + d1);
            }
        }
    }

    public BlockState getDisplayBlockState() {
        return this.getCustomDisplayBlockState().orElseGet(this::getDefaultDisplayBlockState);
    }

    private Optional<BlockState> getCustomDisplayBlockState() {
        return this.getEntityData().get(DATA_ID_CUSTOM_DISPLAY_BLOCK);
    }

    public BlockState getDefaultDisplayBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public int getDisplayOffset() {
        return this.getEntityData().get(DATA_ID_DISPLAY_OFFSET);
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setCustomDisplayBlockState(Optional<BlockState> optional) {
        this.getEntityData().set(DATA_ID_CUSTOM_DISPLAY_BLOCK, optional);
    }

    public void setDisplayOffset(int i) {
        this.getEntityData().set(DATA_ID_DISPLAY_OFFSET, i);
    }

    public static boolean useExperimentalMovement(Level world) {
        return world.enabledFeatures().contains(FeatureFlags.MINECART_IMPROVEMENTS);
    }

    @Override
    public abstract ItemStack getPickResult();

    public boolean isRideable() {
        return false;
    }

    public boolean isFurnace() {
        return false;
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }
}

