/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.HashedStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public abstract class AbstractContainerMenu {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int SLOT_CLICKED_OUTSIDE = -999;
    public static final int QUICKCRAFT_TYPE_CHARITABLE = 0;
    public static final int QUICKCRAFT_TYPE_GREEDY = 1;
    public static final int QUICKCRAFT_TYPE_CLONE = 2;
    public static final int QUICKCRAFT_HEADER_START = 0;
    public static final int QUICKCRAFT_HEADER_CONTINUE = 1;
    public static final int QUICKCRAFT_HEADER_END = 2;
    public static final int CARRIED_SLOT_SIZE = Integer.MAX_VALUE;
    public static final int SLOTS_PER_ROW = 9;
    public static final int SLOT_SIZE = 18;
    public NonNullList<net.minecraft.world.item.ItemStack> lastSlots = NonNullList.create();
    public NonNullList<Slot> slots = NonNullList.create();
    private final List<DataSlot> dataSlots = Lists.newArrayList();
    private net.minecraft.world.item.ItemStack carried = net.minecraft.world.item.ItemStack.EMPTY;
    public NonNullList<RemoteSlot> remoteSlots = NonNullList.create();
    private final IntList remoteDataSlots = new IntArrayList();
    private RemoteSlot remoteCarried = RemoteSlot.PLACEHOLDER;
    private int stateId;
    @Nullable
    private final MenuType<?> menuType;
    public final int containerId;
    private int quickcraftType = -1;
    public int quickcraftStatus;
    private final Set<Slot> quickcraftSlots = Sets.newHashSet();
    private final List<ContainerListener> containerListeners = Lists.newArrayList();
    @Nullable
    private ContainerSynchronizer synchronizer;
    private boolean suppressRemoteUpdates;
    public boolean checkReachable = true;
    private Component title;
    protected boolean opened;

    public abstract InventoryView getBukkitView();

    public void transferTo(AbstractContainerMenu other, CraftHumanEntity player) {
        InventoryView source = this.getBukkitView();
        InventoryView destination = other.getBukkitView();
        ((CraftInventory)source.getTopInventory()).getInventory().onClose(player);
        ((CraftInventory)source.getBottomInventory()).getInventory().onClose(player);
        ((CraftInventory)destination.getTopInventory()).getInventory().onOpen(player);
        ((CraftInventory)destination.getBottomInventory()).getInventory().onOpen(player);
    }

    public final Component getTitle() {
        Preconditions.checkState((this.title != null ? 1 : 0) != 0, (Object)"Title not set");
        return this.title;
    }

    public final void setTitle(Component title) {
        Preconditions.checkState((this.title == null ? 1 : 0) != 0, (Object)"Title already set");
        this.title = title;
    }

    public void startOpen() {
        this.opened = true;
    }

    protected AbstractContainerMenu(@Nullable MenuType<?> containers, int i) {
        this.menuType = containers;
        this.containerId = i;
    }

    protected void addInventoryHotbarSlots(Container iinventory, int i, int j) {
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot(iinventory, k, i + k * 18, j));
        }
    }

    protected void addInventoryExtendedSlots(Container iinventory, int i, int j) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot(iinventory, l + (k + 1) * 9, i + l * 18, j + k * 18));
            }
        }
    }

    protected void addStandardInventorySlots(Container iinventory, int i, int j) {
        this.addInventoryExtendedSlots(iinventory, i, j);
        int k = 4;
        int l = 58;
        this.addInventoryHotbarSlots(iinventory, i, j + 58);
    }

    protected static boolean stillValid(ContainerLevelAccess containeraccess, Player entityhuman, Block block) {
        return containeraccess.evaluate((world, blockposition) -> !world.getBlockState((BlockPos)blockposition).is(block) ? false : entityhuman.canInteractWithBlock((BlockPos)blockposition, 4.0), true);
    }

    public MenuType<?> getType() {
        if (this.menuType == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.menuType;
    }

    protected static void checkContainerSize(Container iinventory, int i) {
        int j = iinventory.getContainerSize();
        if (j < i) {
            throw new IllegalArgumentException("Container size " + j + " is smaller than expected " + i);
        }
    }

    protected static void checkContainerDataCount(ContainerData icontainerproperties, int i) {
        int j = icontainerproperties.getCount();
        if (j < i) {
            throw new IllegalArgumentException("Container data count " + j + " is smaller than expected " + i);
        }
    }

    public boolean isValidSlotIndex(int i) {
        return i == -1 || i == -999 || i < this.slots.size();
    }

    protected Slot addSlot(Slot slot) {
        slot.index = this.slots.size();
        this.slots.add(slot);
        this.lastSlots.add(net.minecraft.world.item.ItemStack.EMPTY);
        this.remoteSlots.add(this.synchronizer != null ? this.synchronizer.createSlot() : RemoteSlot.PLACEHOLDER);
        return slot;
    }

    protected DataSlot addDataSlot(DataSlot containerproperty) {
        this.dataSlots.add(containerproperty);
        this.remoteDataSlots.add(0);
        return containerproperty;
    }

    protected void addDataSlots(ContainerData icontainerproperties) {
        for (int i = 0; i < icontainerproperties.getCount(); ++i) {
            this.addDataSlot(DataSlot.forContainer(icontainerproperties, i));
        }
    }

    public void addSlotListener(ContainerListener icrafting) {
        if (!this.containerListeners.contains(icrafting)) {
            this.containerListeners.add(icrafting);
            this.broadcastChanges();
        }
    }

    public void setSynchronizer(ContainerSynchronizer containersynchronizer) {
        this.synchronizer = containersynchronizer;
        this.remoteCarried = containersynchronizer.createSlot();
        this.remoteSlots.replaceAll(remoteslot -> containersynchronizer.createSlot());
        this.sendAllDataToRemote();
    }

    public void sendAllDataToRemote() {
        ArrayList<net.minecraft.world.item.ItemStack> list = new ArrayList<net.minecraft.world.item.ItemStack>(this.slots.size());
        int j = this.slots.size();
        for (int i = 0; i < j; ++i) {
            net.minecraft.world.item.ItemStack itemstack = this.slots.get(i).getItem();
            list.add(itemstack.copy());
            this.remoteSlots.get(i).force(itemstack);
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.getCarried();
        this.remoteCarried.force(itemstack1);
        int l = this.dataSlots.size();
        for (int k = 0; k < l; ++k) {
            this.remoteDataSlots.set(k, this.dataSlots.get(k).get());
        }
        if (this.synchronizer != null) {
            this.synchronizer.sendInitialData(this, list, itemstack1.copy(), this.remoteDataSlots.toIntArray());
        }
    }

    public void broadcastCarriedItem() {
        net.minecraft.world.item.ItemStack itemstack = this.getCarried().copy();
        this.remoteCarried.force(itemstack);
        if (this.synchronizer != null) {
            this.synchronizer.sendCarriedChange(this, itemstack);
        }
    }

    public void removeSlotListener(ContainerListener icrafting) {
        this.containerListeners.remove(icrafting);
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        NonNullList<net.minecraft.world.item.ItemStack> nonnulllist = NonNullList.create();
        for (Slot slot : this.slots) {
            nonnulllist.add(slot.getItem());
        }
        return nonnulllist;
    }

    public void broadcastChanges() {
        for (int i = 0; i < this.slots.size(); ++i) {
            net.minecraft.world.item.ItemStack itemstack = this.slots.get(i).getItem();
            Objects.requireNonNull(itemstack);
            com.google.common.base.Supplier supplier = Suppliers.memoize(itemstack::copy);
            this.triggerSlotListeners(i, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
            this.synchronizeSlotToRemote(i, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
        }
        this.synchronizeCarriedToRemote();
        for (int j = 0; j < this.dataSlots.size(); ++j) {
            DataSlot containerproperty = this.dataSlots.get(j);
            int k = containerproperty.get();
            if (containerproperty.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(j, k);
            }
            this.synchronizeDataSlotToRemote(j, k);
        }
    }

    public void broadcastFullState() {
        for (int i = 0; i < this.slots.size(); ++i) {
            net.minecraft.world.item.ItemStack itemstack = this.slots.get(i).getItem();
            Objects.requireNonNull(itemstack);
            this.triggerSlotListeners(i, itemstack, itemstack::copy);
        }
        for (int j = 0; j < this.dataSlots.size(); ++j) {
            DataSlot containerproperty = this.dataSlots.get(j);
            if (!containerproperty.checkAndClearUpdateFlag()) continue;
            this.updateDataSlotListeners(j, containerproperty.get());
        }
        this.sendAllDataToRemote();
    }

    private void updateDataSlotListeners(int i, int j) {
        for (ContainerListener icrafting : this.containerListeners) {
            icrafting.dataChanged(this, i, j);
        }
    }

    private void triggerSlotListeners(int i, net.minecraft.world.item.ItemStack itemstack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        net.minecraft.world.item.ItemStack itemstack1 = this.lastSlots.get(i);
        if (!net.minecraft.world.item.ItemStack.matches(itemstack1, itemstack)) {
            net.minecraft.world.item.ItemStack itemstack2 = supplier.get();
            this.lastSlots.set(i, itemstack2);
            for (ContainerListener icrafting : this.containerListeners) {
                icrafting.slotChanged(this, i, itemstack2);
            }
        }
    }

    private void synchronizeSlotToRemote(int i, net.minecraft.world.item.ItemStack itemstack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        RemoteSlot remoteslot;
        if (!this.suppressRemoteUpdates && !(remoteslot = this.remoteSlots.get(i)).matches(itemstack)) {
            remoteslot.force(itemstack);
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange(this, i, supplier.get());
            }
        }
    }

    private void synchronizeDataSlotToRemote(int i, int j) {
        int k;
        if (!this.suppressRemoteUpdates && (k = this.remoteDataSlots.getInt(i)) != j) {
            this.remoteDataSlots.set(i, j);
            if (this.synchronizer != null) {
                this.synchronizer.sendDataChange(this, i, j);
            }
        }
    }

    private void synchronizeCarriedToRemote() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!this.suppressRemoteUpdates && !this.remoteCarried.matches(itemstack = this.getCarried())) {
            this.remoteCarried.force(itemstack);
            if (this.synchronizer != null) {
                this.synchronizer.sendCarriedChange(this, itemstack.copy());
            }
        }
    }

    public void setRemoteSlot(int i, net.minecraft.world.item.ItemStack itemstack) {
        this.remoteSlots.get(i).force(itemstack);
    }

    public void setRemoteSlotUnsafe(int i, HashedStack hashedstack) {
        if (i >= 0 && i < this.remoteSlots.size()) {
            this.remoteSlots.get(i).receive(hashedstack);
        } else {
            LOGGER.debug("Incorrect slot index: {} available slots: {}", (Object)i, (Object)this.remoteSlots.size());
        }
    }

    public void setRemoteCarried(HashedStack hashedstack) {
        this.remoteCarried.receive(hashedstack);
    }

    public boolean clickMenuButton(Player entityhuman, int i) {
        return false;
    }

    public Slot getSlot(int i) {
        return this.slots.get(i);
    }

    public abstract net.minecraft.world.item.ItemStack quickMoveStack(Player var1, int var2);

    public void setSelectedBundleItemIndex(int i, int j) {
        if (i >= 0 && i < this.slots.size()) {
            net.minecraft.world.item.ItemStack itemstack = this.slots.get(i).getItem();
            BundleItem.toggleSelectedItem(itemstack, j);
        }
    }

    public void clicked(int i, int j, ClickType inventoryclicktype, Player entityhuman) {
        try {
            this.doClick(i, j, inventoryclicktype, entityhuman);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.forThrowable(exception, "Container click");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Click info");
            crashreportsystemdetails.setDetail("Menu Type", () -> this.menuType != null ? BuiltInRegistries.MENU.getKey(this.menuType).toString() : "<no type>");
            crashreportsystemdetails.setDetail("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportsystemdetails.setDetail("Slot Count", this.slots.size());
            crashreportsystemdetails.setDetail("Slot", i);
            crashreportsystemdetails.setDetail("Button", j);
            crashreportsystemdetails.setDetail("Type", (Object)inventoryclicktype);
            throw new ReportedException(crashreport);
        }
    }

    private void doClick(int i, int j, ClickType inventoryclicktype, Player entityhuman) {
        block48: {
            block60: {
                block56: {
                    net.minecraft.world.item.ItemStack itemstack7;
                    Slot slot4;
                    net.minecraft.world.item.ItemStack itemstack62;
                    Inventory playerinventory;
                    block59: {
                        block58: {
                            block57: {
                                block53: {
                                    ClickAction clickaction;
                                    block55: {
                                        block54: {
                                            block52: {
                                                block46: {
                                                    block51: {
                                                        net.minecraft.world.item.ItemStack itemstack;
                                                        block50: {
                                                            block49: {
                                                                block47: {
                                                                    playerinventory = entityhuman.getInventory();
                                                                    if (inventoryclicktype != ClickType.QUICK_CRAFT) break block46;
                                                                    int k = this.quickcraftStatus;
                                                                    this.quickcraftStatus = AbstractContainerMenu.getQuickcraftHeader(j);
                                                                    if (k == 1 && this.quickcraftStatus == 2 || k == this.quickcraftStatus) break block47;
                                                                    this.resetQuickCraft();
                                                                    break block48;
                                                                }
                                                                if (!this.getCarried().isEmpty()) break block49;
                                                                this.resetQuickCraft();
                                                                break block48;
                                                            }
                                                            if (this.quickcraftStatus != 0) break block50;
                                                            this.quickcraftType = AbstractContainerMenu.getQuickcraftType(j);
                                                            if (AbstractContainerMenu.isValidQuickcraftType(this.quickcraftType, entityhuman)) {
                                                                this.quickcraftStatus = 1;
                                                                this.quickcraftSlots.clear();
                                                            } else {
                                                                this.resetQuickCraft();
                                                            }
                                                            break block48;
                                                        }
                                                        if (this.quickcraftStatus != 1) break block51;
                                                        Slot slot = this.slots.get(i);
                                                        if (!AbstractContainerMenu.canItemQuickReplace(slot, itemstack = this.getCarried(), true) || !slot.mayPlace(itemstack) || this.quickcraftType != 2 && itemstack.getCount() <= this.quickcraftSlots.size() || !this.canDragTo(slot)) break block48;
                                                        this.quickcraftSlots.add(slot);
                                                        break block48;
                                                    }
                                                    if (this.quickcraftStatus == 2) {
                                                        if (!this.quickcraftSlots.isEmpty()) {
                                                            boolean needsUpdate;
                                                            net.minecraft.world.item.ItemStack itemstack1 = this.getCarried().copy();
                                                            if (itemstack1.isEmpty()) {
                                                                this.resetQuickCraft();
                                                                return;
                                                            }
                                                            int i1 = this.getCarried().getCount();
                                                            HashMap<Integer, net.minecraft.world.item.ItemStack> draggedSlots = new HashMap<Integer, net.minecraft.world.item.ItemStack>();
                                                            for (Slot slot1 : this.quickcraftSlots) {
                                                                net.minecraft.world.item.ItemStack itemstack2 = this.getCarried();
                                                                if (slot1 == null || !AbstractContainerMenu.canItemQuickReplace(slot1, itemstack2, true) || !slot1.mayPlace(itemstack2) || this.quickcraftType != 2 && itemstack2.getCount() < this.quickcraftSlots.size() || !this.canDragTo(slot1)) continue;
                                                                int j1 = slot1.hasItem() ? slot1.getItem().getCount() : 0;
                                                                int k1 = Math.min(itemstack1.getMaxStackSize(), slot1.getMaxStackSize(itemstack1));
                                                                int l1 = Math.min(AbstractContainerMenu.getQuickCraftPlaceCount(this.quickcraftSlots, this.quickcraftType, itemstack1) + j1, k1);
                                                                i1 -= l1 - j1;
                                                                draggedSlots.put(slot1.index, itemstack1.copyWithCount(l1));
                                                            }
                                                            InventoryView view = this.getBukkitView();
                                                            CraftItemStack newcursor = CraftItemStack.asCraftMirror(itemstack1);
                                                            newcursor.setAmount(i1);
                                                            HashMap<Integer, ItemStack> eventmap = new HashMap<Integer, ItemStack>();
                                                            for (Map.Entry ditem : draggedSlots.entrySet()) {
                                                                eventmap.put((Integer)ditem.getKey(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ditem.getValue()));
                                                            }
                                                            net.minecraft.world.item.ItemStack oldCursor = this.getCarried();
                                                            this.setCarried(CraftItemStack.asNMSCopy(newcursor));
                                                            InventoryDragEvent event = new InventoryDragEvent(view, (ItemStack)(newcursor.getType() != Material.AIR ? newcursor : null), CraftItemStack.asBukkitCopy(oldCursor), this.quickcraftType == 1, eventmap);
                                                            entityhuman.level().getCraftServer().getPluginManager().callEvent((Event)event);
                                                            boolean bl = needsUpdate = event.getResult() != Event.Result.DEFAULT;
                                                            if (event.getResult() != Event.Result.DENY) {
                                                                for (Map.Entry dslot : draggedSlots.entrySet()) {
                                                                    view.setItem(((Integer)dslot.getKey()).intValue(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)dslot.getValue()));
                                                                }
                                                                if (this.getCarried() != null) {
                                                                    this.setCarried(CraftItemStack.asNMSCopy(event.getCursor()));
                                                                    needsUpdate = true;
                                                                }
                                                            } else {
                                                                this.setCarried(oldCursor);
                                                            }
                                                            if (needsUpdate && entityhuman instanceof ServerPlayer) {
                                                                this.sendAllDataToRemote();
                                                            }
                                                        }
                                                        this.resetQuickCraft();
                                                    } else {
                                                        this.resetQuickCraft();
                                                    }
                                                    break block48;
                                                }
                                                if (this.quickcraftStatus == 0) break block52;
                                                this.resetQuickCraft();
                                                break block48;
                                            }
                                            if (inventoryclicktype != ClickType.PICKUP && inventoryclicktype != ClickType.QUICK_MOVE || j != 0 && j != 1) break block53;
                                            ClickAction clickAction = clickaction = j == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                                            if (i != -999) break block54;
                                            if (this.getCarried().isEmpty()) break block48;
                                            if (clickaction == ClickAction.PRIMARY) {
                                                net.minecraft.world.item.ItemStack carried = this.getCarried();
                                                this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
                                                entityhuman.drop(carried, true);
                                            } else {
                                                entityhuman.drop(this.getCarried().split(1), true);
                                            }
                                            break block48;
                                        }
                                        if (inventoryclicktype != ClickType.QUICK_MOVE) break block55;
                                        if (i < 0) {
                                            return;
                                        }
                                        Slot slot2 = this.slots.get(i);
                                        if (!slot2.mayPickup(entityhuman)) {
                                            return;
                                        }
                                        net.minecraft.world.item.ItemStack itemstack3 = this.quickMoveStack(entityhuman, i);
                                        while (!itemstack3.isEmpty() && net.minecraft.world.item.ItemStack.isSameItem(slot2.getItem(), itemstack3)) {
                                            itemstack3 = this.quickMoveStack(entityhuman, i);
                                        }
                                        break block48;
                                    }
                                    if (i < 0) {
                                        return;
                                    }
                                    Slot slot3 = this.slots.get(i);
                                    net.minecraft.world.item.ItemStack itemstack4 = slot3.getItem();
                                    net.minecraft.world.item.ItemStack itemstack5 = this.getCarried();
                                    entityhuman.updateTutorialInventoryAction(itemstack5, slot3.getItem(), clickaction);
                                    if (!this.tryItemClickBehaviourOverride(entityhuman, clickaction, slot3, itemstack4, itemstack5)) {
                                        if (itemstack4.isEmpty()) {
                                            if (!itemstack5.isEmpty()) {
                                                int i2 = clickaction == ClickAction.PRIMARY ? itemstack5.getCount() : 1;
                                                this.setCarried(slot3.safeInsert(itemstack5, i2));
                                            }
                                        } else if (slot3.mayPickup(entityhuman)) {
                                            if (itemstack5.isEmpty()) {
                                                int j2 = clickaction == ClickAction.PRIMARY ? itemstack4.getCount() : (itemstack4.getCount() + 1) / 2;
                                                Optional<net.minecraft.world.item.ItemStack> optional = slot3.tryRemove(j2, Integer.MAX_VALUE, entityhuman);
                                                optional.ifPresent(itemstack6 -> {
                                                    this.setCarried((net.minecraft.world.item.ItemStack)itemstack6);
                                                    slot3.onTake(entityhuman, (net.minecraft.world.item.ItemStack)itemstack6);
                                                });
                                            } else if (slot3.mayPlace(itemstack5)) {
                                                if (net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack4, itemstack5)) {
                                                    int k2 = clickaction == ClickAction.PRIMARY ? itemstack5.getCount() : 1;
                                                    this.setCarried(slot3.safeInsert(itemstack5, k2));
                                                } else if (itemstack5.getCount() <= slot3.getMaxStackSize(itemstack5)) {
                                                    this.setCarried(itemstack4);
                                                    slot3.setByPlayer(itemstack5);
                                                }
                                            } else if (net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack4, itemstack5)) {
                                                Optional<net.minecraft.world.item.ItemStack> optional1 = slot3.tryRemove(itemstack4.getCount(), itemstack5.getMaxStackSize() - itemstack5.getCount(), entityhuman);
                                                optional1.ifPresent(itemstack6 -> {
                                                    itemstack5.grow(itemstack6.getCount());
                                                    slot3.onTake(entityhuman, (net.minecraft.world.item.ItemStack)itemstack6);
                                                });
                                            }
                                        }
                                    }
                                    slot3.setChanged();
                                    if (!(entityhuman instanceof ServerPlayer) || slot3.getMaxStackSize() == 99) break block48;
                                    ((ServerPlayer)entityhuman).connection.send(new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), slot3.index, slot3.getItem()));
                                    if (this.getBukkitView().getType() == InventoryType.WORKBENCH || this.getBukkitView().getType() == InventoryType.CRAFTING) {
                                        ((ServerPlayer)entityhuman).connection.send(new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, this.getSlot(0).getItem()));
                                    }
                                    break block48;
                                }
                                if (inventoryclicktype != ClickType.SWAP || (j < 0 || j >= 9) && j != 40) break block56;
                                itemstack62 = playerinventory.getItem(j);
                                slot4 = this.slots.get(i);
                                itemstack7 = slot4.getItem();
                                if (itemstack62.isEmpty() && itemstack7.isEmpty()) break block48;
                                if (!itemstack62.isEmpty()) break block57;
                                if (!slot4.mayPickup(entityhuman)) break block48;
                                playerinventory.setItem(j, itemstack7);
                                slot4.onSwapCraft(itemstack7.getCount());
                                slot4.setByPlayer(net.minecraft.world.item.ItemStack.EMPTY);
                                slot4.onTake(entityhuman, itemstack7);
                                break block48;
                            }
                            if (!itemstack7.isEmpty()) break block58;
                            if (!slot4.mayPlace(itemstack62)) break block48;
                            int l2 = slot4.getMaxStackSize(itemstack62);
                            if (itemstack62.getCount() > l2) {
                                slot4.setByPlayer(itemstack62.split(l2));
                            } else {
                                playerinventory.setItem(j, net.minecraft.world.item.ItemStack.EMPTY);
                                slot4.setByPlayer(itemstack62);
                            }
                            break block48;
                        }
                        if (!slot4.mayPickup(entityhuman) || !slot4.mayPlace(itemstack62)) break block48;
                        int i3 = slot4.getMaxStackSize(itemstack62);
                        if (itemstack62.getCount() <= i3) break block59;
                        slot4.setByPlayer(itemstack62.split(i3));
                        slot4.onTake(entityhuman, itemstack7);
                        if (playerinventory.add(itemstack7)) break block48;
                        entityhuman.drop(itemstack7, true);
                        break block48;
                    }
                    playerinventory.setItem(j, itemstack7);
                    slot4.setByPlayer(itemstack62);
                    slot4.onTake(entityhuman, itemstack7);
                    break block48;
                }
                if (inventoryclicktype != ClickType.CLONE || !entityhuman.hasInfiniteMaterials() || !this.getCarried().isEmpty() || i < 0) break block60;
                Slot slot5 = this.slots.get(i);
                if (!slot5.hasItem()) break block48;
                net.minecraft.world.item.ItemStack itemstack8 = slot5.getItem();
                this.setCarried(itemstack8.copyWithCount(itemstack8.getMaxStackSize()));
                break block48;
            }
            if (inventoryclicktype == ClickType.THROW && this.getCarried().isEmpty() && i >= 0) {
                int j3;
                Slot slot6 = this.slots.get(i);
                int n = j3 = j == 0 ? 1 : slot6.getItem().getCount();
                if (!entityhuman.canDropItems()) {
                    return;
                }
                net.minecraft.world.item.ItemStack itemstack9 = slot6.safeTake(j3, Integer.MAX_VALUE, entityhuman);
                entityhuman.drop(itemstack9, true);
                entityhuman.handleCreativeModeItemDrop(itemstack9);
                if (j == 1) {
                    while (!itemstack9.isEmpty() && net.minecraft.world.item.ItemStack.isSameItem(slot6.getItem(), itemstack9)) {
                        if (!entityhuman.canDropItems()) {
                            return;
                        }
                        itemstack9 = slot6.safeTake(j3, Integer.MAX_VALUE, entityhuman);
                        if (entityhuman.drop(itemstack9, true) != null) {
                            entityhuman.handleCreativeModeItemDrop(itemstack9);
                            continue;
                        }
                        break;
                    }
                }
            } else if (inventoryclicktype == ClickType.PICKUP_ALL && i >= 0) {
                Slot slot7 = this.slots.get(i);
                net.minecraft.world.item.ItemStack itemstack10 = this.getCarried();
                if (!(itemstack10.isEmpty() || slot7.hasItem() && slot7.mayPickup(entityhuman))) {
                    int k3 = j == 0 ? 0 : this.slots.size() - 1;
                    int l3 = j == 0 ? 1 : -1;
                    for (int i4 = 0; i4 < 2; ++i4) {
                        for (int j4 = k3; j4 >= 0 && j4 < this.slots.size() && itemstack10.getCount() < itemstack10.getMaxStackSize(); j4 += l3) {
                            Slot slot8 = this.slots.get(j4);
                            if (!slot8.hasItem() || !AbstractContainerMenu.canItemQuickReplace(slot8, itemstack10, true) || !slot8.mayPickup(entityhuman) || !this.canTakeItemForPickAll(itemstack10, slot8)) continue;
                            net.minecraft.world.item.ItemStack itemstack11 = slot8.getItem();
                            if (i4 == 0 && itemstack11.getCount() == itemstack11.getMaxStackSize()) continue;
                            net.minecraft.world.item.ItemStack itemstack12 = slot8.safeTake(itemstack11.getCount(), itemstack10.getMaxStackSize() - itemstack10.getCount(), entityhuman);
                            itemstack10.grow(itemstack12.getCount());
                        }
                    }
                }
            }
        }
    }

    private boolean tryItemClickBehaviourOverride(Player entityhuman, ClickAction clickaction, Slot slot, net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
        FeatureFlagSet featureflagset = entityhuman.level().enabledFeatures();
        return itemstack1.isItemEnabled(featureflagset) && itemstack1.overrideStackedOnOther(slot, clickaction, entityhuman) ? true : itemstack.isItemEnabled(featureflagset) && itemstack.overrideOtherStackedOnMe(itemstack1, slot, clickaction, entityhuman, this.createCarriedSlotAccess());
    }

    private SlotAccess createCarriedSlotAccess() {
        return new SlotAccess(){

            @Override
            public net.minecraft.world.item.ItemStack get() {
                return AbstractContainerMenu.this.getCarried();
            }

            @Override
            public boolean set(net.minecraft.world.item.ItemStack itemstack) {
                AbstractContainerMenu.this.setCarried(itemstack);
                return true;
            }
        };
    }

    public boolean canTakeItemForPickAll(net.minecraft.world.item.ItemStack itemstack, Slot slot) {
        return true;
    }

    public void removed(Player entityhuman) {
        net.minecraft.world.item.ItemStack itemstack;
        if (entityhuman instanceof ServerPlayer && !(itemstack = this.getCarried()).isEmpty()) {
            this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
            AbstractContainerMenu.dropOrPlaceInInventory(entityhuman, itemstack);
        }
    }

    private static void dropOrPlaceInInventory(Player entityhuman, net.minecraft.world.item.ItemStack itemstack) {
        ServerPlayer entityplayer;
        boolean flag = entityhuman.isRemoved() && entityhuman.getRemovalReason() != Entity.RemovalReason.CHANGED_DIMENSION;
        boolean flag1 = entityhuman instanceof ServerPlayer && (entityplayer = (ServerPlayer)entityhuman).hasDisconnected();
        boolean flag2 = flag1;
        if (!flag && !flag2) {
            if (entityhuman instanceof ServerPlayer) {
                entityhuman.getInventory().placeItemBackInInventory(itemstack);
            }
        } else {
            entityhuman.drop(itemstack, false);
        }
    }

    protected void clearContainer(Player entityhuman, Container iinventory) {
        for (int i = 0; i < iinventory.getContainerSize(); ++i) {
            AbstractContainerMenu.dropOrPlaceInInventory(entityhuman, iinventory.removeItemNoUpdate(i));
        }
    }

    public void slotsChanged(Container iinventory) {
        this.broadcastChanges();
    }

    public void setItem(int i, int j, net.minecraft.world.item.ItemStack itemstack) {
        this.getSlot(i).set(itemstack);
        this.stateId = j;
    }

    public void initializeContents(int i, List<net.minecraft.world.item.ItemStack> list, net.minecraft.world.item.ItemStack itemstack) {
        for (int j = 0; j < list.size(); ++j) {
            this.getSlot(j).set(list.get(j));
        }
        this.carried = itemstack;
        this.stateId = i;
    }

    public void setData(int i, int j) {
        this.dataSlots.get(i).set(j);
    }

    public abstract boolean stillValid(Player var1);

    protected boolean moveItemStackTo(net.minecraft.world.item.ItemStack itemstack, int i, int j, boolean flag) {
        boolean flag1 = false;
        int k = i;
        if (flag) {
            k = j - 1;
        }
        if (itemstack.isStackable()) {
            while (!itemstack.isEmpty() && !(!flag ? k >= j : k < i)) {
                Slot slot = this.slots.get(k);
                net.minecraft.world.item.ItemStack itemstack1 = slot.getItem();
                if (!itemstack1.isEmpty() && net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack, itemstack1)) {
                    int i1;
                    int l = itemstack1.getCount() + itemstack.getCount();
                    if (l <= (i1 = slot.getMaxStackSize(itemstack1))) {
                        itemstack.setCount(0);
                        itemstack1.setCount(l);
                        slot.setChanged();
                        flag1 = true;
                    } else if (itemstack1.getCount() < i1) {
                        itemstack.shrink(i1 - itemstack1.getCount());
                        itemstack1.setCount(i1);
                        slot.setChanged();
                        flag1 = true;
                    }
                }
                if (flag) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        if (!itemstack.isEmpty()) {
            k = flag ? j - 1 : i;
            while (!(!flag ? k >= j : k < i)) {
                Slot slot1 = this.slots.get(k);
                net.minecraft.world.item.ItemStack itemstack2 = slot1.getItem();
                if (itemstack2.isEmpty() && slot1.mayPlace(itemstack)) {
                    int j1 = slot1.getMaxStackSize(itemstack);
                    slot1.setByPlayer(itemstack.split(Math.min(itemstack.getCount(), j1)));
                    slot1.setChanged();
                    flag1 = true;
                    break;
                }
                if (flag) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    public static int getQuickcraftType(int i) {
        return i >> 2 & 3;
    }

    public static int getQuickcraftHeader(int i) {
        return i & 3;
    }

    public static int getQuickcraftMask(int i, int j) {
        return i & 3 | (j & 3) << 2;
    }

    public static boolean isValidQuickcraftType(int i, Player entityhuman) {
        return i == 0 ? true : (i == 1 ? true : i == 2 && entityhuman.hasInfiniteMaterials());
    }

    protected void resetQuickCraft() {
        this.quickcraftStatus = 0;
        this.quickcraftSlots.clear();
    }

    public static boolean canItemQuickReplace(@Nullable Slot slot, net.minecraft.world.item.ItemStack itemstack, boolean flag) {
        boolean flag1;
        boolean bl = flag1 = slot == null || !slot.hasItem();
        return !flag1 && net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack, slot.getItem()) ? slot.getItem().getCount() + (flag ? 0 : itemstack.getCount()) <= itemstack.getMaxStackSize() : flag1;
    }

    public static int getQuickCraftPlaceCount(Set<Slot> set, int i, net.minecraft.world.item.ItemStack itemstack) {
        return switch (i) {
            case 0 -> Mth.floor((float)itemstack.getCount() / (float)set.size());
            case 1 -> 1;
            case 2 -> itemstack.getMaxStackSize();
            default -> itemstack.getCount();
        };
    }

    public boolean canDragTo(Slot slot) {
        return true;
    }

    public static int getRedstoneSignalFromBlockEntity(@Nullable BlockEntity tileentity) {
        return tileentity instanceof Container ? AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Object)tileentity)) : 0;
    }

    public static int getRedstoneSignalFromContainer(@Nullable Container iinventory) {
        if (iinventory == null) {
            return 0;
        }
        float f = 0.0f;
        for (int i = 0; i < iinventory.getContainerSize(); ++i) {
            net.minecraft.world.item.ItemStack itemstack = iinventory.getItem(i);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)iinventory.getMaxStackSize(itemstack);
        }
        return Mth.lerpDiscrete(f /= (float)iinventory.getContainerSize(), 0, 15);
    }

    public void setCarried(net.minecraft.world.item.ItemStack itemstack) {
        this.carried = itemstack;
    }

    public net.minecraft.world.item.ItemStack getCarried() {
        if (this.carried.isEmpty()) {
            this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
        }
        return this.carried;
    }

    public void suppressRemoteUpdates() {
        this.suppressRemoteUpdates = true;
    }

    public void resumeRemoteUpdates() {
        this.suppressRemoteUpdates = false;
    }

    public void transferState(AbstractContainerMenu container) {
        HashBasedTable table = HashBasedTable.create();
        for (int i = 0; i < container.slots.size(); ++i) {
            Slot slot = container.slots.get(i);
            table.put((Object)slot.container, (Object)slot.getContainerSlot(), (Object)i);
        }
        for (int j = 0; j < this.slots.size(); ++j) {
            Slot slot1 = this.slots.get(j);
            Integer integer = (Integer)table.get((Object)slot1.container, (Object)slot1.getContainerSlot());
            if (integer == null) continue;
            this.lastSlots.set(j, container.lastSlots.get(integer));
            RemoteSlot remoteslot = container.remoteSlots.get(integer);
            RemoteSlot remoteslot1 = this.remoteSlots.get(j);
            if (!(remoteslot instanceof RemoteSlot.Synchronized)) continue;
            RemoteSlot.Synchronized remoteslot_a = (RemoteSlot.Synchronized)remoteslot;
            if (!(remoteslot1 instanceof RemoteSlot.Synchronized)) continue;
            RemoteSlot.Synchronized remoteslot_a1 = (RemoteSlot.Synchronized)remoteslot1;
            remoteslot_a1.copyFrom(remoteslot_a);
        }
    }

    public OptionalInt findSlot(Container iinventory, int i) {
        for (int j = 0; j < this.slots.size(); ++j) {
            Slot slot = this.slots.get(j);
            if (slot.container != iinventory || i != slot.getContainerSlot()) continue;
            return OptionalInt.of(j);
        }
        return OptionalInt.empty();
    }

    public int getStateId() {
        return this.stateId;
    }

    public int incrementStateId() {
        this.stateId = this.stateId + 1 & Short.MAX_VALUE;
        return this.stateId;
    }
}

