/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

class ArmorSlot
extends Slot {
    private final LivingEntity owner;
    private final EquipmentSlot slot;
    @Nullable
    private final ResourceLocation emptyIcon;

    public ArmorSlot(Container var0, LivingEntity var1, EquipmentSlot var2, int var3, int var4, int var5, @Nullable ResourceLocation var6) {
        super(var0, var3, var4, var5);
        this.owner = var1;
        this.slot = var2;
        this.emptyIcon = var6;
    }

    @Override
    public void setByPlayer(ItemStack var0, ItemStack var1) {
        this.owner.onEquipItem(this.slot, var1, var0);
        super.setByPlayer(var0, var1);
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean mayPlace(ItemStack var0) {
        return this.owner.isEquippableInSlot(var0, this.slot);
    }

    @Override
    public boolean isActive() {
        return this.owner.canUseSlot(this.slot);
    }

    @Override
    public boolean mayPickup(Player var0) {
        ItemStack var1 = this.getItem();
        if (!var1.isEmpty() && !var0.isCreative() && EnchantmentHelper.has(var1, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
            return false;
        }
        return super.mayPickup(var0);
    }

    @Override
    @Nullable
    public ResourceLocation getNoItemIcon() {
        return this.emptyIcon;
    }
}

