/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryView;

public class HopperMenu
extends AbstractContainerMenu {
    public static final int CONTAINER_SIZE = 5;
    private final Container hopper;
    private CraftInventoryView bukkitEntity = null;
    private Inventory player;

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventory inventory = new CraftInventory(this.hopper);
        this.bukkitEntity = new CraftInventoryView<HopperMenu, CraftInventory>(this.player.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }

    public HopperMenu(int i, Inventory playerinventory) {
        this(i, playerinventory, new SimpleContainer(5));
    }

    public HopperMenu(int i, Inventory playerinventory, Container iinventory) {
        super(MenuType.HOPPER, i);
        this.hopper = iinventory;
        this.player = playerinventory;
        HopperMenu.checkContainerSize(iinventory, 5);
        iinventory.startOpen(playerinventory.player);
        for (int j = 0; j < 5; ++j) {
            this.addSlot(new Slot(iinventory, j, 44 + j * 18, 20));
        }
        this.addStandardInventorySlots(playerinventory, 8, 51);
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.hopper.stillValid(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i < this.hopper.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.hopper.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.hopper.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void removed(Player entityhuman) {
        super.removed(entityhuman);
        this.hopper.stopOpen(entityhuman);
    }
}

