/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftVector;
import org.bukkit.event.entity.EntityKnockbackEvent;

public class MaceItem
extends Item {
    private static final int DEFAULT_ATTACK_DAMAGE = 5;
    private static final float DEFAULT_ATTACK_SPEED = -3.4f;
    public static final float SMASH_ATTACK_FALL_THRESHOLD = 1.5f;
    private static final float SMASH_ATTACK_HEAVY_THRESHOLD = 5.0f;
    public static final float SMASH_ATTACK_KNOCKBACK_RADIUS = 3.5f;
    private static final float SMASH_ATTACK_KNOCKBACK_POWER = 0.7f;

    public MaceItem(Item.Properties item_info) {
        super(item_info);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -3.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2, false);
    }

    @Override
    public void hurtEnemy(ItemStack itemstack, LivingEntity entityliving, LivingEntity entityliving1) {
        if (MaceItem.canSmashAttack(entityliving1)) {
            ServerLevel worldserver = (ServerLevel)entityliving1.level();
            entityliving1.setDeltaMovement(entityliving1.getDeltaMovement().with(Direction.Axis.Y, 0.01f));
            if (entityliving1 instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entityliving1;
                entityplayer.currentImpulseImpactPos = this.calculateImpactPosition(entityplayer);
                entityplayer.setIgnoreFallDamageFromCurrentImpulse(true);
                entityplayer.connection.send(new ClientboundSetEntityMotionPacket(entityplayer));
            }
            if (entityliving.onGround()) {
                if (entityliving1 instanceof ServerPlayer) {
                    ServerPlayer entityplayer1 = (ServerPlayer)entityliving1;
                    entityplayer1.setSpawnExtraParticlesOnFall(true);
                }
                SoundEvent soundeffect = entityliving1.fallDistance > 5.0 ? SoundEvents.MACE_SMASH_GROUND_HEAVY : SoundEvents.MACE_SMASH_GROUND;
                worldserver.playSound((Entity)null, entityliving1.getX(), entityliving1.getY(), entityliving1.getZ(), soundeffect, entityliving1.getSoundSource(), 1.0f, 1.0f);
            } else {
                worldserver.playSound((Entity)null, entityliving1.getX(), entityliving1.getY(), entityliving1.getZ(), SoundEvents.MACE_SMASH_AIR, entityliving1.getSoundSource(), 1.0f, 1.0f);
            }
            MaceItem.knockback(worldserver, entityliving1, entityliving);
        }
    }

    private Vec3 calculateImpactPosition(ServerPlayer entityplayer) {
        return entityplayer.isIgnoringFallDamageFromCurrentImpulse() && entityplayer.currentImpulseImpactPos != null && entityplayer.currentImpulseImpactPos.y <= entityplayer.position().y ? entityplayer.currentImpulseImpactPos : entityplayer.position();
    }

    @Override
    public void postHurtEnemy(ItemStack itemstack, LivingEntity entityliving, LivingEntity entityliving1) {
        if (MaceItem.canSmashAttack(entityliving1)) {
            entityliving1.resetFallDistance();
        }
    }

    @Override
    public float getAttackDamageBonus(Entity entity, float f, DamageSource damagesource) {
        Entity entity1 = damagesource.getDirectEntity();
        if (entity1 instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity1;
            if (!MaceItem.canSmashAttack(entityliving)) {
                return 0.0f;
            }
            double d0 = 3.0;
            double d1 = 8.0;
            double d2 = entityliving.fallDistance;
            double d3 = d2 <= 3.0 ? 4.0 * d2 : (d2 <= 8.0 ? 12.0 + 2.0 * (d2 - 3.0) : 22.0 + d2 - 8.0);
            Level world = entityliving.level();
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                return (float)(d3 + (double)EnchantmentHelper.modifyFallBasedDamage(worldserver, entityliving.getWeaponItem(), entity, damagesource, 0.0f) * d2);
            }
            return (float)d3;
        }
        return 0.0f;
    }

    private static void knockback(Level world, Entity entity, Entity entity1) {
        world.levelEvent(2013, entity1.getOnPos(), 750);
        world.getEntitiesOfClass(LivingEntity.class, entity1.getBoundingBox().inflate(3.5), MaceItem.knockbackPredicate(entity, entity1)).forEach(entityliving -> {
            Vec3 vec3d = entityliving.position().subtract(entity1.position());
            double d0 = MaceItem.getKnockbackPower(entity, entityliving, vec3d);
            Vec3 vec3d1 = vec3d.normalize().scale(d0);
            if (d0 > 0.0) {
                Vec3 vec3dPush = new Vec3(vec3d1.x, 0.7f, vec3d1.z);
                Vec3 result = entity.getDeltaMovement().add(vec3dPush);
                EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)entityliving.getBukkitEntity(), entity, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK, d0, result, vec3dPush.x, vec3dPush.y, vec3dPush.z);
                if (!event.isCancelled()) {
                    entityliving.push(CraftVector.toNMS(event.getFinalKnockback()));
                }
                if (entityliving instanceof ServerPlayer) {
                    ServerPlayer entityplayer = (ServerPlayer)entityliving;
                    entityplayer.connection.send(new ClientboundSetEntityMotionPacket(entityplayer));
                }
            }
        });
    }

    private static Predicate<LivingEntity> knockbackPredicate(Entity entity, Entity entity1) {
        return arg_0 -> MaceItem.lambda$knockbackPredicate$1(entity, entity1, arg_0);
    }

    private static double getKnockbackPower(Entity entity, LivingEntity entityliving, Vec3 vec3d) {
        return (3.5 - vec3d.length()) * (double)0.7f * (double)(entity.fallDistance > 5.0 ? 2 : 1) * (1.0 - entityliving.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(LivingEntity entityliving) {
        return entityliving.fallDistance > 1.5 && !entityliving.isFallFlying();
    }

    @Override
    @Nullable
    public DamageSource getDamageSource(LivingEntity entityliving) {
        return MaceItem.canSmashAttack(entityliving) ? entityliving.damageSources().mace(entityliving) : super.getDamageSource(entityliving);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$knockbackPredicate$1(Entity entity, Entity entity1, LivingEntity entityliving) {
        flag = entityliving.isSpectator() == false;
        flag1 = entityliving != entity && entityliving != entity1;
        v0 = flag2 = entity.isAlliedTo(entityliving) == false;
        if (!(entityliving instanceof TamableAnimal)) ** GOTO lbl-1000
        entitytameableanimal = (TamableAnimal)entityliving;
        if (!(entity1 instanceof LivingEntity)) ** GOTO lbl-1000
        entityliving1 = (LivingEntity)entity1;
        if (entitytameableanimal.isTame() && entitytameableanimal.isOwnedBy(entityliving1)) {
            flag3 = true;
        } else lbl-1000:
        // 3 sources

        {
            flag3 = false;
        }
        flag4 = flag3 == false;
        flag3 = entityliving instanceof ArmorStand == false || (entityarmorstand = (ArmorStand)entityliving).isMarker() == false;
        flag5 = flag3;
        flag6 = entity1.distanceToSqr(entityliving) <= Math.pow(3.5, 2.0);
        return flag != false && flag1 != false && flag2 != false && flag4 != false && flag5 != false && flag6 != false;
    }
}

