/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.context;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockPlaceContext
extends UseOnContext {
    private final BlockPos relativePos;
    protected boolean replaceClicked = true;

    public BlockPlaceContext(Player var0, InteractionHand var1, ItemStack var2, BlockHitResult var3) {
        this(var0.level(), var0, var1, var2, var3);
    }

    public BlockPlaceContext(UseOnContext var0) {
        this(var0.getLevel(), var0.getPlayer(), var0.getHand(), var0.getItemInHand(), var0.getHitResult());
    }

    protected BlockPlaceContext(Level var0, @Nullable Player var1, InteractionHand var2, ItemStack var3, BlockHitResult var4) {
        super(var0, var1, var2, var3, var4);
        this.relativePos = var4.getBlockPos().relative(var4.getDirection());
        this.replaceClicked = var0.getBlockState(var4.getBlockPos()).canBeReplaced(this);
    }

    public static BlockPlaceContext at(BlockPlaceContext var0, BlockPos var1, Direction var2) {
        return new BlockPlaceContext(var0.getLevel(), var0.getPlayer(), var0.getHand(), var0.getItemInHand(), new BlockHitResult(new Vec3((double)var1.getX() + 0.5 + (double)var2.getStepX() * 0.5, (double)var1.getY() + 0.5 + (double)var2.getStepY() * 0.5, (double)var1.getZ() + 0.5 + (double)var2.getStepZ() * 0.5), var2, var1, false));
    }

    @Override
    public BlockPos getClickedPos() {
        return this.replaceClicked ? super.getClickedPos() : this.relativePos;
    }

    public boolean canPlace() {
        return this.replaceClicked || this.getLevel().getBlockState(this.getClickedPos()).canBeReplaced(this);
    }

    public boolean replacingClickedOnBlock() {
        return this.replaceClicked;
    }

    public Direction getNearestLookingDirection() {
        return Direction.orderedByNearest(this.getPlayer())[0];
    }

    public Direction getNearestLookingVerticalDirection() {
        return Direction.getFacingAxis(this.getPlayer(), Direction.Axis.Y);
    }

    public Direction[] getNearestLookingDirections() {
        int var2;
        Direction[] var0 = Direction.orderedByNearest(this.getPlayer());
        if (this.replaceClicked) {
            return var0;
        }
        Direction var1 = this.getClickedFace();
        for (var2 = 0; var2 < var0.length && var0[var2] != var1.getOpposite(); ++var2) {
        }
        if (var2 > 0) {
            System.arraycopy(var0, 0, var0, 1, var2);
            var0[0] = var1.getOpposite();
        }
        return var0;
    }
}

