/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;

public class DecoratedPotRecipe
extends CustomRecipe {
    public DecoratedPotRecipe(CraftingBookCategory var0) {
        super(var0);
    }

    private static ItemStack back(CraftingInput var0) {
        return var0.getItem(1, 0);
    }

    private static ItemStack left(CraftingInput var0) {
        return var0.getItem(0, 1);
    }

    private static ItemStack right(CraftingInput var0) {
        return var0.getItem(2, 1);
    }

    private static ItemStack front(CraftingInput var0) {
        return var0.getItem(1, 2);
    }

    @Override
    public boolean matches(CraftingInput var0, Level var1) {
        if (var0.width() != 3 || var0.height() != 3 || var0.ingredientCount() != 4) {
            return false;
        }
        return DecoratedPotRecipe.back(var0).is(ItemTags.DECORATED_POT_INGREDIENTS) && DecoratedPotRecipe.left(var0).is(ItemTags.DECORATED_POT_INGREDIENTS) && DecoratedPotRecipe.right(var0).is(ItemTags.DECORATED_POT_INGREDIENTS) && DecoratedPotRecipe.front(var0).is(ItemTags.DECORATED_POT_INGREDIENTS);
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.Provider var1) {
        PotDecorations var2 = new PotDecorations(DecoratedPotRecipe.back(var0).getItem(), DecoratedPotRecipe.left(var0).getItem(), DecoratedPotRecipe.right(var0).getItem(), DecoratedPotRecipe.front(var0).getItem());
        return DecoratedPotBlockEntity.createDecoratedPotItem(var2);
    }

    @Override
    public RecipeSerializer<DecoratedPotRecipe> getSerializer() {
        return RecipeSerializer.DECORATED_POT_RECIPE;
    }
}

