/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public interface LevelReader
extends BlockAndTintGetter,
CollisionGetter,
SignalGetter,
BiomeManager.NoiseBiomeSource {
    @Nullable
    public ChunkAccess getChunk(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    public boolean hasChunk(int var1, int var2);

    public int getHeight(Heightmap.Types var1, int var2, int var3);

    default public int getHeight(Heightmap.Types var0, BlockPos var1) {
        return this.getHeight(var0, var1.getX(), var1.getZ());
    }

    public int getSkyDarken();

    public BiomeManager getBiomeManager();

    default public Holder<Biome> getBiome(BlockPos var0) {
        return this.getBiomeManager().getBiome(var0);
    }

    default public Stream<BlockState> getBlockStatesIfLoaded(AABB var0) {
        int var6;
        int var1 = Mth.floor(var0.minX);
        int var2 = Mth.floor(var0.maxX);
        int var3 = Mth.floor(var0.minY);
        int var4 = Mth.floor(var0.maxY);
        int var5 = Mth.floor(var0.minZ);
        if (this.hasChunksAt(var1, var3, var5, var2, var4, var6 = Mth.floor(var0.maxZ))) {
            return this.getBlockStates(var0);
        }
        return Stream.empty();
    }

    @Override
    default public int getBlockTint(BlockPos var0, ColorResolver var1) {
        return var1.getColor(this.getBiome(var0).value(), var0.getX(), var0.getZ());
    }

    @Override
    default public Holder<Biome> getNoiseBiome(int var0, int var1, int var2) {
        ChunkAccess var3 = this.getChunk(QuartPos.toSection(var0), QuartPos.toSection(var2), ChunkStatus.BIOMES, false);
        if (var3 != null) {
            return var3.getNoiseBiome(var0, var1, var2);
        }
        return this.getUncachedNoiseBiome(var0, var1, var2);
    }

    public Holder<Biome> getUncachedNoiseBiome(int var1, int var2, int var3);

    public boolean isClientSide();

    public int getSeaLevel();

    public DimensionType dimensionType();

    @Override
    default public int getMinY() {
        return this.dimensionType().minY();
    }

    @Override
    default public int getHeight() {
        return this.dimensionType().height();
    }

    default public BlockPos getHeightmapPos(Heightmap.Types var0, BlockPos var1) {
        return new BlockPos(var1.getX(), this.getHeight(var0, var1.getX(), var1.getZ()), var1.getZ());
    }

    default public boolean isEmptyBlock(BlockPos var0) {
        return this.getBlockState(var0).isAir();
    }

    default public boolean canSeeSkyFromBelowWater(BlockPos var0) {
        if (var0.getY() >= this.getSeaLevel()) {
            return this.canSeeSky(var0);
        }
        BlockPos var1 = new BlockPos(var0.getX(), this.getSeaLevel(), var0.getZ());
        if (!this.canSeeSky(var1)) {
            return false;
        }
        var1 = var1.below();
        while (var1.getY() > var0.getY()) {
            BlockState var2 = this.getBlockState(var1);
            if (var2.getLightBlock() > 0 && !var2.liquid()) {
                return false;
            }
            var1 = var1.below();
        }
        return true;
    }

    default public float getPathfindingCostFromLightLevels(BlockPos var0) {
        return this.getLightLevelDependentMagicValue(var0) - 0.5f;
    }

    @Deprecated
    default public float getLightLevelDependentMagicValue(BlockPos var0) {
        float var1 = (float)this.getMaxLocalRawBrightness(var0) / 15.0f;
        float var2 = var1 / (4.0f - 3.0f * var1);
        return Mth.lerp(this.dimensionType().ambientLight(), var2, 1.0f);
    }

    default public ChunkAccess getChunk(BlockPos var0) {
        return this.getChunk(SectionPos.blockToSectionCoord(var0.getX()), SectionPos.blockToSectionCoord(var0.getZ()));
    }

    default public ChunkAccess getChunk(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.FULL, true);
    }

    default public ChunkAccess getChunk(int var0, int var1, ChunkStatus var2) {
        return this.getChunk(var0, var1, var2, true);
    }

    @Override
    @Nullable
    default public BlockGetter getChunkForCollisions(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.EMPTY, false);
    }

    default public boolean isWaterAt(BlockPos var0) {
        return this.getFluidState(var0).is(FluidTags.WATER);
    }

    default public boolean containsAnyLiquid(AABB var0) {
        int var1 = Mth.floor(var0.minX);
        int var2 = Mth.ceil(var0.maxX);
        int var3 = Mth.floor(var0.minY);
        int var4 = Mth.ceil(var0.maxY);
        int var5 = Mth.floor(var0.minZ);
        int var6 = Mth.ceil(var0.maxZ);
        BlockPos.MutableBlockPos var7 = new BlockPos.MutableBlockPos();
        for (int var8 = var1; var8 < var2; ++var8) {
            for (int var9 = var3; var9 < var4; ++var9) {
                for (int var10 = var5; var10 < var6; ++var10) {
                    BlockState var11 = this.getBlockState(var7.set(var8, var9, var10));
                    if (var11.getFluidState().isEmpty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    default public int getMaxLocalRawBrightness(BlockPos var0) {
        return this.getMaxLocalRawBrightness(var0, this.getSkyDarken());
    }

    default public int getMaxLocalRawBrightness(BlockPos var0, int var1) {
        if (var0.getX() < -30000000 || var0.getZ() < -30000000 || var0.getX() >= 30000000 || var0.getZ() >= 30000000) {
            return 15;
        }
        return this.getRawBrightness(var0, var1);
    }

    @Deprecated
    default public boolean hasChunkAt(int var0, int var1) {
        return this.hasChunk(SectionPos.blockToSectionCoord(var0), SectionPos.blockToSectionCoord(var1));
    }

    @Deprecated
    default public boolean hasChunkAt(BlockPos var0) {
        return this.hasChunkAt(var0.getX(), var0.getZ());
    }

    @Deprecated
    default public boolean hasChunksAt(BlockPos var0, BlockPos var1) {
        return this.hasChunksAt(var0.getX(), var0.getY(), var0.getZ(), var1.getX(), var1.getY(), var1.getZ());
    }

    @Deprecated
    default public boolean hasChunksAt(int var0, int var1, int var2, int var3, int var4, int var5) {
        if (var4 < this.getMinY() || var1 > this.getMaxY()) {
            return false;
        }
        return this.hasChunksAt(var0, var2, var3, var5);
    }

    @Deprecated
    default public boolean hasChunksAt(int var0, int var1, int var2, int var3) {
        int var4 = SectionPos.blockToSectionCoord(var0);
        int var5 = SectionPos.blockToSectionCoord(var2);
        int var6 = SectionPos.blockToSectionCoord(var1);
        int var7 = SectionPos.blockToSectionCoord(var3);
        for (int var8 = var4; var8 <= var5; ++var8) {
            for (int var9 = var6; var9 <= var7; ++var9) {
                if (this.hasChunk(var8, var9)) continue;
                return false;
            }
        }
        return true;
    }

    public RegistryAccess registryAccess();

    public FeatureFlagSet enabledFeatures();

    default public <T> HolderLookup<T> holderLookup(ResourceKey<? extends Registry<? extends T>> var0) {
        HolderLookup.RegistryLookup var1 = this.registryAccess().lookupOrThrow((ResourceKey)var0);
        return var1.filterFeatures(this.enabledFeatures());
    }
}

