/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.WorldDataConfiguration;

public final class LevelSettings {
    public String levelName;
    private final GameType gameType;
    public boolean hardcore;
    private final Difficulty difficulty;
    private final boolean allowCommands;
    private final GameRules gameRules;
    private final WorldDataConfiguration dataConfiguration;

    public LevelSettings(String var0, GameType var1, boolean var2, Difficulty var3, boolean var4, GameRules var5, WorldDataConfiguration var6) {
        this.levelName = var0;
        this.gameType = var1;
        this.hardcore = var2;
        this.difficulty = var3;
        this.allowCommands = var4;
        this.gameRules = var5;
        this.dataConfiguration = var6;
    }

    public static LevelSettings parse(Dynamic<?> var02, WorldDataConfiguration var1) {
        GameType var2 = GameType.byId(var02.get("GameType").asInt(0));
        return new LevelSettings(var02.get("LevelName").asString(""), var2, var02.get("hardcore").asBoolean(false), var02.get("Difficulty").asNumber().map(var0 -> Difficulty.byId(var0.byteValue())).result().orElse(Difficulty.NORMAL), var02.get("allowCommands").asBoolean(var2 == GameType.CREATIVE), new GameRules(var1.enabledFeatures(), (DynamicLike<?>)var02.get("GameRules")), var1);
    }

    public String levelName() {
        return this.levelName;
    }

    public GameType gameType() {
        return this.gameType;
    }

    public boolean hardcore() {
        return this.hardcore;
    }

    public Difficulty difficulty() {
        return this.difficulty;
    }

    public boolean allowCommands() {
        return this.allowCommands;
    }

    public GameRules gameRules() {
        return this.gameRules;
    }

    public WorldDataConfiguration getDataConfiguration() {
        return this.dataConfiguration;
    }

    public LevelSettings withGameType(GameType var0) {
        return new LevelSettings(this.levelName, var0, this.hardcore, this.difficulty, this.allowCommands, this.gameRules, this.dataConfiguration);
    }

    public LevelSettings withDifficulty(Difficulty var0) {
        return new LevelSettings(this.levelName, this.gameType, this.hardcore, var0, this.allowCommands, this.gameRules, this.dataConfiguration);
    }

    public LevelSettings withDataConfiguration(WorldDataConfiguration var0) {
        return new LevelSettings(this.levelName, this.gameType, this.hardcore, this.difficulty, this.allowCommands, this.gameRules, var0);
    }

    public LevelSettings copy() {
        return new LevelSettings(this.levelName, this.gameType, this.hardcore, this.difficulty, this.allowCommands, this.gameRules.copy(this.dataConfiguration.enabledFeatures()), this.dataConfiguration);
    }
}

